/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.concurrent.Threads;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.client.NodeVersion;
import io.trino.cost.StatsAndCosts;
import io.trino.execution.DynamicFilterConfig;
import io.trino.execution.MockRemoteTaskFactory;
import io.trino.execution.NodeTaskMap;
import io.trino.execution.RemoteTaskFactory;
import io.trino.execution.SqlStageExecution;
import io.trino.execution.StageId;
import io.trino.execution.StageInfo;
import io.trino.execution.buffer.OutputBuffers;
import io.trino.execution.scheduler.SplitSchedulerStats;
import io.trino.failuredetector.FailureDetector;
import io.trino.failuredetector.NoOpFailureDetector;
import io.trino.metadata.InternalNode;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataManager;
import io.trino.operator.StageExecutionDescriptor;
import io.trino.server.DynamicFilterService;
import io.trino.spi.QueryId;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.VarcharType;
import io.trino.sql.planner.Partitioning;
import io.trino.sql.planner.PartitioningHandle;
import io.trino.sql.planner.PartitioningScheme;
import io.trino.sql.planner.PlanFragment;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SystemPartitioningHandle;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.PlanFragmentId;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.RemoteSourceNode;
import io.trino.util.FinalizerService;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestSqlStageExecution {
    private ExecutorService executor;
    private ScheduledExecutorService scheduledExecutor;

    @BeforeClass
    public void setUp() {
        this.executor = Executors.newFixedThreadPool(100, Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-%s")));
        this.scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-scheduledExecutor-%s")));
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.executor.shutdownNow();
        this.executor = null;
        this.scheduledExecutor.shutdownNow();
        this.scheduledExecutor = null;
    }

    @Test(timeOut=120000L)
    public void testFinalStageInfo() throws Exception {
        for (int iteration = 0; iteration < 10; ++iteration) {
            this.testFinalStageInfoInternal();
        }
    }

    private void testFinalStageInfoInternal() throws Exception {
        NodeTaskMap nodeTaskMap = new NodeTaskMap(new FinalizerService());
        StageId stageId = new StageId(new QueryId("query"), 0);
        SqlStageExecution stage = SqlStageExecution.createSqlStageExecution((StageId)stageId, (PlanFragment)TestSqlStageExecution.createExchangePlanFragment(), (Map)ImmutableMap.of(), (RemoteTaskFactory)new MockRemoteTaskFactory(this.executor, this.scheduledExecutor), (Session)SessionTestUtils.TEST_SESSION, (boolean)true, (NodeTaskMap)nodeTaskMap, (ExecutorService)this.executor, (FailureDetector)new NoOpFailureDetector(), (DynamicFilterService)new DynamicFilterService((Metadata)MetadataManager.createTestMetadataManager(), new TypeOperators(), new DynamicFilterConfig()), (SplitSchedulerStats)new SplitSchedulerStats());
        stage.setOutputBuffers(OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.ARBITRARY));
        SettableFuture finalStageInfo = SettableFuture.create();
        stage.addFinalStageInfoListener(arg_0 -> ((SettableFuture)finalStageInfo).set(arg_0));
        CountDownLatch latch = new CountDownLatch(1000);
        Future<?> addTasksTask = this.executor.submit(() -> {
            try {
                for (int i = 0; i < 1000000; ++i) {
                    if (Thread.interrupted()) {
                        return;
                    }
                    InternalNode node = new InternalNode("source" + i, URI.create("http://10.0.0." + i / 10000 + ":" + i % 10000), NodeVersion.UNKNOWN, false);
                    stage.scheduleTask(node, i, OptionalInt.empty());
                    latch.countDown();
                }
            }
            finally {
                while (latch.getCount() > 0L) {
                    latch.countDown();
                }
            }
        });
        latch.await(1L, TimeUnit.MINUTES);
        Assert.assertFalse((boolean)stage.getStageInfo().getTasks().isEmpty());
        stage.abort();
        StageInfo stageInfo = (StageInfo)finalStageInfo.get(1L, TimeUnit.MINUTES);
        Assert.assertFalse((boolean)stageInfo.getTasks().isEmpty());
        Assert.assertTrue((boolean)stageInfo.isCompleteInfo());
        Assert.assertSame((Object)stage.getStageInfo(), (Object)stageInfo);
        addTasksTask.cancel(true);
    }

    @Test
    public void testIsAnyTaskBlocked() {
        NodeTaskMap nodeTaskMap = new NodeTaskMap(new FinalizerService());
        StageId stageId = new StageId(new QueryId("query"), 0);
        SqlStageExecution stage = SqlStageExecution.createSqlStageExecution((StageId)stageId, (PlanFragment)TestSqlStageExecution.createExchangePlanFragment(), (Map)ImmutableMap.of(), (RemoteTaskFactory)new MockRemoteTaskFactory(this.executor, this.scheduledExecutor), (Session)SessionTestUtils.TEST_SESSION, (boolean)true, (NodeTaskMap)nodeTaskMap, (ExecutorService)this.executor, (FailureDetector)new NoOpFailureDetector(), (DynamicFilterService)new DynamicFilterService((Metadata)MetadataManager.createTestMetadataManager(), new TypeOperators(), new DynamicFilterConfig()), (SplitSchedulerStats)new SplitSchedulerStats());
        stage.setOutputBuffers(OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.ARBITRARY));
        InternalNode node1 = new InternalNode("other1", URI.create("http://127.0.0.1:11"), NodeVersion.UNKNOWN, false);
        InternalNode node2 = new InternalNode("other2", URI.create("http://127.0.0.2:12"), NodeVersion.UNKNOWN, false);
        MockRemoteTaskFactory.MockRemoteTask task1 = (MockRemoteTaskFactory.MockRemoteTask)stage.scheduleTask(node1, 1, OptionalInt.empty()).get();
        MockRemoteTaskFactory.MockRemoteTask task2 = (MockRemoteTaskFactory.MockRemoteTask)stage.scheduleTask(node2, 2, OptionalInt.empty()).get();
        Assert.assertFalse((boolean)stage.isAnyTaskBlocked());
        task1.setOutputBufferOverUtilized(true);
        Assert.assertTrue((boolean)stage.isAnyTaskBlocked());
        task2.setOutputBufferOverUtilized(true);
        Assert.assertTrue((boolean)stage.isAnyTaskBlocked());
    }

    private static PlanFragment createExchangePlanFragment() {
        RemoteSourceNode planNode = new RemoteSourceNode(new PlanNodeId("exchange"), (List)ImmutableList.of((Object)new PlanFragmentId("source")), (List)ImmutableList.of((Object)new Symbol("column")), Optional.empty(), ExchangeNode.Type.REPARTITION);
        ImmutableMap.Builder types = ImmutableMap.builder();
        for (Symbol symbol : planNode.getOutputSymbols()) {
            types.put((Object)symbol, (Object)VarcharType.VARCHAR);
        }
        return new PlanFragment(new PlanFragmentId("exchange_fragment_id"), (PlanNode)planNode, (Map)types.build(), SystemPartitioningHandle.SOURCE_DISTRIBUTION, (List)ImmutableList.of((Object)planNode.getId()), new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List)ImmutableList.of()), planNode.getOutputSymbols()), StageExecutionDescriptor.ungroupedExecution(), StatsAndCosts.empty(), Optional.empty());
    }
}

