/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.base.Ticker;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.node.NodeInfo;
import io.airlift.stats.GcMonitor;
import io.airlift.stats.TestingGcMonitor;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.SessionTestUtils;
import io.trino.execution.LocationFactory;
import io.trino.execution.ScheduledSplit;
import io.trino.execution.SqlTaskManager;
import io.trino.execution.TaskId;
import io.trino.execution.TaskInfo;
import io.trino.execution.TaskManagementExecutor;
import io.trino.execution.TaskManagerConfig;
import io.trino.execution.TaskSource;
import io.trino.execution.TaskState;
import io.trino.execution.TaskStateMachine;
import io.trino.execution.TaskTestUtils;
import io.trino.execution.buffer.BufferResult;
import io.trino.execution.buffer.BufferState;
import io.trino.execution.buffer.OutputBuffers;
import io.trino.execution.buffer.SerializedPage;
import io.trino.execution.executor.TaskExecutor;
import io.trino.memory.LocalMemoryManager;
import io.trino.memory.NodeMemoryConfig;
import io.trino.memory.QueryContext;
import io.trino.memory.context.LocalMemoryContext;
import io.trino.metadata.InternalNode;
import io.trino.operator.ExchangeClient;
import io.trino.operator.ExchangeClientSupplier;
import io.trino.spi.QueryId;
import io.trino.spi.VersionEmbedder;
import io.trino.spiller.LocalSpillManager;
import io.trino.spiller.NodeSpillConfig;
import io.trino.testing.TestingSession;
import io.trino.version.EmbedVersion;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

public class TestSqlTaskManager {
    private static final TaskId TASK_ID = new TaskId("query", 0, 1);
    public static final OutputBuffers.OutputBufferId OUT = new OutputBuffers.OutputBufferId(0);
    private final TaskExecutor taskExecutor;
    private final TaskManagementExecutor taskManagementExecutor;
    private final LocalMemoryManager localMemoryManager = new LocalMemoryManager(new NodeMemoryConfig());
    private final LocalSpillManager localSpillManager = new LocalSpillManager(new NodeSpillConfig());

    public TestSqlTaskManager() {
        this.taskExecutor = new TaskExecutor(8, 16, 3, 4, Ticker.systemTicker());
        this.taskExecutor.start();
        this.taskManagementExecutor = new TaskManagementExecutor();
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.taskExecutor.stop();
        this.taskManagementExecutor.close();
    }

    @Test
    public void testEmptyQuery() {
        try (SqlTaskManager sqlTaskManager = this.createSqlTaskManager(new TaskManagerConfig());){
            TaskId taskId = TASK_ID;
            TaskInfo taskInfo = this.createTask(sqlTaskManager, taskId, OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.PARTITIONED).withNoMoreBufferIds());
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.RUNNING);
            taskInfo = sqlTaskManager.getTaskInfo(taskId);
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.RUNNING);
            taskInfo = this.createTask(sqlTaskManager, taskId, (ImmutableSet<ScheduledSplit>)ImmutableSet.of(), OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.PARTITIONED).withNoMoreBufferIds());
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.FINISHED);
            taskInfo = sqlTaskManager.getTaskInfo(taskId);
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.FINISHED);
        }
    }

    @Test(timeOut=30000L)
    public void testSimpleQuery() throws Exception {
        try (SqlTaskManager sqlTaskManager = this.createSqlTaskManager(new TaskManagerConfig());){
            TaskId taskId = TASK_ID;
            this.createTask(sqlTaskManager, taskId, (ImmutableSet<ScheduledSplit>)ImmutableSet.of((Object)TaskTestUtils.SPLIT), OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.PARTITIONED).withBuffer(OUT, 0).withNoMoreBufferIds());
            TaskInfo taskInfo = (TaskInfo)sqlTaskManager.getTaskInfo(taskId, 0L).get();
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.FLUSHING);
            BufferResult results = (BufferResult)sqlTaskManager.getTaskResults(taskId, OUT, 0L, DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).get();
            Assert.assertFalse((boolean)results.isBufferComplete());
            Assert.assertEquals((int)results.getSerializedPages().size(), (int)1);
            Assert.assertEquals((int)((SerializedPage)results.getSerializedPages().get(0)).getPositionCount(), (int)1);
            boolean moreResults = true;
            while (moreResults) {
                moreResults = !(results = (BufferResult)sqlTaskManager.getTaskResults(taskId, OUT, results.getToken() + (long)results.getSerializedPages().size(), DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE)).get()).isBufferComplete();
            }
            Assert.assertTrue((boolean)results.isBufferComplete());
            Assert.assertEquals((int)results.getSerializedPages().size(), (int)0);
            TaskInfo info = sqlTaskManager.abortTaskResults(taskId, OUT);
            Assert.assertEquals((Object)info.getOutputBuffers().getState(), (Object)BufferState.FINISHED);
            taskInfo = (TaskInfo)sqlTaskManager.getTaskInfo(taskId, taskInfo.getTaskStatus().getVersion()).get();
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.FINISHED);
            taskInfo = sqlTaskManager.getTaskInfo(taskId);
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.FINISHED);
        }
    }

    @Test
    public void testCancel() {
        try (SqlTaskManager sqlTaskManager = this.createSqlTaskManager(new TaskManagerConfig());){
            TaskId taskId = TASK_ID;
            TaskInfo taskInfo = this.createTask(sqlTaskManager, taskId, OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.PARTITIONED).withBuffer(OUT, 0).withNoMoreBufferIds());
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.RUNNING);
            Assert.assertNull((Object)taskInfo.getStats().getEndTime());
            taskInfo = sqlTaskManager.getTaskInfo(taskId);
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.RUNNING);
            Assert.assertNull((Object)taskInfo.getStats().getEndTime());
            taskInfo = sqlTaskManager.cancelTask(taskId);
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.CANCELED);
            Assert.assertNotNull((Object)taskInfo.getStats().getEndTime());
            taskInfo = sqlTaskManager.getTaskInfo(taskId);
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.CANCELED);
            Assert.assertNotNull((Object)taskInfo.getStats().getEndTime());
        }
    }

    @Test
    public void testAbort() {
        try (SqlTaskManager sqlTaskManager = this.createSqlTaskManager(new TaskManagerConfig());){
            TaskId taskId = TASK_ID;
            TaskInfo taskInfo = this.createTask(sqlTaskManager, taskId, OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.PARTITIONED).withBuffer(OUT, 0).withNoMoreBufferIds());
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.RUNNING);
            Assert.assertNull((Object)taskInfo.getStats().getEndTime());
            taskInfo = sqlTaskManager.getTaskInfo(taskId);
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.RUNNING);
            Assert.assertNull((Object)taskInfo.getStats().getEndTime());
            taskInfo = sqlTaskManager.abortTask(taskId);
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.ABORTED);
            Assert.assertNotNull((Object)taskInfo.getStats().getEndTime());
            taskInfo = sqlTaskManager.getTaskInfo(taskId);
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.ABORTED);
            Assert.assertNotNull((Object)taskInfo.getStats().getEndTime());
        }
    }

    @Test(timeOut=30000L)
    public void testAbortResults() throws Exception {
        try (SqlTaskManager sqlTaskManager = this.createSqlTaskManager(new TaskManagerConfig());){
            TaskId taskId = TASK_ID;
            this.createTask(sqlTaskManager, taskId, (ImmutableSet<ScheduledSplit>)ImmutableSet.of((Object)TaskTestUtils.SPLIT), OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.PARTITIONED).withBuffer(OUT, 0).withNoMoreBufferIds());
            TaskInfo taskInfo = (TaskInfo)sqlTaskManager.getTaskInfo(taskId, 0L).get();
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.FLUSHING);
            sqlTaskManager.abortTaskResults(taskId, OUT);
            taskInfo = (TaskInfo)sqlTaskManager.getTaskInfo(taskId, taskInfo.getTaskStatus().getVersion()).get();
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.FINISHED);
            taskInfo = sqlTaskManager.getTaskInfo(taskId);
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.FINISHED);
        }
    }

    @Test
    public void testRemoveOldTasks() throws Exception {
        try (SqlTaskManager sqlTaskManager = this.createSqlTaskManager(new TaskManagerConfig().setInfoMaxAge(new Duration(5.0, TimeUnit.MILLISECONDS)));){
            TaskId taskId = TASK_ID;
            TaskInfo taskInfo = this.createTask(sqlTaskManager, taskId, OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.PARTITIONED).withBuffer(OUT, 0).withNoMoreBufferIds());
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.RUNNING);
            taskInfo = sqlTaskManager.cancelTask(taskId);
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.CANCELED);
            taskInfo = sqlTaskManager.getTaskInfo(taskId);
            Assert.assertEquals((Object)taskInfo.getTaskStatus().getState(), (Object)TaskState.CANCELED);
            Thread.sleep(100L);
            sqlTaskManager.removeOldTasks();
            for (TaskInfo info : sqlTaskManager.getAllTaskInfo()) {
                Assert.assertNotEquals((Object)info.getTaskStatus().getTaskId(), (Object)taskId);
            }
        }
    }

    @Test
    public void testSessionPropertyMemoryLimitOverride() {
        NodeMemoryConfig memoryConfig = new NodeMemoryConfig().setMaxQueryMemoryPerNode(DataSize.ofBytes((long)3L)).setMaxQueryTotalMemoryPerNode(DataSize.ofBytes((long)4L));
        try (SqlTaskManager sqlTaskManager = this.createSqlTaskManager(new TaskManagerConfig(), memoryConfig);){
            TaskId reduceLimitsId = new TaskId("q1", 0, 1);
            TaskId increaseLimitsId = new TaskId("q2", 0, 1);
            QueryContext reducesLimitsContext = sqlTaskManager.getQueryContext(reduceLimitsId.getQueryId());
            QueryContext attemptsIncreaseContext = sqlTaskManager.getQueryContext(increaseLimitsId.getQueryId());
            Assert.assertFalse((boolean)reducesLimitsContext.isMemoryLimitsInitialized());
            Assert.assertEquals((long)reducesLimitsContext.getMaxUserMemory(), (long)memoryConfig.getMaxQueryMemoryPerNode().toBytes());
            Assert.assertEquals((long)reducesLimitsContext.getMaxTotalMemory(), (long)memoryConfig.getMaxQueryTotalMemoryPerNode().toBytes());
            Assert.assertFalse((boolean)attemptsIncreaseContext.isMemoryLimitsInitialized());
            Assert.assertEquals((long)attemptsIncreaseContext.getMaxUserMemory(), (long)memoryConfig.getMaxQueryMemoryPerNode().toBytes());
            Assert.assertEquals((long)attemptsIncreaseContext.getMaxTotalMemory(), (long)memoryConfig.getMaxQueryTotalMemoryPerNode().toBytes());
            sqlTaskManager.updateTask(TestingSession.testSessionBuilder().setSystemProperty("query_max_memory_per_node", "1B").setSystemProperty("query_max_total_memory_per_node", "2B").build(), reduceLimitsId, Optional.of(TaskTestUtils.PLAN_FRAGMENT), (List)ImmutableList.of((Object)new TaskSource(TaskTestUtils.TABLE_SCAN_NODE_ID, (Set)ImmutableSet.of((Object)TaskTestUtils.SPLIT), true)), OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.PARTITIONED).withBuffer(OUT, 0).withNoMoreBufferIds(), OptionalInt.empty(), (Map)ImmutableMap.of());
            Assert.assertTrue((boolean)reducesLimitsContext.isMemoryLimitsInitialized());
            Assert.assertEquals((long)reducesLimitsContext.getMaxUserMemory(), (long)1L);
            Assert.assertEquals((long)reducesLimitsContext.getMaxTotalMemory(), (long)2L);
            sqlTaskManager.updateTask(TestingSession.testSessionBuilder().setSystemProperty("query_max_memory_per_node", "10B").setSystemProperty("query_max_total_memory_per_node", "10B").build(), increaseLimitsId, Optional.of(TaskTestUtils.PLAN_FRAGMENT), (List)ImmutableList.of((Object)new TaskSource(TaskTestUtils.TABLE_SCAN_NODE_ID, (Set)ImmutableSet.of((Object)TaskTestUtils.SPLIT), true)), OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.PARTITIONED).withBuffer(OUT, 0).withNoMoreBufferIds(), OptionalInt.empty(), (Map)ImmutableMap.of());
            Assert.assertTrue((boolean)attemptsIncreaseContext.isMemoryLimitsInitialized());
            Assert.assertEquals((long)attemptsIncreaseContext.getMaxUserMemory(), (long)memoryConfig.getMaxQueryMemoryPerNode().toBytes());
            Assert.assertEquals((long)attemptsIncreaseContext.getMaxTotalMemory(), (long)memoryConfig.getMaxQueryTotalMemoryPerNode().toBytes());
        }
    }

    private SqlTaskManager createSqlTaskManager(TaskManagerConfig config) {
        return this.createSqlTaskManager(config, new NodeMemoryConfig());
    }

    private SqlTaskManager createSqlTaskManager(TaskManagerConfig taskManagerConfig, NodeMemoryConfig nodeMemoryConfig) {
        return new SqlTaskManager((VersionEmbedder)new EmbedVersion("testversion"), TaskTestUtils.createTestingPlanner(), (LocationFactory)new MockLocationFactory(), this.taskExecutor, TaskTestUtils.createTestSplitMonitor(), new NodeInfo("test"), this.localMemoryManager, this.taskManagementExecutor, taskManagerConfig, nodeMemoryConfig, this.localSpillManager, new NodeSpillConfig(), (GcMonitor)new TestingGcMonitor());
    }

    private TaskInfo createTask(SqlTaskManager sqlTaskManager, TaskId taskId, ImmutableSet<ScheduledSplit> splits, OutputBuffers outputBuffers) {
        return sqlTaskManager.updateTask(SessionTestUtils.TEST_SESSION, taskId, Optional.of(TaskTestUtils.PLAN_FRAGMENT), (List)ImmutableList.of((Object)new TaskSource(TaskTestUtils.TABLE_SCAN_NODE_ID, splits, true)), outputBuffers, OptionalInt.empty(), (Map)ImmutableMap.of());
    }

    private TaskInfo createTask(SqlTaskManager sqlTaskManager, TaskId taskId, OutputBuffers outputBuffers) {
        sqlTaskManager.getQueryContext(taskId.getQueryId()).addTaskContext(new TaskStateMachine(taskId, MoreExecutors.directExecutor()), TestingSession.testSessionBuilder().build(), () -> {}, false, false, OptionalInt.empty());
        return sqlTaskManager.updateTask(SessionTestUtils.TEST_SESSION, taskId, Optional.of(TaskTestUtils.PLAN_FRAGMENT), (List)ImmutableList.of(), outputBuffers, OptionalInt.empty(), (Map)ImmutableMap.of());
    }

    public static class MockLocationFactory
    implements LocationFactory {
        public URI createQueryLocation(QueryId queryId) {
            return URI.create("http://fake.invalid/query/" + queryId);
        }

        public URI createLocalTaskLocation(TaskId taskId) {
            return URI.create("http://fake.invalid/task/" + taskId);
        }

        public URI createTaskLocation(InternalNode node, TaskId taskId) {
            return URI.create("http://fake.invalid/task/" + node.getNodeIdentifier() + "/" + taskId);
        }

        public URI createMemoryInfoLocation(InternalNode node) {
            return URI.create("http://fake.invalid/" + node.getNodeIdentifier() + "/memory");
        }
    }

    public static class MockExchangeClientSupplier
    implements ExchangeClientSupplier {
        public ExchangeClient get(LocalMemoryContext systemMemoryContext) {
            throw new UnsupportedOperationException();
        }
    }
}

