/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.buffer;

import io.airlift.compress.Compressor;
import io.airlift.compress.Decompressor;
import io.airlift.compress.lz4.Lz4Compressor;
import io.airlift.compress.lz4.Lz4Decompressor;
import io.trino.execution.buffer.PagesSerde;
import io.trino.execution.buffer.PagesSerdeFactory;
import io.trino.execution.buffer.SerializedPage;
import io.trino.metadata.MetadataManager;
import io.trino.spi.Page;
import io.trino.spi.block.BlockEncodingSerde;
import io.trino.spiller.SpillCipher;
import java.util.Optional;

public class TestingPagesSerdeFactory
extends PagesSerdeFactory {
    public TestingPagesSerdeFactory() {
        super(MetadataManager.createTestMetadataManager().getBlockEncodingSerde(), true);
    }

    public static PagesSerde testingPagesSerde() {
        return new SynchronizedPagesSerde(MetadataManager.createTestMetadataManager().getBlockEncodingSerde(), Optional.of(new Lz4Compressor()), Optional.of(new Lz4Decompressor()), Optional.empty());
    }

    private static class SynchronizedPagesSerde
    extends PagesSerde {
        public SynchronizedPagesSerde(BlockEncodingSerde blockEncodingSerde, Optional<Compressor> compressor, Optional<Decompressor> decompressor, Optional<SpillCipher> spillCipher) {
            super(blockEncodingSerde, compressor, decompressor, spillCipher);
        }

        public synchronized SerializedPage serialize(PagesSerde.PagesSerdeContext context, Page page) {
            return super.serialize(context, page);
        }

        public synchronized Page deserialize(SerializedPage serializedPage) {
            return super.deserialize(serializedPage);
        }

        public synchronized Page deserialize(PagesSerde.PagesSerdeContext context, SerializedPage page) {
            return super.deserialize(context, page);
        }
    }
}

