/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.executor;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import io.trino.execution.TaskId;
import io.trino.execution.executor.SimulationTask;
import io.trino.execution.executor.SplitGenerators;
import io.trino.execution.executor.SplitSpecification;
import io.trino.execution.executor.TaskExecutor;
import java.util.Map;
import java.util.OptionalInt;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;

class SimulationController {
    private static final int DEFAULT_MIN_SPLITS_PER_TASK = 3;
    private final TaskExecutor taskExecutor;
    private final BiConsumer<SimulationController, TaskExecutor> callback;
    private final ExecutorService controllerExecutor = Executors.newSingleThreadExecutor();
    private final Map<TaskSpecification, Boolean> specificationEnabled = new ConcurrentHashMap<TaskSpecification, Boolean>();
    private final ListMultimap<TaskSpecification, SimulationTask> runningTasks = Multimaps.synchronizedListMultimap((ListMultimap)ArrayListMultimap.create());
    private final ListMultimap<TaskSpecification, SimulationTask> completedTasks = Multimaps.synchronizedListMultimap((ListMultimap)ArrayListMultimap.create());
    private final AtomicBoolean clearPendingQueue = new AtomicBoolean();
    private final AtomicBoolean stopped = new AtomicBoolean();

    public SimulationController(TaskExecutor taskExecutor, BiConsumer<SimulationController, TaskExecutor> callback) {
        this.taskExecutor = taskExecutor;
        this.callback = callback;
    }

    public synchronized void addTaskSpecification(TaskSpecification spec) {
        this.specificationEnabled.put(spec, false);
    }

    public synchronized void clearPendingQueue() {
        System.out.println("Clearing pending queue..");
        this.clearPendingQueue.set(true);
    }

    public synchronized void stop() {
        this.stopped.set(true);
        this.controllerExecutor.shutdownNow();
        this.taskExecutor.stop();
    }

    public synchronized void enableSpecification(TaskSpecification specification) {
        this.specificationEnabled.replace(specification, false, true);
        this.startSpec(specification);
    }

    public synchronized void disableSpecification(TaskSpecification specification) {
        if (this.specificationEnabled.replace(specification, true, false) && this.callback != null) {
            this.runCallback();
        }
    }

    public synchronized void runCallback() {
        this.callback.accept(this, this.taskExecutor);
    }

    public void run() {
        this.controllerExecutor.submit(() -> {
            while (!this.stopped.get()) {
                this.replaceCompletedTasks();
                this.scheduleSplitsForRunningTasks();
                try {
                    TimeUnit.MILLISECONDS.sleep(500L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        });
    }

    private synchronized void scheduleSplitsForRunningTasks() {
        if (this.clearPendingQueue.get()) {
            if (this.taskExecutor.getWaitingSplits() > this.taskExecutor.getIntermediateSplits() - this.taskExecutor.getBlockedSplits()) {
                return;
            }
            System.out.println("Cleared pending queue.");
            this.clearPendingQueue.set(false);
        }
        for (TaskSpecification specification : this.specificationEnabled.keySet()) {
            if (!this.specificationEnabled.get(specification).booleanValue()) continue;
            for (SimulationTask task : this.runningTasks.get((Object)specification)) {
                int remainingSplits;
                if (specification.getType() == TaskSpecification.Type.LEAF) {
                    remainingSplits = specification.getNumSplitsPerTask() - (task.getRunningSplits().size() + task.getCompletedSplits().size());
                    int candidateSplits = 3 - task.getRunningSplits().size();
                    for (int i = 0; i < Math.min(remainingSplits, candidateSplits); ++i) {
                        task.schedule(this.taskExecutor, 1);
                    }
                    continue;
                }
                remainingSplits = specification.getNumSplitsPerTask() - (task.getRunningSplits().size() + task.getCompletedSplits().size());
                task.schedule(this.taskExecutor, remainingSplits);
            }
        }
    }

    private synchronized void replaceCompletedTasks() {
        boolean moved;
        do {
            moved = false;
            block1: for (TaskSpecification specification : this.specificationEnabled.keySet()) {
                if (specification.getTotalTasks().isPresent() && this.specificationEnabled.get(specification).booleanValue() && specification.getTotalTasks().getAsInt() <= this.completedTasks.get((Object)specification).size() + this.runningTasks.get((Object)specification).size()) {
                    System.out.println();
                    System.out.println(specification.getName() + " disabled for reaching target count " + specification.getTotalTasks());
                    System.out.println();
                    this.disableSpecification(specification);
                    continue;
                }
                for (SimulationTask task : this.runningTasks.get((Object)specification)) {
                    if (task.getCompletedSplits().size() < specification.getNumSplitsPerTask()) continue;
                    this.completedTasks.put((Object)specification, (Object)task);
                    this.runningTasks.remove((Object)specification, (Object)task);
                    this.taskExecutor.removeTask(task.getTaskHandle());
                    if (!this.specificationEnabled.get(specification).booleanValue()) continue;
                    this.createTask(specification);
                    moved = true;
                    continue block1;
                }
            }
        } while (moved);
    }

    private void createTask(TaskSpecification specification) {
        if (specification.getType() == TaskSpecification.Type.LEAF) {
            this.runningTasks.put((Object)specification, (Object)new SimulationTask.LeafTask(this.taskExecutor, specification, new TaskId(specification.getName(), 0, this.runningTasks.get((Object)specification).size() + this.completedTasks.get((Object)specification).size())));
        } else {
            this.runningTasks.put((Object)specification, (Object)new SimulationTask.IntermediateTask(this.taskExecutor, specification, new TaskId(specification.getName(), 0, this.runningTasks.get((Object)specification).size() + this.completedTasks.get((Object)specification).size())));
        }
    }

    public Map<TaskSpecification, Boolean> getSpecificationEnabled() {
        return this.specificationEnabled;
    }

    public ListMultimap<TaskSpecification, SimulationTask> getRunningTasks() {
        return this.runningTasks;
    }

    public ListMultimap<TaskSpecification, SimulationTask> getCompletedTasks() {
        return this.completedTasks;
    }

    private void startSpec(TaskSpecification specification) {
        if (!this.specificationEnabled.get(specification).booleanValue()) {
            return;
        }
        for (int i = 0; i < specification.getNumConcurrentTasks(); ++i) {
            this.createTask(specification);
        }
    }

    public static class TaskSpecification {
        private final Type type;
        private final String name;
        private final OptionalInt totalTasks;
        private final int numConcurrentTasks;
        private final int numSplitsPerTask;
        private final SplitGenerators.SplitGenerator splitGenerator;

        TaskSpecification(Type type, String name, OptionalInt totalTasks, int numConcurrentTasks, int numSplitsPerTask, SplitGenerators.SplitGenerator splitGenerator) {
            this.type = type;
            this.name = name;
            this.totalTasks = totalTasks;
            this.numConcurrentTasks = numConcurrentTasks;
            this.numSplitsPerTask = numSplitsPerTask;
            this.splitGenerator = splitGenerator;
        }

        Type getType() {
            return this.type;
        }

        String getName() {
            return this.name;
        }

        int getNumConcurrentTasks() {
            return this.numConcurrentTasks;
        }

        int getNumSplitsPerTask() {
            return this.numSplitsPerTask;
        }

        OptionalInt getTotalTasks() {
            return this.totalTasks;
        }

        SplitSpecification nextSpecification() {
            return this.splitGenerator.next();
        }

        static enum Type {
            LEAF,
            INTERMEDIATE;

        }
    }
}

