/*
 * Decompiled with CFR 0.152.
 */
package io.trino.memory;

import com.google.common.collect.ImmutableMap;
import io.airlift.concurrent.Threads;
import io.airlift.stats.GcMonitor;
import io.airlift.stats.TestingGcMonitor;
import io.airlift.units.DataSize;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.execution.TaskId;
import io.trino.execution.TaskStateMachine;
import io.trino.memory.LocalMemoryManager;
import io.trino.memory.MemoryPool;
import io.trino.memory.QueryContext;
import io.trino.memory.context.LocalMemoryContext;
import io.trino.operator.DriverContext;
import io.trino.operator.OperatorContext;
import io.trino.operator.TaskContext;
import io.trino.spi.QueryId;
import io.trino.spiller.SpillSpaceTracker;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.testing.LocalQueryRunner;
import java.util.Map;
import java.util.OptionalInt;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestQueryContext {
    private static final ScheduledExecutorService TEST_EXECUTOR = Executors.newScheduledThreadPool(1, Threads.threadsNamed((String)"test-executor-%s"));

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        TEST_EXECUTOR.shutdownNow();
    }

    @DataProvider
    public Object[][] testSetMemoryPoolOptions() {
        return new Object[][]{{false}, {true}};
    }

    @Test(dataProvider="testSetMemoryPoolOptions")
    public void testSetMemoryPool(boolean useReservedPool) {
        QueryId secondQuery = new QueryId("second");
        MemoryPool reservedPool = new MemoryPool(LocalMemoryManager.RESERVED_POOL, DataSize.ofBytes((long)10L));
        long secondQueryMemory = reservedPool.getMaxBytes() - 1L;
        if (useReservedPool) {
            Assert.assertTrue((boolean)reservedPool.reserve(secondQuery, "test", secondQueryMemory).isDone());
        }
        try (LocalQueryRunner localQueryRunner = LocalQueryRunner.create((Session)SessionTestUtils.TEST_SESSION);){
            QueryContext queryContext = new QueryContext(new QueryId("query"), DataSize.ofBytes((long)10L), DataSize.ofBytes((long)20L), new MemoryPool(LocalMemoryManager.GENERAL_POOL, DataSize.ofBytes((long)10L)), (GcMonitor)new TestingGcMonitor(), (Executor)localQueryRunner.getExecutor(), localQueryRunner.getScheduler(), DataSize.ofBytes((long)0L), new SpillSpaceTracker(DataSize.ofBytes((long)0L)));
            queryContext.getQueryMemoryContext().initializeLocalMemoryContexts("test");
            LocalMemoryContext userMemoryContext = queryContext.getQueryMemoryContext().localUserMemoryContext();
            LocalMemoryContext revocableMemoryContext = queryContext.getQueryMemoryContext().localRevocableMemoryContext();
            Assert.assertTrue((boolean)userMemoryContext.setBytes(3L).isDone());
            Assert.assertTrue((boolean)revocableMemoryContext.setBytes(5L).isDone());
            queryContext.setMemoryPool(reservedPool);
            if (useReservedPool) {
                reservedPool.free(secondQuery, "test", secondQueryMemory);
            }
            userMemoryContext.close();
            revocableMemoryContext.close();
        }
    }

    @Test
    public void testMoveTaggedAllocations() {
        MemoryPool generalPool = new MemoryPool(LocalMemoryManager.GENERAL_POOL, DataSize.ofBytes((long)10000L));
        MemoryPool reservedPool = new MemoryPool(LocalMemoryManager.RESERVED_POOL, DataSize.ofBytes((long)10000L));
        QueryId queryId = new QueryId("query");
        QueryContext queryContext = TestQueryContext.createQueryContext(queryId, generalPool);
        TaskStateMachine taskStateMachine = new TaskStateMachine(TaskId.valueOf((String)"task-id"), (Executor)TEST_EXECUTOR);
        TaskContext taskContext = queryContext.addTaskContext(taskStateMachine, SessionTestUtils.TEST_SESSION, () -> {}, false, false, OptionalInt.empty());
        DriverContext driverContext = taskContext.addPipelineContext(0, false, false, false).addDriverContext();
        OperatorContext operatorContext = driverContext.addOperatorContext(0, new PlanNodeId("test"), "test");
        LocalMemoryContext memoryContext = operatorContext.aggregateUserMemoryContext().newLocalMemoryContext("test_context");
        memoryContext.setBytes(1000L);
        Map allocations = (Map)generalPool.getTaggedMemoryAllocations().get(queryId);
        Assert.assertEquals((Map)allocations, (Map)ImmutableMap.of((Object)"test_context", (Object)1000L));
        queryContext.setMemoryPool(reservedPool);
        Assert.assertNull(generalPool.getTaggedMemoryAllocations().get(queryId));
        allocations = (Map)reservedPool.getTaggedMemoryAllocations().get(queryId);
        Assert.assertEquals((Map)allocations, (Map)ImmutableMap.of((Object)"test_context", (Object)1000L));
        Assert.assertEquals((long)generalPool.getFreeBytes(), (long)10000L);
        Assert.assertEquals((long)reservedPool.getFreeBytes(), (long)9000L);
        memoryContext.close();
        Assert.assertEquals((long)generalPool.getFreeBytes(), (long)10000L);
        Assert.assertEquals((long)reservedPool.getFreeBytes(), (long)10000L);
    }

    private static QueryContext createQueryContext(QueryId queryId, MemoryPool generalPool) {
        return new QueryContext(queryId, DataSize.ofBytes((long)10000L), DataSize.ofBytes((long)10000L), generalPool, (GcMonitor)new TestingGcMonitor(), (Executor)TEST_EXECUTOR, TEST_EXECUTOR, DataSize.ofBytes((long)0L), new SpillSpaceTracker(DataSize.ofBytes((long)0L)));
    }
}

