/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.collect.ImmutableList;
import io.airlift.concurrent.Threads;
import io.airlift.units.DataSize;
import io.trino.RowPagesBuilder;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataManager;
import io.trino.metadata.ResolvedFunction;
import io.trino.operator.DriverContext;
import io.trino.operator.FilterAndProjectOperator;
import io.trino.operator.OperatorAssertion;
import io.trino.operator.OperatorFactory;
import io.trino.spi.Page;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.gen.ExpressionCompiler;
import io.trino.sql.gen.PageFunctionCompiler;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.relational.CallExpression;
import io.trino.sql.relational.Expressions;
import io.trino.sql.relational.InputReferenceExpression;
import io.trino.sql.relational.RowExpression;
import io.trino.testing.MaterializedResult;
import io.trino.testing.TestingTaskContext;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Supplier;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestFilterAndProjectOperator {
    private ExecutorService executor;
    private ScheduledExecutorService scheduledExecutor;
    private DriverContext driverContext;

    @BeforeMethod
    public void setUp() {
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-%s")));
        this.scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-scheduledExecutor-%s")));
        this.driverContext = TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION).addPipelineContext(0, true, true, false).addDriverContext();
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() {
        this.executor.shutdownNow();
        this.scheduledExecutor.shutdownNow();
    }

    @Test
    public void test() {
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{VarcharType.VARCHAR, BigintType.BIGINT}).addSequencePage(100, 0, 0).build();
        MetadataManager metadata = MetadataManager.createTestMetadataManager();
        CallExpression filter = Expressions.call((ResolvedFunction)metadata.resolveOperator(OperatorType.LESS_THAN_OR_EQUAL, (List)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT)), (RowExpression[])new RowExpression[]{Expressions.field((int)1, (Type)BigintType.BIGINT), Expressions.constant((Object)9L, (Type)BigintType.BIGINT)});
        InputReferenceExpression field0 = Expressions.field((int)0, (Type)VarcharType.VARCHAR);
        CallExpression add5 = Expressions.call((ResolvedFunction)metadata.resolveOperator(OperatorType.ADD, (List)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT)), (RowExpression[])new RowExpression[]{Expressions.field((int)1, (Type)BigintType.BIGINT), Expressions.constant((Object)5L, (Type)BigintType.BIGINT)});
        ExpressionCompiler compiler = new ExpressionCompiler((Metadata)metadata, new PageFunctionCompiler((Metadata)metadata, 0));
        Supplier processor = compiler.compilePageProcessor(Optional.of(filter), (List)ImmutableList.of((Object)field0, (Object)add5));
        OperatorFactory operatorFactory = FilterAndProjectOperator.createOperatorFactory((int)0, (PlanNodeId)new PlanNodeId("test"), (Supplier)processor, (List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT), (DataSize)DataSize.ofBytes((long)0L), (int)0);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{"0", 5L}).row(new Object[]{"1", 6L}).row(new Object[]{"2", 7L}).row(new Object[]{"3", 8L}).row(new Object[]{"4", 9L}).row(new Object[]{"5", 10L}).row(new Object[]{"6", 11L}).row(new Object[]{"7", 12L}).row(new Object[]{"8", 13L}).row(new Object[]{"9", 14L}).build();
        OperatorAssertion.assertOperatorEquals(operatorFactory, this.driverContext, input, expected);
    }

    @Test
    public void testMergeOutput() {
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{VarcharType.VARCHAR, BigintType.BIGINT}).addSequencePage(100, 0, 0).addSequencePage(100, 0, 0).addSequencePage(100, 0, 0).addSequencePage(100, 0, 0).build();
        MetadataManager metadata = MetadataManager.createTestMetadataManager();
        CallExpression filter = Expressions.call((ResolvedFunction)metadata.resolveOperator(OperatorType.EQUAL, (List)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT)), (RowExpression[])new RowExpression[]{Expressions.field((int)1, (Type)BigintType.BIGINT), Expressions.constant((Object)10L, (Type)BigintType.BIGINT)});
        ExpressionCompiler compiler = new ExpressionCompiler((Metadata)metadata, new PageFunctionCompiler((Metadata)metadata, 0));
        Supplier processor = compiler.compilePageProcessor(Optional.of(filter), (List)ImmutableList.of((Object)Expressions.field((int)1, (Type)BigintType.BIGINT)));
        OperatorFactory operatorFactory = FilterAndProjectOperator.createOperatorFactory((int)0, (PlanNodeId)new PlanNodeId("test"), (Supplier)processor, (List)ImmutableList.of((Object)BigintType.BIGINT), (DataSize)DataSize.of((long)64L, (DataSize.Unit)DataSize.Unit.KILOBYTE), (int)2);
        List<Page> expected = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT}).row(10L).row(10L).row(10L).row(10L).build();
        OperatorAssertion.assertOperatorEquals(operatorFactory, (List<Type>)ImmutableList.of((Object)BigintType.BIGINT), this.driverContext, input, expected);
    }
}

