/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.primitives.Ints;
import io.trino.block.BlockAssertions;
import io.trino.jmh.Benchmarks;
import io.trino.metadata.MetadataManager;
import io.trino.operator.GroupByIdBlock;
import io.trino.operator.aggregation.AggregationTestUtils;
import io.trino.operator.aggregation.GroupedAccumulator;
import io.trino.operator.aggregation.InternalAggregationFunction;
import io.trino.operator.aggregation.groupby.GroupByAggregationTestUtils;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.tree.QualifiedName;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.profile.GCProfiler;
import org.openjdk.jmh.runner.RunnerException;

@OutputTimeUnit(value=TimeUnit.SECONDS)
@Fork(value=3)
@Warmup(iterations=7)
@Measurement(iterations=20)
public class BenchmarkGroupedTypedHistogram {
    @Benchmark
    public GroupedAccumulator testSharedGroupWithLargeBlocksRunner(Data data) {
        GroupedAccumulator groupedAccumulator = data.groupedAccumulator;
        for (int i = 0; i < data.numGroups; ++i) {
            GroupByIdBlock groupByIdBlock = data.groupByIdBlocks[i];
            Page page = data.pages[i];
            groupedAccumulator.addInput(groupByIdBlock, page);
        }
        return groupedAccumulator;
    }

    private static InternalAggregationFunction getInternalAggregationFunctionVarChar() {
        MetadataManager metadata = MetadataManager.createTestMetadataManager();
        return metadata.getAggregateFunctionImplementation(metadata.resolveFunction(QualifiedName.of((String)"histogram"), TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR})));
    }

    public static void main(String[] args) throws RunnerException {
        Benchmarks.benchmark(BenchmarkGroupedTypedHistogram.class).withOptions(optionsBuilder -> optionsBuilder.addProfiler(GCProfiler.class)).run();
    }

    public static enum ProbeType {
        LINEAR,
        SUM_OF_COUNT,
        SUM_OF_SQUARE;

    }

    @State(value=Scope.Thread)
    public static class Data {
        @Param(value={"10000"})
        private int numGroups;
        @Param(value={"5000"})
        private int rowCount;
        @Param(value={"0.1"})
        private float distinctFraction;
        @Param(value={"32"})
        private int rowSize;
        private final Random random = new Random();
        private Page[] pages;
        private GroupByIdBlock[] groupByIdBlocks;
        private GroupedAccumulator groupedAccumulator;

        @Setup
        public void setUp() {
            this.pages = new Page[this.numGroups];
            this.groupByIdBlocks = new GroupByIdBlock[this.numGroups];
            for (int j = 0; j < this.numGroups; ++j) {
                ArrayList<String> valueList = new ArrayList<String>();
                for (int i = 0; i < this.rowCount; ++i) {
                    boolean distinctValue;
                    String str = String.valueOf(i % 10);
                    String item = IntStream.range(0, this.rowSize).mapToObj(x -> str).collect(Collectors.joining());
                    boolean bl = distinctValue = this.random.nextDouble() < (double)this.distinctFraction;
                    if (distinctValue) {
                        valueList.add(j + "-" + item);
                        continue;
                    }
                    valueList.add(item);
                }
                Block block = BlockAssertions.createStringsBlock(valueList);
                Page page = new Page(new Block[]{block});
                GroupByIdBlock groupByIdBlock = AggregationTestUtils.createGroupByIdBlock(j, page.getPositionCount());
                this.pages[j] = page;
                this.groupByIdBlocks[j] = groupByIdBlock;
            }
            InternalAggregationFunction aggregationFunction = BenchmarkGroupedTypedHistogram.getInternalAggregationFunctionVarChar();
            this.groupedAccumulator = this.createGroupedAccumulator(aggregationFunction);
        }

        private GroupedAccumulator createGroupedAccumulator(InternalAggregationFunction function) {
            int[] args = GroupByAggregationTestUtils.createArgs(function);
            return function.bind(Ints.asList((int[])args), Optional.empty()).createGroupedAccumulator();
        }
    }
}

