/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.collect.ImmutableList;
import io.trino.block.BlockAssertions;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataManager;
import io.trino.operator.aggregation.AggregationTestUtils;
import io.trino.operator.aggregation.InternalAggregationFunction;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.tree.QualifiedName;
import java.util.Arrays;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestArbitraryAggregation {
    private static final Metadata metadata = MetadataManager.createTestMetadataManager();

    @Test
    public void testAllRegistered() {
        for (Type valueType : metadata.getTypes()) {
            Assert.assertNotNull((Object)metadata.getAggregateFunctionImplementation(metadata.resolveFunction(QualifiedName.of((String)"arbitrary"), TypeSignatureProvider.fromTypes((Type[])new Type[]{valueType}))));
        }
    }

    @Test
    public void testNullBoolean() {
        InternalAggregationFunction booleanAgg = metadata.getAggregateFunctionImplementation(metadata.resolveFunction(QualifiedName.of((String)"arbitrary"), TypeSignatureProvider.fromTypes((Type[])new Type[]{BooleanType.BOOLEAN})));
        AggregationTestUtils.assertAggregation(booleanAgg, null, BlockAssertions.createBooleansBlock(new Boolean[]{null}));
    }

    @Test
    public void testValidBoolean() {
        InternalAggregationFunction booleanAgg = metadata.getAggregateFunctionImplementation(metadata.resolveFunction(QualifiedName.of((String)"arbitrary"), TypeSignatureProvider.fromTypes((Type[])new Type[]{BooleanType.BOOLEAN})));
        AggregationTestUtils.assertAggregation(booleanAgg, (Object)true, BlockAssertions.createBooleansBlock(true, true));
    }

    @Test
    public void testNullLong() {
        InternalAggregationFunction longAgg = metadata.getAggregateFunctionImplementation(metadata.resolveFunction(QualifiedName.of((String)"arbitrary"), TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT})));
        AggregationTestUtils.assertAggregation(longAgg, null, BlockAssertions.createLongsBlock(null, null));
    }

    @Test
    public void testValidLong() {
        InternalAggregationFunction longAgg = metadata.getAggregateFunctionImplementation(metadata.resolveFunction(QualifiedName.of((String)"arbitrary"), TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT})));
        AggregationTestUtils.assertAggregation(longAgg, (Object)1L, BlockAssertions.createLongsBlock(1L, null));
    }

    @Test
    public void testNullDouble() {
        InternalAggregationFunction doubleAgg = metadata.getAggregateFunctionImplementation(metadata.resolveFunction(QualifiedName.of((String)"arbitrary"), TypeSignatureProvider.fromTypes((Type[])new Type[]{DoubleType.DOUBLE})));
        AggregationTestUtils.assertAggregation(doubleAgg, null, BlockAssertions.createDoublesBlock(null, null));
    }

    @Test
    public void testValidDouble() {
        InternalAggregationFunction doubleAgg = metadata.getAggregateFunctionImplementation(metadata.resolveFunction(QualifiedName.of((String)"arbitrary"), TypeSignatureProvider.fromTypes((Type[])new Type[]{DoubleType.DOUBLE})));
        AggregationTestUtils.assertAggregation(doubleAgg, (Object)2.0, BlockAssertions.createDoublesBlock(null, 2.0));
    }

    @Test
    public void testNullString() {
        InternalAggregationFunction stringAgg = metadata.getAggregateFunctionImplementation(metadata.resolveFunction(QualifiedName.of((String)"arbitrary"), TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR})));
        AggregationTestUtils.assertAggregation(stringAgg, null, BlockAssertions.createStringsBlock(null, null));
    }

    @Test
    public void testValidString() {
        InternalAggregationFunction stringAgg = metadata.getAggregateFunctionImplementation(metadata.resolveFunction(QualifiedName.of((String)"arbitrary"), TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR})));
        AggregationTestUtils.assertAggregation(stringAgg, (Object)"a", BlockAssertions.createStringsBlock("a", "a"));
    }

    @Test
    public void testNullArray() {
        InternalAggregationFunction arrayAgg = metadata.getAggregateFunctionImplementation(metadata.resolveFunction(QualifiedName.of((String)"arbitrary"), TypeSignatureProvider.fromTypes((Type[])new Type[]{new ArrayType((Type)BigintType.BIGINT)})));
        AggregationTestUtils.assertAggregation(arrayAgg, null, BlockAssertions.createArrayBigintBlock(Arrays.asList(null, null, null, null)));
    }

    @Test
    public void testValidArray() {
        InternalAggregationFunction arrayAgg = metadata.getAggregateFunctionImplementation(metadata.resolveFunction(QualifiedName.of((String)"arbitrary"), TypeSignatureProvider.fromTypes((Type[])new Type[]{new ArrayType((Type)BigintType.BIGINT)})));
        AggregationTestUtils.assertAggregation(arrayAgg, (Object)ImmutableList.of((Object)23L, (Object)45L), BlockAssertions.createArrayBigintBlock((Iterable<? extends Iterable<Long>>)ImmutableList.of((Object)ImmutableList.of((Object)23L, (Object)45L), (Object)ImmutableList.of((Object)23L, (Object)45L), (Object)ImmutableList.of((Object)23L, (Object)45L), (Object)ImmutableList.of((Object)23L, (Object)45L))));
    }

    @Test
    public void testValidInt() {
        InternalAggregationFunction arrayAgg = metadata.getAggregateFunctionImplementation(metadata.resolveFunction(QualifiedName.of((String)"arbitrary"), TypeSignatureProvider.fromTypes((Type[])new Type[]{IntegerType.INTEGER})));
        AggregationTestUtils.assertAggregation(arrayAgg, (Object)3, BlockAssertions.createIntsBlock(3, 3, null));
    }
}

