/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.block.BlockAssertions;
import io.trino.operator.aggregation.AbstractTestAggregationFunction;
import io.trino.spi.block.Block;
import io.trino.spi.type.RealType;
import io.trino.spi.type.Type;
import java.util.List;
import org.apache.commons.math3.stat.regression.SimpleRegression;
import org.testng.annotations.Test;

public class TestRealRegrSlopeAggregation
extends AbstractTestAggregationFunction {
    @Override
    protected Block[] getSequenceBlocks(int start, int length) {
        return new Block[]{BlockAssertions.createSequenceBlockOfReal(start, start + length), BlockAssertions.createSequenceBlockOfReal(start + 2, start + 2 + length)};
    }

    @Override
    protected String getFunctionName() {
        return "regr_slope";
    }

    @Override
    protected List<Type> getFunctionParameterTypes() {
        return ImmutableList.of((Object)RealType.REAL, (Object)RealType.REAL);
    }

    @Override
    protected Object getExpectedValue(int start, int length) {
        if (length <= 1) {
            return null;
        }
        SimpleRegression regression = new SimpleRegression();
        for (int i = start; i < start + length; ++i) {
            regression.addData((double)(i + 2), (double)i);
        }
        return Float.valueOf((float)regression.getSlope());
    }

    @Test
    public void testNonTrivialResult() {
        this.testNonTrivialAggregation(new Float[]{Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(3.0f), Float.valueOf(4.0f), Float.valueOf(5.0f)}, new Float[]{Float.valueOf(1.0f), Float.valueOf(4.0f), Float.valueOf(9.0f), Float.valueOf(16.0f), Float.valueOf(25.0f)});
        this.testNonTrivialAggregation(new Float[]{Float.valueOf(1.0f), Float.valueOf(4.0f), Float.valueOf(9.0f), Float.valueOf(16.0f), Float.valueOf(25.0f)}, new Float[]{Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(3.0f), Float.valueOf(4.0f), Float.valueOf(5.0f)});
    }

    private void testNonTrivialAggregation(Float[] y, Float[] x) {
        SimpleRegression regression = new SimpleRegression();
        for (int i = 0; i < x.length; ++i) {
            regression.addData((double)x[i].floatValue(), (double)y[i].floatValue());
        }
        float expected = (float)regression.getSlope();
        Preconditions.checkArgument((Float.isFinite(expected) && expected != 0.0f ? 1 : 0) != 0, (Object)"Expected result is trivial");
        this.testAggregation(Float.valueOf(expected), BlockAssertions.createBlockOfReals(y), BlockAssertions.createBlockOfReals(x));
    }
}

