/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import io.trino.operator.aggregation.TypedHeap;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.type.BlockTypeOperators;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.PrimitiveIterator;
import java.util.stream.IntStream;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestTypedHeap {
    private static final int INPUT_SIZE = 1000000;
    private static final int OUTPUT_SIZE = 1000;
    private static final BlockTypeOperators TYPE_OPERATOR_FACTORY = new BlockTypeOperators(new TypeOperators());
    private static final BlockTypeOperators.BlockPositionComparison MAX_ELEMENTS_COMPARATOR = TYPE_OPERATOR_FACTORY.getComparisonOperator((Type)BigintType.BIGINT);
    private static final BlockTypeOperators.BlockPositionComparison MIN_ELEMENTS_COMPARATOR = TYPE_OPERATOR_FACTORY.getComparisonOperator((Type)BigintType.BIGINT).reversed();

    @Test
    public void testAscending() {
        TestTypedHeap.test(IntStream.range(0, 1000000), MAX_ELEMENTS_COMPARATOR, IntStream.range(999000, 1000000).iterator());
        TestTypedHeap.test(IntStream.range(0, 1000000), MIN_ELEMENTS_COMPARATOR, IntStream.range(0, 1000).map(x -> 999 - x).iterator());
    }

    @Test
    public void testDescending() {
        TestTypedHeap.test(IntStream.range(0, 1000000).map(x -> 999999 - x), MAX_ELEMENTS_COMPARATOR, IntStream.range(999000, 1000000).iterator());
        TestTypedHeap.test(IntStream.range(0, 1000000).map(x -> 999999 - x), MIN_ELEMENTS_COMPARATOR, IntStream.range(0, 1000).map(x -> 999 - x).iterator());
    }

    @Test
    public void testShuffled() {
        List list = IntStream.range(0, 1000000).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
        Collections.shuffle(list);
        TestTypedHeap.test(list.stream().mapToInt(Integer::intValue), MAX_ELEMENTS_COMPARATOR, IntStream.range(999000, 1000000).iterator());
        TestTypedHeap.test(list.stream().mapToInt(Integer::intValue), MIN_ELEMENTS_COMPARATOR, IntStream.range(0, 1000).map(x -> 999 - x).iterator());
    }

    private static void test(IntStream inputStream, BlockTypeOperators.BlockPositionComparison comparator, PrimitiveIterator.OfInt outputIterator) {
        BlockBuilder blockBuilder = BigintType.BIGINT.createBlockBuilder(null, 1000000);
        inputStream.forEach(x -> BigintType.BIGINT.writeLong(blockBuilder, (long)x));
        TypedHeap heap = new TypedHeap(comparator, (Type)BigintType.BIGINT, 1000);
        heap.addAll((Block)blockBuilder);
        BlockBuilder resultBlockBuilder = BigintType.BIGINT.createBlockBuilder(null, 1000);
        heap.popAll(resultBlockBuilder);
        Block resultBlock = resultBlockBuilder.build();
        Assert.assertEquals((int)resultBlock.getPositionCount(), (int)1000);
        for (int i = 0; i < 1000; ++i) {
            Assert.assertEquals((long)BigintType.BIGINT.getLong(resultBlock, i), (long)outputIterator.nextInt());
        }
    }
}

