/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.output;

import com.google.common.collect.ImmutableList;
import io.airlift.concurrent.Threads;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.execution.StateMachine;
import io.trino.execution.buffer.BufferState;
import io.trino.execution.buffer.OutputBuffer;
import io.trino.execution.buffer.OutputBuffers;
import io.trino.execution.buffer.PagesSerdeFactory;
import io.trino.execution.buffer.PartitionedOutputBuffer;
import io.trino.jmh.Benchmarks;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.memory.context.SimpleLocalMemoryContext;
import io.trino.metadata.MetadataManager;
import io.trino.operator.DriverContext;
import io.trino.operator.HashGenerator;
import io.trino.operator.InterpretedHashGenerator;
import io.trino.operator.OperatorFactories;
import io.trino.operator.OutputFactory;
import io.trino.operator.PartitionFunction;
import io.trino.operator.TaskContext;
import io.trino.operator.TrinoOperatorFactories;
import io.trino.operator.exchange.LocalPartitionGenerator;
import io.trino.operator.output.PartitionedOutputOperator;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.VarcharType;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.testing.TestingTaskContext;
import io.trino.type.BlockTypeOperators;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.RunnerException;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@Fork(value=2)
@Warmup(iterations=20, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=20, time=500, timeUnit=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkPartitionedOutputOperator {
    private static final OperatorFactories OPERATOR_FACTORIES = new TrinoOperatorFactories();
    private final OperatorFactories operatorFactories;

    public BenchmarkPartitionedOutputOperator() {
        this(OPERATOR_FACTORIES);
    }

    protected BenchmarkPartitionedOutputOperator(OperatorFactories operatorFactories) {
        this.operatorFactories = operatorFactories;
    }

    @Benchmark
    public void addPage(BenchmarkData data) {
        PartitionedOutputOperator operator = data.createPartitionedOutputOperator(this.operatorFactories);
        for (int i = 0; i < data.getPageCount(); ++i) {
            operator.addInput(data.getDataPage());
        }
        operator.finish();
    }

    public static void main(String[] args) throws RunnerException {
        BenchmarkData data = new BenchmarkData();
        new BenchmarkPartitionedOutputOperator().addPage(data);
        Benchmarks.benchmark(BenchmarkPartitionedOutputOperator.class).withOptions(optionsBuilder -> optionsBuilder.jvmArgs(new String[]{"-Xmx10g"})).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        private static final int PAGE_COUNT = 5000;
        private static final int PARTITION_COUNT = 512;
        private static final int ENTRIES_PER_PAGE = 256;
        private static final DataSize MAX_MEMORY = DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.GIGABYTE);
        private static final RowType rowType = RowType.anonymous((List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR));
        private static final List<Type> TYPES = ImmutableList.of((Object)BigintType.BIGINT, (Object)rowType, (Object)rowType, (Object)rowType);
        private static final ExecutorService EXECUTOR = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"BenchmarkPartitionedOutputOperator-executor-%s"));
        private static final ScheduledExecutorService SCHEDULER = Executors.newScheduledThreadPool(1, Threads.daemonThreadsNamed((String)"BenchmarkPartitionedOutputOperator-scheduledExecutor-%s"));
        private final Page dataPage = this.createPage();

        private int getPageCount() {
            return 5000;
        }

        public Page getDataPage() {
            return this.dataPage;
        }

        private PartitionedOutputOperator createPartitionedOutputOperator(OperatorFactories operatorFactories) {
            BlockTypeOperators blockTypeOperators = new BlockTypeOperators(new TypeOperators());
            LocalPartitionGenerator partitionFunction = new LocalPartitionGenerator((HashGenerator)new InterpretedHashGenerator((List)ImmutableList.of((Object)BigintType.BIGINT), new int[]{0}, blockTypeOperators), 512);
            PagesSerdeFactory serdeFactory = new PagesSerdeFactory(MetadataManager.createTestMetadataManager().getBlockEncodingSerde(), false);
            OutputBuffers buffers = OutputBuffers.createInitialEmptyOutputBuffers((OutputBuffers.BufferType)OutputBuffers.BufferType.PARTITIONED);
            for (int partition = 0; partition < 512; ++partition) {
                buffers = buffers.withBuffer(new OutputBuffers.OutputBufferId(partition), partition);
            }
            PartitionedOutputBuffer buffer = this.createPartitionedBuffer(buffers.withNoMoreBufferIds(), DataSize.ofBytes((long)Long.MAX_VALUE));
            TaskContext taskContext = this.createTaskContext();
            DriverContext driverContext = this.createDriverContext(taskContext);
            OutputFactory operatorFactory = operatorFactories.partitionedOutput(taskContext, (PartitionFunction)partitionFunction, (List)ImmutableList.of((Object)0), (List)ImmutableList.of(Optional.empty()), false, OptionalInt.empty(), (OutputBuffer)buffer, DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.GIGABYTE));
            return (PartitionedOutputOperator)operatorFactory.createOutputOperator(0, new PlanNodeId("plan-node-0"), TYPES, Function.identity(), serdeFactory).createOperator(driverContext);
        }

        private Page createPage() {
            List<Object>[] testRows = this.generateTestRows((List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR), 256);
            PageBuilder pageBuilder = new PageBuilder(TYPES);
            BlockBuilder bigintBlockBuilder = pageBuilder.getBlockBuilder(0);
            BlockBuilder rowBlockBuilder = pageBuilder.getBlockBuilder(1);
            BlockBuilder rowBlockBuilder2 = pageBuilder.getBlockBuilder(2);
            BlockBuilder rowBlockBuilder3 = pageBuilder.getBlockBuilder(3);
            for (int i = 0; i < 256; ++i) {
                BigintType.BIGINT.writeLong(bigintBlockBuilder, (long)i);
                this.writeRow(testRows[i], rowBlockBuilder);
                this.writeRow(testRows[i], rowBlockBuilder2);
                this.writeRow(testRows[i], rowBlockBuilder3);
            }
            pageBuilder.declarePositions(256);
            return pageBuilder.build();
        }

        private void writeRow(List<Object> testRow, BlockBuilder rowBlockBuilder) {
            BlockBuilder singleRowBlockWriter = rowBlockBuilder.beginBlockEntry();
            for (Object fieldValue : testRow) {
                if (fieldValue instanceof String) {
                    VarcharType.VARCHAR.writeSlice(singleRowBlockWriter, Slices.utf8Slice((String)((String)fieldValue)));
                    continue;
                }
                throw new UnsupportedOperationException();
            }
            rowBlockBuilder.closeEntry();
        }

        private List<Object>[] generateTestRows(List<Type> fieldTypes, int numRows) {
            List[] testRows = new List[numRows];
            for (int i = 0; i < numRows; ++i) {
                ArrayList<String> testRow = new ArrayList<String>(fieldTypes.size());
                for (int j = 0; j < fieldTypes.size(); ++j) {
                    if (fieldTypes.get(j) != VarcharType.VARCHAR) {
                        throw new UnsupportedOperationException();
                    }
                    byte[] data = new byte[ThreadLocalRandom.current().nextInt(128)];
                    ThreadLocalRandom.current().nextBytes(data);
                    testRow.add(new String(data, StandardCharsets.ISO_8859_1));
                }
                testRows[i] = testRow;
            }
            return testRows;
        }

        private DriverContext createDriverContext(TaskContext taskContext) {
            return taskContext.addPipelineContext(0, true, true, false).addDriverContext();
        }

        private TaskContext createTaskContext() {
            return TestingTaskContext.builder((Executor)EXECUTOR, (ScheduledExecutorService)SCHEDULER, (Session)SessionTestUtils.TEST_SESSION).setMemoryPoolSize(MAX_MEMORY).build();
        }

        private PartitionedOutputBuffer createPartitionedBuffer(OutputBuffers buffers, DataSize dataSize) {
            return new PartitionedOutputBuffer("task-instance-id", new StateMachine("bufferState", (Executor)SCHEDULER, (Object)BufferState.OPEN, (Iterable)BufferState.TERMINAL_BUFFER_STATES), buffers, dataSize, () -> new SimpleLocalMemoryContext(AggregatedMemoryContext.newSimpleAggregatedMemoryContext(), "test"), (Executor)SCHEDULER);
        }
    }
}

