/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.project;

import io.trino.block.BlockAssertions;
import io.trino.operator.DriverYieldSignal;
import io.trino.operator.project.InputPageProjection;
import io.trino.operator.project.SelectedPositions;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.LazyBlock;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.testing.TestingConnectorSession;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestInputPageProjection {
    @Test
    public void testLazyInputPage() {
        InputPageProjection projection = new InputPageProjection(0, (Type)BigintType.BIGINT);
        Block block = BlockAssertions.createLongSequenceBlock(0, 100);
        Block result = (Block)projection.project(TestingConnectorSession.SESSION, new DriverYieldSignal(), new Page(new Block[]{block}), SelectedPositions.positionsRange((int)0, (int)100)).getResult();
        Assert.assertFalse((boolean)(result instanceof LazyBlock));
        block = TestInputPageProjection.lazyWrapper(block);
        result = (Block)projection.project(TestingConnectorSession.SESSION, new DriverYieldSignal(), new Page(new Block[]{block}), SelectedPositions.positionsRange((int)0, (int)100)).getResult();
        Assert.assertTrue((boolean)(result instanceof LazyBlock));
        Assert.assertFalse((boolean)result.isLoaded());
    }

    private static LazyBlock lazyWrapper(Block block) {
        return new LazyBlock(block.getPositionCount(), () -> ((Block)block).getLoadedBlock());
    }
}

