/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import io.trino.jmh.Benchmarks;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataManager;
import io.trino.operator.DriverYieldSignal;
import io.trino.operator.project.PageProcessor;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.gen.ExpressionCompiler;
import io.trino.sql.gen.PageFunctionCompiler;
import io.trino.sql.relational.CallExpression;
import io.trino.sql.relational.Expressions;
import io.trino.sql.tree.QualifiedName;
import io.trino.testing.TestingConnectorSession;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.testng.annotations.Test;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Fork(value=2)
@Warmup(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkArrayIntersect {
    private static final int POSITIONS = 1000;

    @Benchmark
    @OperationsPerInvocation(value=1000)
    public List<Optional<Page>> arrayIntersect(BenchmarkData data) {
        return ImmutableList.copyOf((Iterator)data.getPageProcessor().process(TestingConnectorSession.SESSION, new DriverYieldSignal(), AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName()), data.getPage()));
    }

    @Test
    public void verify() {
        BenchmarkData data = new BenchmarkData();
        data.setup();
        new BenchmarkArrayIntersect().arrayIntersect(data);
    }

    public static void main(String[] args) throws Exception {
        BenchmarkData data = new BenchmarkData();
        data.setup();
        new BenchmarkArrayIntersect().arrayIntersect(data);
        Benchmarks.benchmark(BenchmarkArrayIntersect.class).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        private String name = "array_intersect";
        @Param(value={"BIGINT", "VARCHAR", "DOUBLE", "BOOLEAN"})
        private String type = "BIGINT";
        @Param(value={"10", "100", "1000"})
        private int arraySize = 10;
        private Page page;
        private PageProcessor pageProcessor;

        @Setup
        public void setup() {
            BigintType elementType;
            switch (this.type) {
                case "BIGINT": {
                    elementType = BigintType.BIGINT;
                    break;
                }
                case "VARCHAR": {
                    elementType = VarcharType.VARCHAR;
                    break;
                }
                case "DOUBLE": {
                    elementType = DoubleType.DOUBLE;
                    break;
                }
                case "BOOLEAN": {
                    elementType = BooleanType.BOOLEAN;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            MetadataManager metadata = MetadataManager.createTestMetadataManager();
            ArrayType arrayType = new ArrayType((Type)elementType);
            ImmutableList projections = ImmutableList.of((Object)new CallExpression(metadata.resolveFunction(QualifiedName.of((String)this.name), TypeSignatureProvider.fromTypes((Type[])new Type[]{arrayType, arrayType})), (List)ImmutableList.of((Object)Expressions.field((int)0, (Type)arrayType), (Object)Expressions.field((int)1, (Type)arrayType))));
            ExpressionCompiler compiler = new ExpressionCompiler((Metadata)metadata, new PageFunctionCompiler((Metadata)metadata, 0));
            this.pageProcessor = (PageProcessor)compiler.compilePageProcessor(Optional.empty(), (List)projections).get();
            this.page = new Page(new Block[]{BenchmarkData.createChannel(1000, this.arraySize, (Type)elementType), BenchmarkData.createChannel(1000, this.arraySize, (Type)elementType)});
        }

        private static Block createChannel(int positionCount, int arraySize, Type elementType) {
            ArrayType arrayType = new ArrayType(elementType);
            BlockBuilder blockBuilder = arrayType.createBlockBuilder(null, positionCount);
            for (int position = 0; position < positionCount; ++position) {
                BlockBuilder entryBuilder = blockBuilder.beginBlockEntry();
                for (int i = 0; i < arraySize; ++i) {
                    if (elementType.getJavaType() == Long.TYPE) {
                        elementType.writeLong(entryBuilder, ThreadLocalRandom.current().nextLong() % (long)arraySize);
                        continue;
                    }
                    if (elementType.getJavaType() == Double.TYPE) {
                        elementType.writeDouble(entryBuilder, ThreadLocalRandom.current().nextDouble() % (double)arraySize);
                        continue;
                    }
                    if (elementType.getJavaType() == Boolean.TYPE) {
                        elementType.writeBoolean(entryBuilder, ThreadLocalRandom.current().nextBoolean());
                        continue;
                    }
                    if (elementType.equals(VarcharType.VARCHAR)) {
                        elementType.writeSlice(entryBuilder, Slices.utf8Slice((String)Long.toString(ThreadLocalRandom.current().nextLong() % (long)arraySize)));
                        continue;
                    }
                    throw new UnsupportedOperationException();
                }
                blockBuilder.closeEntry();
            }
            return blockBuilder.build();
        }

        public PageProcessor getPageProcessor() {
            return this.pageProcessor;
        }

        public Page getPage() {
            return this.page;
        }
    }
}

