/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.trino.SessionTestUtils;
import io.trino.jmh.Benchmarks;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataManager;
import io.trino.metadata.ResolvedFunction;
import io.trino.operator.DriverYieldSignal;
import io.trino.operator.project.PageProcessor;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.sql.gen.ExpressionCompiler;
import io.trino.sql.gen.PageFunctionCompiler;
import io.trino.sql.relational.Expressions;
import io.trino.sql.relational.RowExpression;
import io.trino.sql.relational.SpecialForm;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.RunnerException;

@State(value=Scope.Thread)
@Fork(value=3)
@Warmup(iterations=5, time=10)
@Measurement(iterations=5, time=10)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
public class BenchmarkEqualsConjunctsOperator {
    private static final int FIELDS_COUNT = 10;
    private static final int COMPARISONS_COUNT = 100;
    private static final double NULLS_FRACTION = 0.05;
    private static final DriverYieldSignal SIGNAL = new DriverYieldSignal();
    private static final ConnectorSession SESSION = SessionTestUtils.TEST_SESSION.toConnectorSession();
    private Metadata metadata;
    private PageProcessor compiledProcessor;

    @Setup
    public void setup() {
        this.metadata = MetadataManager.createTestMetadataManager();
        ExpressionCompiler expressionCompiler = new ExpressionCompiler(this.metadata, new PageFunctionCompiler(this.metadata, 0));
        RowExpression projection = this.generateComplexComparisonProjection(10, 100);
        this.compiledProcessor = (PageProcessor)expressionCompiler.compilePageProcessor(Optional.empty(), (List)ImmutableList.of((Object)projection)).get();
    }

    private RowExpression generateComplexComparisonProjection(int fieldsCount, int comparisonsCount) {
        Preconditions.checkArgument((fieldsCount > 0 ? 1 : 0) != 0, (Object)"fieldsCount must be greater than zero");
        Preconditions.checkArgument((comparisonsCount > 0 ? 1 : 0) != 0, (Object)"comparisonsCount must be greater than zero");
        if (comparisonsCount == 1) {
            return this.createComparison(0, 0);
        }
        return BenchmarkEqualsConjunctsOperator.createConjunction(this.createComparison(0, comparisonsCount % fieldsCount), this.generateComplexComparisonProjection(fieldsCount, comparisonsCount - 1));
    }

    private static RowExpression createConjunction(RowExpression left, RowExpression right) {
        return new SpecialForm(SpecialForm.Form.OR, (Type)BooleanType.BOOLEAN, new RowExpression[]{left, right});
    }

    private RowExpression createComparison(int leftField, int rightField) {
        return Expressions.call((ResolvedFunction)this.metadata.resolveOperator(OperatorType.EQUAL, (List)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT)), (RowExpression[])new RowExpression[]{Expressions.field((int)leftField, (Type)BigintType.BIGINT), Expressions.field((int)rightField, (Type)BigintType.BIGINT)});
    }

    @Benchmark
    public List<Page> processPage(BenchmarkData data) {
        ArrayList<Page> output = new ArrayList<Page>();
        Iterator pageProcessorOutput = this.compiledProcessor.process(SESSION, SIGNAL, AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName()), data.page);
        while (pageProcessorOutput.hasNext()) {
            ((Optional)pageProcessorOutput.next()).ifPresent(output::add);
        }
        return output;
    }

    public static void main(String[] args) throws RunnerException {
        Benchmarks.benchmark(BenchmarkEqualsConjunctsOperator.class).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        Page page;

        @Setup
        public void setup() {
            ImmutableList types = ImmutableList.copyOf((Iterable)Iterables.limit((Iterable)Iterables.cycle((Object[])new BigintType[]{BigintType.BIGINT}), (int)10));
            ThreadLocalRandom random = ThreadLocalRandom.current();
            PageBuilder pageBuilder = new PageBuilder((List)types);
            while (!pageBuilder.isFull()) {
                pageBuilder.declarePosition();
                for (int channel = 0; channel < 10; ++channel) {
                    BlockBuilder blockBuilder = pageBuilder.getBlockBuilder(channel);
                    if (random.nextDouble() < 0.05) {
                        blockBuilder.appendNull();
                        continue;
                    }
                    BigintType.BIGINT.writeLong(blockBuilder, random.nextLong());
                }
            }
            this.page = pageBuilder.build();
        }
    }
}

