/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.jmh.Benchmarks;
import io.trino.operator.scalar.StringFunctions;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.RunnerException;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@BenchmarkMode(value={Mode.AverageTime})
@Fork(value=1)
@Warmup(iterations=4, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=5, time=500, timeUnit=TimeUnit.MILLISECONDS)
public class BenchmarkStringFunctions {
    @Benchmark
    public long benchmarkLength(BenchmarkData data) {
        return StringFunctions.length((Slice)data.getSlice());
    }

    @Benchmark
    public Slice benchmarkSubstringStart(BenchmarkData data) {
        Slice slice = data.getSlice();
        int length = data.getLength();
        return StringFunctions.substring((Slice)slice, (long)(length / 2 - 1));
    }

    @Benchmark
    public Slice benchmarkSubstringStartLength(BenchmarkData data) {
        Slice slice = data.getSlice();
        int length = data.getLength();
        return StringFunctions.substring((Slice)slice, (long)(length / 2 - 1), (long)(length / 2));
    }

    @Benchmark
    public Slice benchmarkSubstringStartFromEnd(BenchmarkData data) {
        Slice slice = data.getSlice();
        int length = data.getLength();
        return StringFunctions.substring((Slice)slice, (long)(-(length / 2 + 1)));
    }

    @Benchmark
    public Slice benchmarkSubstringStartLengthFromEnd(BenchmarkData data) {
        Slice slice = data.getSlice();
        int length = data.getLength();
        return StringFunctions.substring((Slice)slice, (long)(-(length / 2 + 1)), (long)(length / 2));
    }

    @Benchmark
    public Slice benchmarkReverse(BenchmarkData data) {
        return StringFunctions.reverse((Slice)data.getSlice());
    }

    @Benchmark
    public Slice benchmarkLeftTrim(WhitespaceData data) {
        return StringFunctions.leftTrim((Slice)data.getLeftWhitespace());
    }

    @Benchmark
    public Slice benchmarkRightTrim(WhitespaceData data) {
        return StringFunctions.rightTrim((Slice)data.getRightWhitespace());
    }

    @Benchmark
    public Slice benchmarkTrim(WhitespaceData data) {
        return StringFunctions.trim((Slice)data.getBothWhitespace());
    }

    @Benchmark
    public Slice benchmarkUpper(BenchmarkData data) {
        return StringFunctions.upper((Slice)data.getSlice());
    }

    @Benchmark
    public Slice benchmarkLower(BenchmarkData data) {
        return StringFunctions.lower((Slice)data.getSlice());
    }

    public static void main(String[] args) throws RunnerException {
        Benchmarks.benchmark(BenchmarkStringFunctions.class).run();
    }

    @State(value=Scope.Thread)
    public static class WhitespaceData {
        private static final int[] ASCII_WHITESPACE = IntStream.range(0, 127).filter(Character::isWhitespace).toArray();
        private static final int[] ALL_WHITESPACE = IntStream.range(0, 0x10FFFF).filter(Character::isWhitespace).toArray();
        @Param(value={"2", "5", "10", "100", "1000", "10000"})
        private int length;
        @Param(value={"true", "false"})
        private boolean ascii;
        private Slice leftWhitespace;
        private Slice rightWhitespace;
        private Slice bothWhitespace;

        @Setup
        public void setup() {
            Slice whitespace = WhitespaceData.createRandomUtf8Slice(this.ascii ? ASCII_WHITESPACE : ALL_WHITESPACE, this.length + 1);
            this.leftWhitespace = Slices.copyOf((Slice)whitespace);
            this.leftWhitespace.setByte(this.leftWhitespace.length() - 1, 88);
            this.rightWhitespace = Slices.copyOf((Slice)whitespace);
            this.rightWhitespace.setByte(0, 88);
            this.bothWhitespace = Slices.copyOf((Slice)whitespace);
            this.bothWhitespace.setByte(this.length / 2, 88);
        }

        private static Slice createRandomUtf8Slice(int[] codePointSet, int length) {
            int[] codePoints = new int[length];
            ThreadLocalRandom random = ThreadLocalRandom.current();
            for (int i = 0; i < codePoints.length; ++i) {
                int codePoint;
                codePoints[i] = codePoint = codePointSet[random.nextInt(codePointSet.length)];
            }
            return Slices.utf8Slice((String)new String(codePoints, 0, codePoints.length));
        }

        public int getLength() {
            return this.length;
        }

        public Slice getLeftWhitespace() {
            return this.leftWhitespace;
        }

        public Slice getRightWhitespace() {
            return this.rightWhitespace;
        }

        public Slice getBothWhitespace() {
            return this.bothWhitespace;
        }
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        private static final int[] ASCII_CODE_POINTS = IntStream.range(0, 127).toArray();
        private static final int[] ALL_CODE_POINTS = IntStream.range(0, 0x10FFFF).filter(codePoint -> Character.getType(codePoint) != 19).toArray();
        @Param(value={"2", "5", "10", "100", "1000", "10000"})
        private int length;
        @Param(value={"true", "false"})
        private boolean ascii;
        private Slice slice;
        private int[] codePoints;

        @Setup
        public void setup() {
            int[] codePointSet = this.ascii ? ASCII_CODE_POINTS : ALL_CODE_POINTS;
            ThreadLocalRandom random = ThreadLocalRandom.current();
            this.codePoints = new int[this.length];
            DynamicSliceOutput sliceOutput = new DynamicSliceOutput(this.length * 4);
            for (int i = 0; i < this.codePoints.length; ++i) {
                int codePoint;
                this.codePoints[i] = codePoint = codePointSet[random.nextInt(codePointSet.length)];
                sliceOutput.appendBytes(new String(Character.toChars(codePoint)).getBytes(StandardCharsets.UTF_8));
            }
            this.slice = sliceOutput.slice();
        }

        public Slice getSlice() {
            return this.slice;
        }

        public int getLength() {
            return this.length;
        }
    }
}

