/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.airlift.concurrent.Threads;
import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.testing.Assertions;
import io.airlift.units.DataSize;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.block.BlockAssertions;
import io.trino.connector.CatalogName;
import io.trino.execution.Lifespan;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.metadata.Metadata;
import io.trino.metadata.Split;
import io.trino.metadata.TableHandle;
import io.trino.operator.DriverContext;
import io.trino.operator.DriverYieldSignal;
import io.trino.operator.FilterAndProjectOperator;
import io.trino.operator.Operator;
import io.trino.operator.OperatorFactory;
import io.trino.operator.ScanFilterAndProjectOperator;
import io.trino.operator.SourceOperator;
import io.trino.operator.SourceOperatorFactory;
import io.trino.operator.project.PageProcessor;
import io.trino.operator.project.PageProjection;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.HostAddress;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.Plugin;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.block.Block;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.FixedPageSource;
import io.trino.spi.connector.InMemoryRecordSet;
import io.trino.spi.connector.RecordPageSource;
import io.trino.spi.connector.RecordSet;
import io.trino.spi.predicate.Utils;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import io.trino.split.PageSourceProvider;
import io.trino.sql.ExpressionTestUtils;
import io.trino.sql.analyzer.FeaturesConfig;
import io.trino.sql.gen.ExpressionCompiler;
import io.trino.sql.planner.ExpressionInterpreter;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.relational.Expressions;
import io.trino.sql.relational.RowExpression;
import io.trino.sql.relational.SqlToRowExpressionTranslator;
import io.trino.sql.tree.DefaultTraversalVisitor;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.SymbolReference;
import io.trino.testing.LocalQueryRunner;
import io.trino.testing.MaterializedResult;
import io.trino.testing.MaterializedRow;
import io.trino.testing.TestingHandles;
import io.trino.testing.TestingTaskContext;
import io.trino.testing.assertions.TrinoExceptionAssert;
import io.trino.type.BlockTypeOperators;
import io.trino.type.UnknownType;
import java.io.Closeable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.openjdk.jol.info.ClassLayout;
import org.testng.Assert;

public final class FunctionAssertions
implements Closeable {
    private static final ExecutorService EXECUTOR = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"FunctionAssertions-%s"));
    private static final ScheduledExecutorService SCHEDULED_EXECUTOR = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)"FunctionAssertions-scheduledExecutor-%s"));
    private static final int TEST_ROW_NUMBER_OF_FIELDS = 2500;
    private static final RowType TEST_ROW_TYPE = FunctionAssertions.createTestRowType(2500);
    private static final Block TEST_ROW_DATA = FunctionAssertions.createTestRowData(TEST_ROW_TYPE);
    private static final DecimalType SHORT_DECIMAL_TYPE = DecimalType.createDecimalType((int)14);
    private static final DecimalType LONG_DECIMAL_TYPE = DecimalType.createDecimalType((int)28);
    private static final Page SOURCE_PAGE = new Page(new Block[]{BlockAssertions.createLongsBlock(1234L), BlockAssertions.createStringsBlock("hello"), BlockAssertions.createDoublesBlock(12.34), BlockAssertions.createBooleansBlock(true), BlockAssertions.createLongsBlock(new DateTime(2001, 8, 22, 3, 4, 5, 321, DateTimeZone.UTC).getMillis()), BlockAssertions.createStringsBlock("%el%"), BlockAssertions.createStringsBlock(new String[]{null}), BlockAssertions.createTimestampsWithTimeZoneMillisBlock(DateTimeEncoding.packDateTimeWithZone((long)new DateTime(1970, 1, 1, 0, 1, 0, 999, DateTimeZone.UTC).getMillis(), (TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)"Z"))), BlockAssertions.createSlicesBlock(Slices.wrappedBuffer((byte[])new byte[]{-85})), BlockAssertions.createIntsBlock(1234), TEST_ROW_DATA, BlockAssertions.createShortDecimalsBlock("1234"), BlockAssertions.createLongDecimalsBlock("1234")});
    private static final Page ZERO_CHANNEL_PAGE = new Page(1);
    private static final TypeProvider INPUT_TYPES = TypeProvider.copyOf((Map)ImmutableMap.builder().put((Object)new Symbol("bound_long"), (Object)BigintType.BIGINT).put((Object)new Symbol("bound_string"), (Object)VarcharType.VARCHAR).put((Object)new Symbol("bound_double"), (Object)DoubleType.DOUBLE).put((Object)new Symbol("bound_boolean"), (Object)BooleanType.BOOLEAN).put((Object)new Symbol("bound_timestamp"), (Object)BigintType.BIGINT).put((Object)new Symbol("bound_pattern"), (Object)VarcharType.VARCHAR).put((Object)new Symbol("bound_null_string"), (Object)VarcharType.VARCHAR).put((Object)new Symbol("bound_timestamp_with_timezone"), (Object)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS).put((Object)new Symbol("bound_binary_literal"), (Object)VarbinaryType.VARBINARY).put((Object)new Symbol("bound_integer"), (Object)IntegerType.INTEGER).put((Object)new Symbol("bound_row"), (Object)TEST_ROW_TYPE).put((Object)new Symbol("bound_short_decimal"), (Object)SHORT_DECIMAL_TYPE).put((Object)new Symbol("bound_long_decimal"), (Object)LONG_DECIMAL_TYPE).build());
    private static final Map<Symbol, Integer> INPUT_MAPPING = ImmutableMap.builder().put((Object)new Symbol("bound_long"), (Object)0).put((Object)new Symbol("bound_string"), (Object)1).put((Object)new Symbol("bound_double"), (Object)2).put((Object)new Symbol("bound_boolean"), (Object)3).put((Object)new Symbol("bound_timestamp"), (Object)4).put((Object)new Symbol("bound_pattern"), (Object)5).put((Object)new Symbol("bound_null_string"), (Object)6).put((Object)new Symbol("bound_timestamp_with_timezone"), (Object)7).put((Object)new Symbol("bound_binary_literal"), (Object)8).put((Object)new Symbol("bound_integer"), (Object)9).put((Object)new Symbol("bound_row"), (Object)10).put((Object)new Symbol("bound_short_decimal"), (Object)11).put((Object)new Symbol("bound_long_decimal"), (Object)12).build();
    private static final PageSourceProvider PAGE_SOURCE_PROVIDER = new TestPageSourceProvider();
    private static final PlanNodeId SOURCE_ID = new PlanNodeId("scan");
    private final Session session;
    private final LocalQueryRunner runner;
    private final Metadata metadata;
    private final ExpressionCompiler compiler;

    public FunctionAssertions() {
        this(SessionTestUtils.TEST_SESSION);
    }

    public FunctionAssertions(Session session) {
        this(session, new FeaturesConfig());
    }

    public FunctionAssertions(Session session, FeaturesConfig featuresConfig) {
        this.session = Objects.requireNonNull(session, "session is null");
        this.runner = LocalQueryRunner.builder((Session)session).withFeaturesConfig(featuresConfig).build();
        this.metadata = this.runner.getMetadata();
        this.compiler = this.runner.getExpressionCompiler();
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public TypeOperators getTypeOperators() {
        return this.runner.getTypeOperators();
    }

    public BlockTypeOperators getBlockTypeOperators() {
        return this.runner.getBlockTypeOperators();
    }

    public void installPlugin(Plugin plugin) {
        this.runner.installPlugin(plugin);
    }

    public void assertFunction(String projection, Type expectedType, Object expected) {
        if (expected instanceof Slice) {
            expected = ((Slice)expected).toStringUtf8();
        }
        Object actual = this.selectSingleValue(projection, expectedType, this.compiler);
        Assert.assertEquals((Object)actual, (Object)expected);
    }

    public void assertFunctionString(String projection, Type expectedType, String expected) {
        Object actual = this.selectSingleValue(projection, expectedType, this.compiler);
        Assert.assertEquals((String)actual.toString(), (String)expected);
    }

    public void tryEvaluate(String expression, Type expectedType) {
        this.tryEvaluate(expression, expectedType, this.session);
    }

    public void tryEvaluate(String expression, Type expectedType, Session session) {
        this.selectUniqueValue(expression, expectedType, session, this.compiler);
    }

    public void tryEvaluateWithAll(String expression, Type expectedType) {
        this.tryEvaluateWithAll(expression, expectedType, this.session);
    }

    public void tryEvaluateWithAll(String expression, Type expectedType, Session session) {
        this.executeProjectionWithAll(expression, expectedType, session, this.compiler);
    }

    public void executeProjectionWithFullEngine(String projection) {
        this.runner.execute("SELECT " + projection);
    }

    private Object selectSingleValue(String projection, Type expectedType, ExpressionCompiler compiler) {
        return this.selectUniqueValue(projection, expectedType, this.session, compiler);
    }

    private Object selectUniqueValue(String projection, Type expectedType, Session session, ExpressionCompiler compiler) {
        List<Object> results = this.executeProjectionWithAll(projection, expectedType, session, compiler);
        HashSet<Object> resultSet = new HashSet<Object>(results);
        Assert.assertEquals((int)resultSet.size(), (int)1, (String)("Expected only one result unique result, but got " + resultSet));
        return Iterables.getOnlyElement(resultSet);
    }

    public void assertInvalidFunction(String projection, ErrorCodeSupplier errorCode, String message) {
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.evaluateInvalid(projection)).hasErrorCode(errorCode).hasMessage(message);
    }

    public void assertInvalidFunction(String projection, String message) {
        this.assertInvalidFunction(projection, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, message);
    }

    public void assertInvalidFunction(String projection, ErrorCodeSupplier expectedErrorCode) {
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.evaluateInvalid(projection)).hasErrorCode(expectedErrorCode);
    }

    public void assertNumericOverflow(String projection, String message) {
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.evaluateInvalid(projection)).hasErrorCode((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE).hasMessage(message);
    }

    public void assertInvalidCast(String projection) {
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.evaluateInvalid(projection)).hasErrorCode((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT);
    }

    public void assertInvalidCast(String projection, String message) {
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.evaluateInvalid(projection)).hasErrorCode((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT).hasMessage(message);
    }

    private void evaluateInvalid(String projection) {
        this.selectSingleValue(projection, (Type)UnknownType.UNKNOWN, this.compiler);
    }

    public void assertCachedInstanceHasBoundedRetainedSize(String projection) {
        Objects.requireNonNull(projection, "projection is null");
        Expression projectionExpression = ExpressionTestUtils.createExpression(this.session, projection, this.metadata, INPUT_TYPES);
        RowExpression projectionRowExpression = this.toRowExpression(this.session, projectionExpression);
        PageProcessor processor = (PageProcessor)this.compiler.compilePageProcessor(Optional.empty(), (List)ImmutableList.of((Object)projectionRowExpression)).get();
        long maxRetainedSize = 0L;
        int maxIterationCount = 0;
        for (int iterationCount = 0; iterationCount < Math.max(1000, maxIterationCount * 4); ++iterationCount) {
            Iterator output = processor.process(this.session.toConnectorSession(), new DriverYieldSignal(), AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName()), SOURCE_PAGE);
            Iterators.getOnlyElement((Iterator)output);
            long retainedSize = processor.getProjections().stream().mapToLong(this::getRetainedSizeOfCachedInstance).sum();
            if (retainedSize > maxRetainedSize) {
                maxRetainedSize = retainedSize;
                maxIterationCount = iterationCount;
            }
            if (maxRetainedSize < 0x100000L) continue;
            Assert.fail((String)String.format("The retained size of cached instance of function invocation is likely unbounded: %s", projection));
        }
    }

    private long getRetainedSizeOfCachedInstance(PageProjection projection) {
        Field[] fields = projection.getClass().getDeclaredFields();
        long retainedSize = 0L;
        for (Field field : fields) {
            field.setAccessible(true);
            String fieldName = field.getName();
            if (!fieldName.startsWith("__cachedInstance")) continue;
            try {
                retainedSize += this.getRetainedSizeOf(field.get(projection));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return retainedSize;
    }

    private long getRetainedSizeOf(Object object) {
        Field[] fields;
        if (object instanceof PageBuilder) {
            return ((PageBuilder)object).getRetainedSizeInBytes();
        }
        if (object instanceof Block) {
            return ((Block)object).getRetainedSizeInBytes();
        }
        Class<?> type = object.getClass();
        if (type.isArray()) {
            if (type == int[].class) {
                return SizeOf.sizeOf((int[])((int[])object));
            }
            if (type == boolean[].class) {
                return SizeOf.sizeOf((boolean[])((boolean[])object));
            }
            if (type == byte[].class) {
                return SizeOf.sizeOf((byte[])((byte[])object));
            }
            if (type == long[].class) {
                return SizeOf.sizeOf((long[])((long[])object));
            }
            if (type == short[].class) {
                return SizeOf.sizeOf((short[])((short[])object));
            }
            if (type == Block[].class) {
                Object[] objects = (Object[])object;
                return Arrays.stream(objects).mapToLong(this::getRetainedSizeOf).sum();
            }
            throw new IllegalArgumentException(String.format("Unknown type encountered: %s", type));
        }
        long retainedSize = ClassLayout.parseClass(type).instanceSize();
        for (Field field : fields = type.getDeclaredFields()) {
            try {
                if (field.getType().isPrimitive() || Modifier.isStatic(field.getModifiers())) continue;
                field.setAccessible(true);
                retainedSize += this.getRetainedSizeOf(field.get(object));
            }
            catch (IllegalAccessException t) {
                throw new RuntimeException(t);
            }
        }
        return retainedSize;
    }

    private List<Object> executeProjectionWithAll(String projection, Type expectedType, Session session, ExpressionCompiler compiler) {
        Objects.requireNonNull(projection, "projection is null");
        Expression projectionExpression = ExpressionTestUtils.createExpression(session, projection, this.metadata, INPUT_TYPES);
        RowExpression projectionRowExpression = this.toRowExpression(session, projectionExpression);
        ArrayList<Object> results = new ArrayList<Object>();
        if (!FunctionAssertions.needsBoundValue(projectionExpression)) {
            MaterializedResult result = this.runner.execute("SELECT " + projection);
            FunctionAssertions.assertType(result.getTypes(), expectedType);
            Assert.assertEquals((int)result.getTypes().size(), (int)1);
            Assert.assertEquals((int)result.getMaterializedRows().size(), (int)1);
            Object queryResult = ((MaterializedRow)Iterables.getOnlyElement((Iterable)result.getMaterializedRows())).getField(0);
            results.add(queryResult);
        }
        OperatorFactory operatorFactory = FunctionAssertions.compileFilterProject(Optional.empty(), projectionRowExpression, compiler);
        Object directOperatorValue = this.selectSingleValue(operatorFactory, expectedType, session);
        results.add(directOperatorValue);
        Object interpretedValue = this.interpret(projectionExpression, expectedType, session);
        results.add(interpretedValue);
        SourceOperatorFactory scanProjectOperatorFactory = FunctionAssertions.compileScanFilterProject(Optional.empty(), projectionRowExpression, compiler);
        Object scanOperatorValue = this.selectSingleValue(scanProjectOperatorFactory, expectedType, FunctionAssertions.createNormalSplit(), session);
        results.add(scanOperatorValue);
        Object recordValue = this.selectSingleValue(scanProjectOperatorFactory, expectedType, FunctionAssertions.createRecordSetSplit(), session);
        results.add(recordValue);
        if (!FunctionAssertions.needsBoundValue(projectionExpression)) {
            MaterializedResult result = this.runner.execute("SELECT " + projection);
            FunctionAssertions.assertType(result.getTypes(), expectedType);
            Assert.assertEquals((int)result.getTypes().size(), (int)1);
            Assert.assertEquals((int)result.getMaterializedRows().size(), (int)1);
            Object queryResult = ((MaterializedRow)Iterables.getOnlyElement((Iterable)result.getMaterializedRows())).getField(0);
            results.add(queryResult);
        }
        Assert.assertEquals((Object)projectionRowExpression.getType(), (Object)expectedType);
        return results;
    }

    private RowExpression toRowExpression(Session session, Expression projectionExpression) {
        return this.toRowExpression(projectionExpression, ExpressionTestUtils.getTypes(session, this.metadata, INPUT_TYPES, projectionExpression), INPUT_MAPPING);
    }

    private Object selectSingleValue(OperatorFactory operatorFactory, Type type, Session session) {
        Operator operator = operatorFactory.createOperator(FunctionAssertions.createDriverContext(session));
        return this.selectSingleValue(operator, type);
    }

    private Object selectSingleValue(SourceOperatorFactory operatorFactory, Type type, Split split, Session session) {
        SourceOperator operator = operatorFactory.createOperator(FunctionAssertions.createDriverContext(session));
        operator.addSplit(split);
        operator.noMoreSplits();
        return this.selectSingleValue((Operator)operator, type);
    }

    private Object selectSingleValue(Operator operator, Type type) {
        Page output = FunctionAssertions.getAtMostOnePage(operator, SOURCE_PAGE);
        Assert.assertNotNull((Object)output);
        Assert.assertEquals((int)output.getPositionCount(), (int)1);
        Assert.assertEquals((int)output.getChannelCount(), (int)1);
        Block block = output.getBlock(0);
        Assert.assertEquals((int)block.getPositionCount(), (int)1);
        return type.getObjectValue(this.session.toConnectorSession(), block, 0);
    }

    public void assertFilter(String filter, boolean expected, boolean withNoInputColumns) {
        this.assertFilter(filter, expected, withNoInputColumns, this.compiler);
    }

    private void assertFilter(String filter, boolean expected, boolean withNoInputColumns, ExpressionCompiler compiler) {
        List<Boolean> results = this.executeFilterWithAll(filter, SessionTestUtils.TEST_SESSION, withNoInputColumns, compiler);
        HashSet<Boolean> resultSet = new HashSet<Boolean>(results);
        Assert.assertTrue((resultSet.size() == 1 ? 1 : 0) != 0, (String)("Expected only [" + expected + "] result unique result, but got " + resultSet));
        Assert.assertEquals((boolean)((Boolean)Iterables.getOnlyElement(resultSet)), (boolean)expected);
    }

    private List<Boolean> executeFilterWithAll(String filter, Session session, boolean executeWithNoInputColumns, ExpressionCompiler compiler) {
        Boolean interpretedValue;
        Objects.requireNonNull(filter, "filter is null");
        Expression filterExpression = ExpressionTestUtils.createExpression(session, filter, this.metadata, INPUT_TYPES);
        RowExpression filterRowExpression = this.toRowExpression(session, filterExpression);
        ArrayList<Boolean> results = new ArrayList<Boolean>();
        OperatorFactory operatorFactory = FunctionAssertions.compileFilterProject(Optional.of(filterRowExpression), (RowExpression)Expressions.constant((Object)true, (Type)BooleanType.BOOLEAN), compiler);
        results.add(FunctionAssertions.executeFilter(operatorFactory, session));
        if (executeWithNoInputColumns) {
            operatorFactory = FunctionAssertions.compileFilterWithNoInputColumns(filterRowExpression, compiler);
            results.add(FunctionAssertions.executeFilterWithNoInputColumns(operatorFactory, session));
        }
        if ((interpretedValue = (Boolean)this.interpret(filterExpression, (Type)BooleanType.BOOLEAN, session)) == null) {
            interpretedValue = false;
        }
        results.add(interpretedValue);
        SourceOperatorFactory scanProjectOperatorFactory = FunctionAssertions.compileScanFilterProject(Optional.of(filterRowExpression), (RowExpression)Expressions.constant((Object)true, (Type)BooleanType.BOOLEAN), compiler);
        boolean scanOperatorValue = FunctionAssertions.executeFilter(scanProjectOperatorFactory, FunctionAssertions.createNormalSplit(), session);
        results.add(scanOperatorValue);
        boolean recordValue = FunctionAssertions.executeFilter(scanProjectOperatorFactory, FunctionAssertions.createRecordSetSplit(), session);
        results.add(recordValue);
        if (!FunctionAssertions.needsBoundValue(filterExpression)) {
            Boolean queryResult;
            MaterializedResult result = this.runner.execute("SELECT TRUE WHERE " + filter);
            Assert.assertEquals((int)result.getTypes().size(), (int)1);
            if (result.getMaterializedRows().isEmpty()) {
                queryResult = false;
            } else {
                Assert.assertEquals((int)result.getMaterializedRows().size(), (int)1);
                queryResult = (Boolean)((MaterializedRow)Iterables.getOnlyElement((Iterable)result.getMaterializedRows())).getField(0);
            }
            results.add(queryResult);
        }
        return results;
    }

    private static boolean executeFilterWithNoInputColumns(OperatorFactory operatorFactory, Session session) {
        return FunctionAssertions.executeFilterWithNoInputColumns(operatorFactory.createOperator(FunctionAssertions.createDriverContext(session)));
    }

    private static boolean executeFilter(OperatorFactory operatorFactory, Session session) {
        return FunctionAssertions.executeFilter(operatorFactory.createOperator(FunctionAssertions.createDriverContext(session)));
    }

    private static boolean executeFilter(SourceOperatorFactory operatorFactory, Split split, Session session) {
        SourceOperator operator = operatorFactory.createOperator(FunctionAssertions.createDriverContext(session));
        operator.addSplit(split);
        operator.noMoreSplits();
        return FunctionAssertions.executeFilter((Operator)operator);
    }

    private static boolean executeFilter(Operator operator) {
        boolean value;
        Page page = FunctionAssertions.getAtMostOnePage(operator, SOURCE_PAGE);
        if (page != null) {
            Assert.assertEquals((int)page.getPositionCount(), (int)1);
            Assert.assertEquals((int)page.getChannelCount(), (int)1);
            Assert.assertTrue((boolean)BooleanType.BOOLEAN.getBoolean(page.getBlock(0), 0));
            value = true;
        } else {
            value = false;
        }
        return value;
    }

    private static boolean executeFilterWithNoInputColumns(Operator operator) {
        boolean value;
        Page page = FunctionAssertions.getAtMostOnePage(operator, ZERO_CHANNEL_PAGE);
        if (page != null) {
            Assert.assertEquals((int)page.getPositionCount(), (int)1);
            Assert.assertEquals((int)page.getChannelCount(), (int)0);
            value = true;
        } else {
            value = false;
        }
        return value;
    }

    private static boolean needsBoundValue(Expression projectionExpression) {
        final AtomicBoolean hasSymbolReferences = new AtomicBoolean();
        new DefaultTraversalVisitor<Void>(){

            protected Void visitSymbolReference(SymbolReference node, Void context) {
                hasSymbolReferences.set(true);
                return null;
            }
        }.process((Node)projectionExpression, null);
        return hasSymbolReferences.get();
    }

    private Object interpret(Expression expression, Type expectedType, Session session) {
        Map<NodeRef<Expression>, Type> expressionTypes = ExpressionTestUtils.getTypes(session, this.metadata, INPUT_TYPES, expression);
        ExpressionInterpreter evaluator = new ExpressionInterpreter(expression, this.metadata, session, expressionTypes);
        Object result = evaluator.evaluate(symbol -> {
            int position = 0;
            int channel = INPUT_MAPPING.get(symbol);
            Type type = INPUT_TYPES.get(symbol);
            Block block = SOURCE_PAGE.getBlock(channel);
            if (block.isNull(position)) {
                return null;
            }
            Class javaType = type.getJavaType();
            if (javaType == Boolean.TYPE) {
                return type.getBoolean(block, position);
            }
            if (javaType == Long.TYPE) {
                return type.getLong(block, position);
            }
            if (javaType == Double.TYPE) {
                return type.getDouble(block, position);
            }
            if (javaType == Slice.class) {
                return type.getSlice(block, position);
            }
            if (javaType == Block.class) {
                return type.getObject(block, position);
            }
            throw new UnsupportedOperationException("not yet implemented");
        });
        Block block = Utils.nativeValueToBlock((Type)expectedType, (Object)result);
        return expectedType.getObjectValue(session.toConnectorSession(), block, 0);
    }

    private static OperatorFactory compileFilterWithNoInputColumns(RowExpression filter, ExpressionCompiler compiler) {
        try {
            Supplier processor = compiler.compilePageProcessor(Optional.of(filter), (List)ImmutableList.of());
            return FilterAndProjectOperator.createOperatorFactory((int)0, (PlanNodeId)new PlanNodeId("test"), (Supplier)processor, (List)ImmutableList.of(), (DataSize)DataSize.ofBytes((long)0L), (int)0);
        }
        catch (Throwable e) {
            if (e instanceof UncheckedExecutionException) {
                e = e.getCause();
            }
            throw new RuntimeException("Error compiling " + filter + ": " + e.getMessage(), e);
        }
    }

    private static OperatorFactory compileFilterProject(Optional<RowExpression> filter, RowExpression projection, ExpressionCompiler compiler) {
        try {
            Supplier processor = compiler.compilePageProcessor(filter, (List)ImmutableList.of((Object)projection));
            return FilterAndProjectOperator.createOperatorFactory((int)0, (PlanNodeId)new PlanNodeId("test"), (Supplier)processor, (List)ImmutableList.of((Object)projection.getType()), (DataSize)DataSize.ofBytes((long)0L), (int)0);
        }
        catch (Throwable e) {
            if (e instanceof UncheckedExecutionException) {
                e = e.getCause();
            }
            throw new RuntimeException("Error compiling " + projection + ": " + e.getMessage(), e);
        }
    }

    private static SourceOperatorFactory compileScanFilterProject(Optional<RowExpression> filter, RowExpression projection, ExpressionCompiler compiler) {
        try {
            Supplier cursorProcessor = compiler.compileCursorProcessor(filter, (List)ImmutableList.of((Object)projection), (Object)SOURCE_ID);
            Supplier pageProcessor = compiler.compilePageProcessor(filter, (List)ImmutableList.of((Object)projection));
            return new ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory(0, new PlanNodeId("test"), SOURCE_ID, PAGE_SOURCE_PROVIDER, cursorProcessor, pageProcessor, TestingHandles.TEST_TABLE_HANDLE, (Iterable)ImmutableList.of(), DynamicFilter.EMPTY, (List)ImmutableList.of((Object)projection.getType()), DataSize.ofBytes((long)0L), 0);
        }
        catch (Throwable e) {
            if (e instanceof UncheckedExecutionException) {
                e = e.getCause();
            }
            throw new RuntimeException("Error compiling filter " + filter + ": " + e.getMessage(), e);
        }
    }

    private RowExpression toRowExpression(Expression projection, Map<NodeRef<Expression>, Type> expressionTypes, Map<Symbol, Integer> layout) {
        return SqlToRowExpressionTranslator.translate((Expression)projection, expressionTypes, layout, (Metadata)this.metadata, (Session)this.session, (boolean)false);
    }

    private static Page getAtMostOnePage(Operator operator, Page sourcePage) {
        if (operator.needsInput()) {
            operator.addInput(sourcePage);
        }
        Page result = operator.getOutput();
        operator.finish();
        while (!operator.isFinished()) {
            Assert.assertTrue((boolean)operator.isBlocked().isDone());
            Page output = operator.getOutput();
            if (output == null) continue;
            Assert.assertNull((Object)result);
            result = output;
        }
        return result;
    }

    private static DriverContext createDriverContext(Session session) {
        return TestingTaskContext.createTaskContext((Executor)EXECUTOR, (ScheduledExecutorService)SCHEDULED_EXECUTOR, (Session)session).addPipelineContext(0, true, true, false).addDriverContext();
    }

    private static void assertType(List<Type> types, Type expectedType) {
        Assert.assertTrue((types.size() == 1 ? 1 : 0) != 0, (String)("Expected one type, but got " + types));
        Type actualType = types.get(0);
        Assert.assertEquals((Object)actualType, (Object)expectedType);
    }

    public Session getSession() {
        return this.session;
    }

    @Override
    public void close() {
        this.runner.close();
    }

    private static Split createRecordSetSplit() {
        return new Split(new CatalogName("test"), (ConnectorSplit)new TestSplit(true), Lifespan.taskWide());
    }

    private static Split createNormalSplit() {
        return new Split(new CatalogName("test"), (ConnectorSplit)new TestSplit(false), Lifespan.taskWide());
    }

    private static RowType createTestRowType(int numberOfFields) {
        Iterator types = Iterables.cycle((Object[])new Type[]{BigintType.BIGINT, IntegerType.INTEGER, VarcharType.VARCHAR, DoubleType.DOUBLE, BooleanType.BOOLEAN, VarbinaryType.VARBINARY, RowType.from((List)ImmutableList.of((Object)RowType.field((String)"nested_nested_column", (Type)VarcharType.VARCHAR)))}).iterator();
        ArrayList<RowType.Field> fields = new ArrayList<RowType.Field>();
        for (int fieldIdx = 0; fieldIdx < numberOfFields; ++fieldIdx) {
            fields.add(new RowType.Field(Optional.of("nested_column_" + fieldIdx), (Type)types.next()));
        }
        return RowType.from(fields);
    }

    private static Block createTestRowData(RowType rowType) {
        Iterator values = Iterables.cycle((Object[])new Object[]{1234L, 34, "hello", 12.34, true, Slices.wrappedBuffer((byte[])new byte[]{-85}), BlockAssertions.createRowBlock((List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR), new Object[][]{Collections.singleton("innerFieldValue").toArray()}).getObject(0, Block.class)}).iterator();
        int numFields = rowType.getFields().size();
        Object[] rowValues = new Object[numFields];
        for (int fieldIdx = 0; fieldIdx < numFields; ++fieldIdx) {
            rowValues[fieldIdx] = values.next();
        }
        return BlockAssertions.createRowBlock(rowType.getTypeParameters(), new Object[][]{rowValues});
    }

    private static class TestSplit
    implements ConnectorSplit {
        private final boolean recordSet;

        private TestSplit(boolean recordSet) {
            this.recordSet = recordSet;
        }

        private boolean isRecordSet() {
            return this.recordSet;
        }

        public boolean isRemotelyAccessible() {
            return false;
        }

        public List<HostAddress> getAddresses() {
            return ImmutableList.of();
        }

        public Object getInfo() {
            return this;
        }
    }

    private static class TestPageSourceProvider
    implements PageSourceProvider {
        private TestPageSourceProvider() {
        }

        public ConnectorPageSource createPageSource(Session session, Split split, TableHandle table, List<ColumnHandle> columns, DynamicFilter dynamicFilter) {
            Assertions.assertInstanceOf((Object)split.getConnectorSplit(), TestSplit.class);
            TestSplit testSplit = (TestSplit)split.getConnectorSplit();
            if (testSplit.isRecordSet()) {
                InMemoryRecordSet records = InMemoryRecordSet.builder((Collection)ImmutableList.of((Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR, (Object)DoubleType.DOUBLE, (Object)BooleanType.BOOLEAN, (Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR, (Object)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, (Object)VarbinaryType.VARBINARY, (Object)IntegerType.INTEGER, (Object)TEST_ROW_TYPE, (Object)SHORT_DECIMAL_TYPE, (Object[])new Type[]{LONG_DECIMAL_TYPE})).addRow(new Object[]{1234L, "hello", 12.34, true, new DateTime(2001, 8, 22, 3, 4, 5, 321, DateTimeZone.UTC).getMillis(), "%el%", null, DateTimeEncoding.packDateTimeWithZone((long)new DateTime(1970, 1, 1, 0, 1, 0, 999, DateTimeZone.UTC).getMillis(), (TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)"Z")), Slices.wrappedBuffer((byte[])new byte[]{-85}), 1234, TEST_ROW_DATA.getObject(0, Block.class), new BigDecimal("1234").unscaledValue().longValue(), Decimals.encodeScaledValue((BigDecimal)new BigDecimal("1234"))}).build();
                return new RecordPageSource((RecordSet)records);
            }
            return new FixedPageSource((Iterable)ImmutableList.of((Object)SOURCE_PAGE));
        }
    }
}

