/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.trino.operator.scalar.AbstractTestFunctions;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import org.testng.annotations.Test;

public class TestTypeOfFunction
extends AbstractTestFunctions {
    @Test
    public void testSimpleType() {
        this.assertFunction("typeof(CAST(1 AS BIGINT))", (Type)VarcharType.VARCHAR, "bigint");
        this.assertFunction("typeof(CAST(1 AS INTEGER))", (Type)VarcharType.VARCHAR, "integer");
        this.assertFunction("typeof(CAST(1 AS VARCHAR))", (Type)VarcharType.VARCHAR, "varchar");
        this.assertFunction("typeof(CAST(1 AS DOUBLE))", (Type)VarcharType.VARCHAR, "double");
        this.assertFunction("typeof(123)", (Type)VarcharType.VARCHAR, "integer");
        this.assertFunction("typeof('cat')", (Type)VarcharType.VARCHAR, "varchar(3)");
        this.assertFunction("typeof(NULL)", (Type)VarcharType.VARCHAR, "unknown");
    }

    @Test
    public void testParametricType() {
        this.assertFunction("typeof(CAST(NULL AS VARCHAR(10)))", (Type)VarcharType.VARCHAR, "varchar(10)");
        this.assertFunction("typeof(CAST(NULL AS DECIMAL(5,1)))", (Type)VarcharType.VARCHAR, "decimal(5,1)");
        this.assertFunction("typeof(CAST(NULL AS DECIMAL(1)))", (Type)VarcharType.VARCHAR, "decimal(1,0)");
        this.assertFunction("typeof(CAST(NULL AS DECIMAL))", (Type)VarcharType.VARCHAR, "decimal(38,0)");
        this.assertFunction("typeof(CAST(NULL AS ARRAY(INTEGER)))", (Type)VarcharType.VARCHAR, "array(integer)");
        this.assertFunction("typeof(CAST(NULL AS ARRAY(DECIMAL(5,1))))", (Type)VarcharType.VARCHAR, "array(decimal(5,1))");
    }

    @Test
    public void testNestedType() {
        this.assertFunction("typeof(CAST(NULL AS ARRAY(ARRAY(ARRAY(INTEGER)))))", (Type)VarcharType.VARCHAR, "array(array(array(integer)))");
        this.assertFunction("typeof(CAST(NULL AS ARRAY(ARRAY(ARRAY(DECIMAL(5,1))))))", (Type)VarcharType.VARCHAR, "array(array(array(decimal(5,1))))");
    }

    @Test
    public void testComplex() {
        this.assertFunction("typeof(CONCAT('ala','ma','kota'))", (Type)VarcharType.VARCHAR, "varchar");
        this.assertFunction("typeof(CONCAT(CONCAT('ala','ma','kota'), 'baz'))", (Type)VarcharType.VARCHAR, "varchar");
        this.assertFunction("typeof(ARRAY [CAST(1 AS INTEGER),CAST(2 AS INTEGER),CAST(3 AS INTEGER)])", (Type)VarcharType.VARCHAR, "array(integer)");
        this.assertFunction("typeof(sin(2))", (Type)VarcharType.VARCHAR, "double");
        this.assertFunction("typeof(2+sin(2)+2.3)", (Type)VarcharType.VARCHAR, "double");
    }
}

