/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.timestamp;

import io.trino.Session;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.TestingSession;
import org.assertj.core.api.Assertions;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestOperators {
    private QueryAssertions assertions;

    @BeforeClass
    public void init() {
        Session session = TestingSession.testSessionBuilder().setTimeZoneKey(TestingSession.DEFAULT_TIME_ZONE_KEY).build();
        this.assertions = new QueryAssertions(session);
    }

    @AfterClass(alwaysRun=true)
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testEqual() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56' = TIMESTAMP '2020-05-01 12:34:56'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1' = TIMESTAMP '2020-05-01 12:34:56.1'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12' = TIMESTAMP '2020-05-01 12:34:56.12'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123' = TIMESTAMP '2020-05-01 12:34:56.123'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234' = TIMESTAMP '2020-05-01 12:34:56.1234'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345' = TIMESTAMP '2020-05-01 12:34:56.12345'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456' = TIMESTAMP '2020-05-01 12:34:56.123456'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567' = TIMESTAMP '2020-05-01 12:34:56.1234567'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678' = TIMESTAMP '2020-05-01 12:34:56.12345678'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789' = TIMESTAMP '2020-05-01 12:34:56.123456789'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567890' = TIMESTAMP '2020-05-01 12:34:56.1234567890'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678901' = TIMESTAMP '2020-05-01 12:34:56.12345678901'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789012' = TIMESTAMP '2020-05-01 12:34:56.123456789012'")))).isEqualTo(true);
    }

    @Test
    public void testNotEqual() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56' <> TIMESTAMP '2020-05-01 12:34:56'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1' <> TIMESTAMP '2020-05-01 12:34:56.1'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12' <> TIMESTAMP '2020-05-01 12:34:56.12'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123' <> TIMESTAMP '2020-05-01 12:34:56.123'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234' <> TIMESTAMP '2020-05-01 12:34:56.1234'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345' <> TIMESTAMP '2020-05-01 12:34:56.12345'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456' <> TIMESTAMP '2020-05-01 12:34:56.123456'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567' <> TIMESTAMP '2020-05-01 12:34:56.1234567'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678' <> TIMESTAMP '2020-05-01 12:34:56.12345678'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789' <> TIMESTAMP '2020-05-01 12:34:56.123456789'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567890' <> TIMESTAMP '2020-05-01 12:34:56.1234567890'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678901' <> TIMESTAMP '2020-05-01 12:34:56.12345678901'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789012' <> TIMESTAMP '2020-05-01 12:34:56.123456789012'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56' <> TIMESTAMP '2021-05-01 12:34:56'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1' <> TIMESTAMP '2021-05-01 12:34:56.1'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12' <> TIMESTAMP '2021-05-01 12:34:56.12'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123' <> TIMESTAMP '2021-05-01 12:34:56.123'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234' <> TIMESTAMP '2021-05-01 12:34:56.1234'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345' <> TIMESTAMP '2021-05-01 12:34:56.12345'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456' <> TIMESTAMP '2021-05-01 12:34:56.123456'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567' <> TIMESTAMP '2021-05-01 12:34:56.1234567'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678' <> TIMESTAMP '2021-05-01 12:34:56.12345678'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789' <> TIMESTAMP '2021-05-01 12:34:56.123456789'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567890' <> TIMESTAMP '2021-05-01 12:34:56.1234567890'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678901' <> TIMESTAMP '2021-05-01 12:34:56.12345678901'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789012' <> TIMESTAMP '2021-05-01 12:34:56.123456789012'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56' <> TIMESTAMP '2020-05-01 12:34:57'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1' <> TIMESTAMP '2020-05-01 12:34:56.2'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12' <> TIMESTAMP '2020-05-01 12:34:56.13'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123' <> TIMESTAMP '2020-05-01 12:34:56.124'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234' <> TIMESTAMP '2020-05-01 12:34:56.1235'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345' <> TIMESTAMP '2020-05-01 12:34:56.12346'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456' <> TIMESTAMP '2020-05-01 12:34:56.123457'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567' <> TIMESTAMP '2020-05-01 12:34:56.1234568'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678' <> TIMESTAMP '2020-05-01 12:34:56.12345679'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789' <> TIMESTAMP '2020-05-01 12:34:56.123456781'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567890' <> TIMESTAMP '2020-05-01 12:34:56.1234567891'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678901' <> TIMESTAMP '2020-05-01 12:34:56.12345678902'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789012' <> TIMESTAMP '2020-05-01 12:34:56.123456789013'")))).isEqualTo(true);
    }

    @Test
    public void testDistinctFrom() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56' IS DISTINCT FROM TIMESTAMP '2020-05-01 12:34:56'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1' IS DISTINCT FROM TIMESTAMP '2020-05-01 12:34:56.1'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12' IS DISTINCT FROM TIMESTAMP '2020-05-01 12:34:56.12'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123' IS DISTINCT FROM TIMESTAMP '2020-05-01 12:34:56.123'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234' IS DISTINCT FROM TIMESTAMP '2020-05-01 12:34:56.1234'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345' IS DISTINCT FROM TIMESTAMP '2020-05-01 12:34:56.12345'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456' IS DISTINCT FROM TIMESTAMP '2020-05-01 12:34:56.123456'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567' IS DISTINCT FROM TIMESTAMP '2020-05-01 12:34:56.1234567'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678' IS DISTINCT FROM TIMESTAMP '2020-05-01 12:34:56.12345678'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789' IS DISTINCT FROM TIMESTAMP '2020-05-01 12:34:56.123456789'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567890' IS DISTINCT FROM TIMESTAMP '2020-05-01 12:34:56.1234567890'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678901' IS DISTINCT FROM TIMESTAMP '2020-05-01 12:34:56.12345678901'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789012' IS DISTINCT FROM TIMESTAMP '2020-05-01 12:34:56.123456789012'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56' IS DISTINCT FROM TIMESTAMP '2020-05-01 12:34:55'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1' IS DISTINCT FROM TIMESTAMP '2020-05-01 12:34:56.0'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12' IS DISTINCT FROM TIMESTAMP '2020-05-01 12:34:56.11'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123' IS DISTINCT FROM TIMESTAMP '2020-05-01 12:34:56.122'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234' IS DISTINCT FROM TIMESTAMP '2020-05-01 12:34:56.1233'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345' IS DISTINCT FROM TIMESTAMP '2020-05-01 12:34:56.12344'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456' IS DISTINCT FROM TIMESTAMP '2020-05-01 12:34:56.123455'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567' IS DISTINCT FROM TIMESTAMP '2020-05-01 12:34:56.1234566'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678' IS DISTINCT FROM TIMESTAMP '2020-05-01 12:34:56.12345677'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789' IS DISTINCT FROM TIMESTAMP '2020-05-01 12:34:56.123456788'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567890' IS DISTINCT FROM TIMESTAMP '2020-05-01 12:34:56.1234567899'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678901' IS DISTINCT FROM TIMESTAMP '2020-05-01 12:34:56.12345678900'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789012' IS DISTINCT FROM TIMESTAMP '2020-05-01 12:34:56.123456789011'")))).isEqualTo(true);
    }

    @Test
    public void testLessThan() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56' < TIMESTAMP '2020-05-01 12:34:57'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1' < TIMESTAMP '2020-05-01 12:34:56.2'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12' < TIMESTAMP '2020-05-01 12:34:56.13'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123' < TIMESTAMP '2020-05-01 12:34:56.124'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234' < TIMESTAMP '2020-05-01 12:34:56.1235'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345' < TIMESTAMP '2020-05-01 12:34:56.12346'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456' < TIMESTAMP '2020-05-01 12:34:56.123457'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567' < TIMESTAMP '2020-05-01 12:34:56.1234568'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678' < TIMESTAMP '2020-05-01 12:34:56.12345679'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789' < TIMESTAMP '2020-05-01 12:34:56.123456790'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567890' < TIMESTAMP '2020-05-01 12:34:56.1234567891'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678901' < TIMESTAMP '2020-05-01 12:34:56.12345678902'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789012' < TIMESTAMP '2020-05-01 12:34:56.123456789013'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56' < TIMESTAMP '2020-05-01 12:34:56'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1' < TIMESTAMP '2020-05-01 12:34:56.1'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12' < TIMESTAMP '2020-05-01 12:34:56.12'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123' < TIMESTAMP '2020-05-01 12:34:56.123'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234' < TIMESTAMP '2020-05-01 12:34:56.1234'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345' < TIMESTAMP '2020-05-01 12:34:56.12345'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456' < TIMESTAMP '2020-05-01 12:34:56.123456'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567' < TIMESTAMP '2020-05-01 12:34:56.1234567'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678' < TIMESTAMP '2020-05-01 12:34:56.12345678'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789' < TIMESTAMP '2020-05-01 12:34:56.123456789'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567890' < TIMESTAMP '2020-05-01 12:34:56.1234567890'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678901' < TIMESTAMP '2020-05-01 12:34:56.12345678901'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789012' < TIMESTAMP '2020-05-01 12:34:56.123456789012'")))).isEqualTo(false);
    }

    @Test
    public void testGreaterThan() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56' > TIMESTAMP '2020-05-01 12:34:55'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1' > TIMESTAMP '2020-05-01 12:34:55.9'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12' > TIMESTAMP '2020-05-01 12:34:56.11'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123' > TIMESTAMP '2020-05-01 12:34:56.122'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234' > TIMESTAMP '2020-05-01 12:34:56.1233'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345' > TIMESTAMP '2020-05-01 12:34:56.12344'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456' > TIMESTAMP '2020-05-01 12:34:56.123455'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567' > TIMESTAMP '2020-05-01 12:34:56.1234566'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678' > TIMESTAMP '2020-05-01 12:34:56.12345677'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789' > TIMESTAMP '2020-05-01 12:34:56.123456788'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567890' > TIMESTAMP '2020-05-01 12:34:56.1234567889'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678901' > TIMESTAMP '2020-05-01 12:34:56.12345678899'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789012' > TIMESTAMP '2020-05-01 12:34:56.123456789011'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56' > TIMESTAMP '2020-05-01 12:34:56'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1' > TIMESTAMP '2020-05-01 12:34:56.1'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12' > TIMESTAMP '2020-05-01 12:34:56.12'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123' > TIMESTAMP '2020-05-01 12:34:56.123'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234' > TIMESTAMP '2020-05-01 12:34:56.1234'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345' > TIMESTAMP '2020-05-01 12:34:56.12345'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456' > TIMESTAMP '2020-05-01 12:34:56.123456'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567' > TIMESTAMP '2020-05-01 12:34:56.1234567'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678' > TIMESTAMP '2020-05-01 12:34:56.12345678'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789' > TIMESTAMP '2020-05-01 12:34:56.123456789'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567890' > TIMESTAMP '2020-05-01 12:34:56.1234567890'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678901' > TIMESTAMP '2020-05-01 12:34:56.12345678901'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789012' > TIMESTAMP '2020-05-01 12:34:56.123456789012'")))).isEqualTo(false);
    }

    @Test
    public void testLessThanOrEquals() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56' <= TIMESTAMP '2020-05-01 12:34:56'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1' <= TIMESTAMP '2020-05-01 12:34:56.1'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12' <= TIMESTAMP '2020-05-01 12:34:56.12'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123' <= TIMESTAMP '2020-05-01 12:34:56.123'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234' <= TIMESTAMP '2020-05-01 12:34:56.1234'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345' <= TIMESTAMP '2020-05-01 12:34:56.12345'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456' <= TIMESTAMP '2020-05-01 12:34:56.123456'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567' <= TIMESTAMP '2020-05-01 12:34:56.1234567'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678' <= TIMESTAMP '2020-05-01 12:34:56.12345678'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789' <= TIMESTAMP '2020-05-01 12:34:56.123456789'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567890' <= TIMESTAMP '2020-05-01 12:34:56.1234567890'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678901' <= TIMESTAMP '2020-05-01 12:34:56.12345678901'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789012' <= TIMESTAMP '2020-05-01 12:34:56.123456789012'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56' <= TIMESTAMP '2020-05-01 12:34:57'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1' <= TIMESTAMP '2020-05-01 12:34:56.2'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12' <= TIMESTAMP '2020-05-01 12:34:56.13'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123' <= TIMESTAMP '2020-05-01 12:34:56.124'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234' <= TIMESTAMP '2020-05-01 12:34:56.1235'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345' <= TIMESTAMP '2020-05-01 12:34:56.12346'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456' <= TIMESTAMP '2020-05-01 12:34:56.123457'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567' <= TIMESTAMP '2020-05-01 12:34:56.1234568'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678' <= TIMESTAMP '2020-05-01 12:34:56.12345679'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789' <= TIMESTAMP '2020-05-01 12:34:56.123456790'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567890' <= TIMESTAMP '2020-05-01 12:34:56.1234567891'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678901' <= TIMESTAMP '2020-05-01 12:34:56.12345678902'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789012' <= TIMESTAMP '2020-05-01 12:34:56.123456789013'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56' <= TIMESTAMP '2020-05-01 12:34:55'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1' <= TIMESTAMP '2020-05-01 12:34:56.0'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12' <= TIMESTAMP '2020-05-01 12:34:56.11'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123' <= TIMESTAMP '2020-05-01 12:34:56.122'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234' <= TIMESTAMP '2020-05-01 12:34:56.1233'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345' <= TIMESTAMP '2020-05-01 12:34:56.12344'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456' <= TIMESTAMP '2020-05-01 12:34:56.123454'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567' <= TIMESTAMP '2020-05-01 12:34:56.1234566'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678' <= TIMESTAMP '2020-05-01 12:34:56.12345677'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789' <= TIMESTAMP '2020-05-01 12:34:56.123456788'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567890' <= TIMESTAMP '2020-05-01 12:34:56.1234567889'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678901' <= TIMESTAMP '2020-05-01 12:34:56.12345678900'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789012' <= TIMESTAMP '2020-05-01 12:34:56.123456789011'")))).isEqualTo(false);
    }

    @Test
    public void testGreaterThanOrEquals() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56' >= TIMESTAMP '2020-05-01 12:34:56'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1' >= TIMESTAMP '2020-05-01 12:34:56.1'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12' >= TIMESTAMP '2020-05-01 12:34:56.12'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123' >= TIMESTAMP '2020-05-01 12:34:56.123'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234' >= TIMESTAMP '2020-05-01 12:34:56.1234'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345' >= TIMESTAMP '2020-05-01 12:34:56.12345'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456' >= TIMESTAMP '2020-05-01 12:34:56.123456'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567' >= TIMESTAMP '2020-05-01 12:34:56.1234567'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678' >= TIMESTAMP '2020-05-01 12:34:56.12345678'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789' >= TIMESTAMP '2020-05-01 12:34:56.123456789'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567890' >= TIMESTAMP '2020-05-01 12:34:56.1234567890'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678901' >= TIMESTAMP '2020-05-01 12:34:56.12345678901'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789012' >= TIMESTAMP '2020-05-01 12:34:56.123456789012'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56' >= TIMESTAMP '2020-05-01 12:34:55'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1' >= TIMESTAMP '2020-05-01 12:34:55.9'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12' >= TIMESTAMP '2020-05-01 12:34:56.11'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123' >= TIMESTAMP '2020-05-01 12:34:56.122'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234' >= TIMESTAMP '2020-05-01 12:34:56.1233'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345' >= TIMESTAMP '2020-05-01 12:34:56.12344'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456' >= TIMESTAMP '2020-05-01 12:34:56.123455'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567' >= TIMESTAMP '2020-05-01 12:34:56.1234566'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678' >= TIMESTAMP '2020-05-01 12:34:56.12345677'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789' >= TIMESTAMP '2020-05-01 12:34:56.123456788'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567890' >= TIMESTAMP '2020-05-01 12:34:56.1234567889'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678901' >= TIMESTAMP '2020-05-01 12:34:56.12345678899'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789012' >= TIMESTAMP '2020-05-01 12:34:56.123456789011'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56' >= TIMESTAMP '2020-05-01 12:34:57'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1' >= TIMESTAMP '2020-05-01 12:34:56.2'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12' >= TIMESTAMP '2020-05-01 12:34:56.13'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123' >= TIMESTAMP '2020-05-01 12:34:56.124'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234' >= TIMESTAMP '2020-05-01 12:34:56.1235'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345' >= TIMESTAMP '2020-05-01 12:34:56.12346'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456' >= TIMESTAMP '2020-05-01 12:34:56.123457'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567' >= TIMESTAMP '2020-05-01 12:34:56.1234568'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678' >= TIMESTAMP '2020-05-01 12:34:56.12345679'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789' >= TIMESTAMP '2020-05-01 12:34:56.1234567891'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567890' >= TIMESTAMP '2020-05-01 12:34:56.1234567891'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678901' >= TIMESTAMP '2020-05-01 12:34:56.12345678902'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789012' >= TIMESTAMP '2020-05-01 12:34:56.123456789013'")))).isEqualTo(false);
    }

    @Test
    public void testBetween() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56' BETWEEN TIMESTAMP '2020-05-01 12:34:55' and TIMESTAMP '2020-05-01 12:34:57'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1' BETWEEN TIMESTAMP '2020-05-01 12:34:56.0' and TIMESTAMP '2020-05-01 12:34:56.2'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12' BETWEEN TIMESTAMP '2020-05-01 12:34:56.11' and TIMESTAMP '2020-05-01 12:34:56.13'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123' BETWEEN TIMESTAMP '2020-05-01 12:34:56.122' and TIMESTAMP '2020-05-01 12:34:56.124'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234' BETWEEN TIMESTAMP '2020-05-01 12:34:56.1233' and TIMESTAMP '2020-05-01 12:34:56.1235'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345' BETWEEN TIMESTAMP '2020-05-01 12:34:56.12344' and TIMESTAMP '2020-05-01 12:34:56.12346'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456' BETWEEN TIMESTAMP '2020-05-01 12:34:56.123455' and TIMESTAMP '2020-05-01 12:34:56.123457'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567' BETWEEN TIMESTAMP '2020-05-01 12:34:56.1234566' and TIMESTAMP '2020-05-01 12:34:56.1234568'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678' BETWEEN TIMESTAMP '2020-05-01 12:34:56.12345677' and TIMESTAMP '2020-05-01 12:34:56.12345679'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789' BETWEEN TIMESTAMP '2020-05-01 12:34:56.123456788' and TIMESTAMP '2020-05-01 12:34:56.123456790'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567890' BETWEEN TIMESTAMP '2020-05-01 12:34:56.1234567889' and TIMESTAMP '2020-05-01 12:34:56.1234567891'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678901' BETWEEN TIMESTAMP '2020-05-01 12:34:56.1234567890' and TIMESTAMP '2020-05-01 12:34:56.12345678902'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789012' BETWEEN TIMESTAMP '2020-05-01 12:34:56.123456789011' and TIMESTAMP '2020-05-01 12:34:56.123456789013'")))).isEqualTo(true);
    }

    @Test
    public void testAddIntervalDayToSecond() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56' + INTERVAL '1.123' SECOND")))).matches("TIMESTAMP '2020-05-01 12:34:57.123'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1' + INTERVAL '1.123' SECOND")))).matches("TIMESTAMP '2020-05-01 12:34:57.223'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12' + INTERVAL '1.123' SECOND")))).matches("TIMESTAMP '2020-05-01 12:34:57.243'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123' + INTERVAL '1.123' SECOND")))).matches("TIMESTAMP '2020-05-01 12:34:57.246'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234' + INTERVAL '1.123' SECOND")))).matches("TIMESTAMP '2020-05-01 12:34:57.2464'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345' + INTERVAL '1.123' SECOND")))).matches("TIMESTAMP '2020-05-01 12:34:57.24645'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456' + INTERVAL '1.123' SECOND")))).matches("TIMESTAMP '2020-05-01 12:34:57.246456'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567' + INTERVAL '1.123' SECOND")))).matches("TIMESTAMP '2020-05-01 12:34:57.2464567'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678' + INTERVAL '1.123' SECOND")))).matches("TIMESTAMP '2020-05-01 12:34:57.24645678'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789' + INTERVAL '1.123' SECOND")))).matches("TIMESTAMP '2020-05-01 12:34:57.246456789'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567890' + INTERVAL '1.123' SECOND")))).matches("TIMESTAMP '2020-05-01 12:34:57.2464567890'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678901' + INTERVAL '1.123' SECOND")))).matches("TIMESTAMP '2020-05-01 12:34:57.24645678901'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789012' + INTERVAL '1.123' SECOND")))).matches("TIMESTAMP '2020-05-01 12:34:57.246456789012'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1.123' SECOND + TIMESTAMP '2020-05-01 12:34:56'")))).matches("TIMESTAMP '2020-05-01 12:34:57.123'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1.123' SECOND + TIMESTAMP '2020-05-01 12:34:56.1'")))).matches("TIMESTAMP '2020-05-01 12:34:57.223'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1.123' SECOND + TIMESTAMP '2020-05-01 12:34:56.12'")))).matches("TIMESTAMP '2020-05-01 12:34:57.243'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1.123' SECOND + TIMESTAMP '2020-05-01 12:34:56.123'")))).matches("TIMESTAMP '2020-05-01 12:34:57.246'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1.123' SECOND + TIMESTAMP '2020-05-01 12:34:56.1234'")))).matches("TIMESTAMP '2020-05-01 12:34:57.2464'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1.123' SECOND + TIMESTAMP '2020-05-01 12:34:56.12345'")))).matches("TIMESTAMP '2020-05-01 12:34:57.24645'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1.123' SECOND + TIMESTAMP '2020-05-01 12:34:56.123456'")))).matches("TIMESTAMP '2020-05-01 12:34:57.246456'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1.123' SECOND + TIMESTAMP '2020-05-01 12:34:56.1234567'")))).matches("TIMESTAMP '2020-05-01 12:34:57.2464567'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1.123' SECOND + TIMESTAMP '2020-05-01 12:34:56.12345678'")))).matches("TIMESTAMP '2020-05-01 12:34:57.24645678'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1.123' SECOND + TIMESTAMP '2020-05-01 12:34:56.123456789'")))).matches("TIMESTAMP '2020-05-01 12:34:57.246456789'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1.123' SECOND + TIMESTAMP '2020-05-01 12:34:56.1234567890'")))).matches("TIMESTAMP '2020-05-01 12:34:57.2464567890'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1.123' SECOND + TIMESTAMP '2020-05-01 12:34:56.12345678901'")))).matches("TIMESTAMP '2020-05-01 12:34:57.24645678901'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1.123' SECOND + TIMESTAMP '2020-05-01 12:34:56.123456789012'")))).matches("TIMESTAMP '2020-05-01 12:34:57.246456789012'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56' + INTERVAL '1' DAY")))).matches("TIMESTAMP '2020-05-02 12:34:56.000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1' + INTERVAL '1' DAY")))).matches("TIMESTAMP '2020-05-02 12:34:56.100'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12' + INTERVAL '1' DAY")))).matches("TIMESTAMP '2020-05-02 12:34:56.120'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123' + INTERVAL '1' DAY")))).matches("TIMESTAMP '2020-05-02 12:34:56.123'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234' + INTERVAL '1' DAY")))).matches("TIMESTAMP '2020-05-02 12:34:56.1234'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345' + INTERVAL '1' DAY")))).matches("TIMESTAMP '2020-05-02 12:34:56.12345'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456' + INTERVAL '1' DAY")))).matches("TIMESTAMP '2020-05-02 12:34:56.123456'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567' + INTERVAL '1' DAY")))).matches("TIMESTAMP '2020-05-02 12:34:56.1234567'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678' + INTERVAL '1' DAY")))).matches("TIMESTAMP '2020-05-02 12:34:56.12345678'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789' + INTERVAL '1' DAY")))).matches("TIMESTAMP '2020-05-02 12:34:56.123456789'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567890' + INTERVAL '1' DAY")))).matches("TIMESTAMP '2020-05-02 12:34:56.1234567890'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678901' + INTERVAL '1' DAY")))).matches("TIMESTAMP '2020-05-02 12:34:56.12345678901'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789012' + INTERVAL '1' DAY")))).matches("TIMESTAMP '2020-05-02 12:34:56.123456789012'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1' DAY + TIMESTAMP '2020-05-01 12:34:56'")))).matches("TIMESTAMP '2020-05-02 12:34:56.000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1' DAY + TIMESTAMP '2020-05-01 12:34:56.1'")))).matches("TIMESTAMP '2020-05-02 12:34:56.100'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1' DAY + TIMESTAMP '2020-05-01 12:34:56.12'")))).matches("TIMESTAMP '2020-05-02 12:34:56.120'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1' DAY + TIMESTAMP '2020-05-01 12:34:56.123'")))).matches("TIMESTAMP '2020-05-02 12:34:56.123'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1' DAY + TIMESTAMP '2020-05-01 12:34:56.1234'")))).matches("TIMESTAMP '2020-05-02 12:34:56.1234'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1' DAY + TIMESTAMP '2020-05-01 12:34:56.12345'")))).matches("TIMESTAMP '2020-05-02 12:34:56.12345'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1' DAY + TIMESTAMP '2020-05-01 12:34:56.123456'")))).matches("TIMESTAMP '2020-05-02 12:34:56.123456'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1' DAY + TIMESTAMP '2020-05-01 12:34:56.1234567'")))).matches("TIMESTAMP '2020-05-02 12:34:56.1234567'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1' DAY + TIMESTAMP '2020-05-01 12:34:56.12345678'")))).matches("TIMESTAMP '2020-05-02 12:34:56.12345678'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1' DAY + TIMESTAMP '2020-05-01 12:34:56.123456789'")))).matches("TIMESTAMP '2020-05-02 12:34:56.123456789'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1' DAY + TIMESTAMP '2020-05-01 12:34:56.1234567890'")))).matches("TIMESTAMP '2020-05-02 12:34:56.1234567890'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1' DAY + TIMESTAMP '2020-05-01 12:34:56.12345678901'")))).matches("TIMESTAMP '2020-05-02 12:34:56.12345678901'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1' DAY + TIMESTAMP '2020-05-01 12:34:56.123456789012'")))).matches("TIMESTAMP '2020-05-02 12:34:56.123456789012'");
    }

    @Test
    public void testSubtractIntervalDayToSecond() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56' - INTERVAL '1.123' SECOND")))).matches("TIMESTAMP '2020-05-01 12:34:54.877'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1' - INTERVAL '1.123' SECOND")))).matches("TIMESTAMP '2020-05-01 12:34:54.977'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12' - INTERVAL '1.123' SECOND")))).matches("TIMESTAMP '2020-05-01 12:34:54.997'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123' - INTERVAL '1.123' SECOND")))).matches("TIMESTAMP '2020-05-01 12:34:55.000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234' - INTERVAL '1.123' SECOND")))).matches("TIMESTAMP '2020-05-01 12:34:55.0004'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345' - INTERVAL '1.123' SECOND")))).matches("TIMESTAMP '2020-05-01 12:34:55.00045'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456' - INTERVAL '1.123' SECOND")))).matches("TIMESTAMP '2020-05-01 12:34:55.000456'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567' - INTERVAL '1.123' SECOND")))).matches("TIMESTAMP '2020-05-01 12:34:55.0004567'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678' - INTERVAL '1.123' SECOND")))).matches("TIMESTAMP '2020-05-01 12:34:55.00045678'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789' - INTERVAL '1.123' SECOND")))).matches("TIMESTAMP '2020-05-01 12:34:55.000456789'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567890' - INTERVAL '1.123' SECOND")))).matches("TIMESTAMP '2020-05-01 12:34:55.0004567890'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678901' - INTERVAL '1.123' SECOND")))).matches("TIMESTAMP '2020-05-01 12:34:55.00045678901'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789012' - INTERVAL '1.123' SECOND")))).matches("TIMESTAMP '2020-05-01 12:34:55.000456789012'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56' - INTERVAL '1' DAY")))).matches("TIMESTAMP '2020-04-30 12:34:56.000'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1' - INTERVAL '1' DAY")))).matches("TIMESTAMP '2020-04-30 12:34:56.100'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12' - INTERVAL '1' DAY")))).matches("TIMESTAMP '2020-04-30 12:34:56.120'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123' - INTERVAL '1' DAY")))).matches("TIMESTAMP '2020-04-30 12:34:56.123'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234' - INTERVAL '1' DAY")))).matches("TIMESTAMP '2020-04-30 12:34:56.1234'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345' - INTERVAL '1' DAY")))).matches("TIMESTAMP '2020-04-30 12:34:56.12345'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456' - INTERVAL '1' DAY")))).matches("TIMESTAMP '2020-04-30 12:34:56.123456'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567' - INTERVAL '1' DAY")))).matches("TIMESTAMP '2020-04-30 12:34:56.1234567'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678' - INTERVAL '1' DAY")))).matches("TIMESTAMP '2020-04-30 12:34:56.12345678'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789' - INTERVAL '1' DAY")))).matches("TIMESTAMP '2020-04-30 12:34:56.123456789'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567890' - INTERVAL '1' DAY")))).matches("TIMESTAMP '2020-04-30 12:34:56.1234567890'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678901' - INTERVAL '1' DAY")))).matches("TIMESTAMP '2020-04-30 12:34:56.12345678901'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789012' - INTERVAL '1' DAY")))).matches("TIMESTAMP '2020-04-30 12:34:56.123456789012'");
    }

    @Test
    public void testAddIntervalYearToMonth() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56' + INTERVAL '1' MONTH")))).matches("TIMESTAMP '2020-06-01 12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1' + INTERVAL '1' MONTH")))).matches("TIMESTAMP '2020-06-01 12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12' + INTERVAL '1' MONTH")))).matches("TIMESTAMP '2020-06-01 12:34:56.12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123' + INTERVAL '1' MONTH")))).matches("TIMESTAMP '2020-06-01 12:34:56.123'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234' + INTERVAL '1' MONTH")))).matches("TIMESTAMP '2020-06-01 12:34:56.1234'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345' + INTERVAL '1' MONTH")))).matches("TIMESTAMP '2020-06-01 12:34:56.12345'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456' + INTERVAL '1' MONTH")))).matches("TIMESTAMP '2020-06-01 12:34:56.123456'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567' + INTERVAL '1' MONTH")))).matches("TIMESTAMP '2020-06-01 12:34:56.1234567'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678' + INTERVAL '1' MONTH")))).matches("TIMESTAMP '2020-06-01 12:34:56.12345678'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789' + INTERVAL '1' MONTH")))).matches("TIMESTAMP '2020-06-01 12:34:56.123456789'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567890' + INTERVAL '1' MONTH")))).matches("TIMESTAMP '2020-06-01 12:34:56.1234567890'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678901' + INTERVAL '1' MONTH")))).matches("TIMESTAMP '2020-06-01 12:34:56.12345678901'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789012' + INTERVAL '1' MONTH")))).matches("TIMESTAMP '2020-06-01 12:34:56.123456789012'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1' MONTH + TIMESTAMP '2020-05-01 12:34:56'")))).matches("TIMESTAMP '2020-06-01 12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1' MONTH + TIMESTAMP '2020-05-01 12:34:56.1'")))).matches("TIMESTAMP '2020-06-01 12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1' MONTH + TIMESTAMP '2020-05-01 12:34:56.12'")))).matches("TIMESTAMP '2020-06-01 12:34:56.12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1' MONTH + TIMESTAMP '2020-05-01 12:34:56.123'")))).matches("TIMESTAMP '2020-06-01 12:34:56.123'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1' MONTH + TIMESTAMP '2020-05-01 12:34:56.1234'")))).matches("TIMESTAMP '2020-06-01 12:34:56.1234'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1' MONTH + TIMESTAMP '2020-05-01 12:34:56.12345'")))).matches("TIMESTAMP '2020-06-01 12:34:56.12345'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1' MONTH + TIMESTAMP '2020-05-01 12:34:56.123456'")))).matches("TIMESTAMP '2020-06-01 12:34:56.123456'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1' MONTH + TIMESTAMP '2020-05-01 12:34:56.1234567'")))).matches("TIMESTAMP '2020-06-01 12:34:56.1234567'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1' MONTH + TIMESTAMP '2020-05-01 12:34:56.12345678'")))).matches("TIMESTAMP '2020-06-01 12:34:56.12345678'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1' MONTH + TIMESTAMP '2020-05-01 12:34:56.123456789'")))).matches("TIMESTAMP '2020-06-01 12:34:56.123456789'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1' MONTH + TIMESTAMP '2020-05-01 12:34:56.1234567890'")))).matches("TIMESTAMP '2020-06-01 12:34:56.1234567890'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1' MONTH + TIMESTAMP '2020-05-01 12:34:56.12345678901'")))).matches("TIMESTAMP '2020-06-01 12:34:56.12345678901'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("INTERVAL '1' MONTH + TIMESTAMP '2020-05-01 12:34:56.123456789012'")))).matches("TIMESTAMP '2020-06-01 12:34:56.123456789012'");
    }

    @Test
    public void testSubtractIntervalYearToMonth() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56' - INTERVAL '1' MONTH")))).matches("TIMESTAMP '2020-04-01 12:34:56'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1' - INTERVAL '1' MONTH")))).matches("TIMESTAMP '2020-04-01 12:34:56.1'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12' - INTERVAL '1' MONTH")))).matches("TIMESTAMP '2020-04-01 12:34:56.12'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123' - INTERVAL '1' MONTH")))).matches("TIMESTAMP '2020-04-01 12:34:56.123'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234' - INTERVAL '1' MONTH")))).matches("TIMESTAMP '2020-04-01 12:34:56.1234'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345' - INTERVAL '1' MONTH")))).matches("TIMESTAMP '2020-04-01 12:34:56.12345'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456' - INTERVAL '1' MONTH")))).matches("TIMESTAMP '2020-04-01 12:34:56.123456'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567' - INTERVAL '1' MONTH")))).matches("TIMESTAMP '2020-04-01 12:34:56.1234567'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678' - INTERVAL '1' MONTH")))).matches("TIMESTAMP '2020-04-01 12:34:56.12345678'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789' - INTERVAL '1' MONTH")))).matches("TIMESTAMP '2020-04-01 12:34:56.123456789'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.1234567890' - INTERVAL '1' MONTH")))).matches("TIMESTAMP '2020-04-01 12:34:56.1234567890'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.12345678901' - INTERVAL '1' MONTH")))).matches("TIMESTAMP '2020-04-01 12:34:56.12345678901'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.123456789012' - INTERVAL '1' MONTH")))).matches("TIMESTAMP '2020-04-01 12:34:56.123456789012'");
    }

    @Test
    public void testSubtract() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56' - TIMESTAMP '2020-05-01 12:34:55'")))).matches("INTERVAL '1' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.2' - TIMESTAMP '2020-05-01 12:34:55.1'")))).matches("INTERVAL '1.1' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.22' - TIMESTAMP '2020-05-01 12:34:55.11'")))).matches("INTERVAL '1.11' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.222' - TIMESTAMP '2020-05-01 12:34:55.111'")))).matches("INTERVAL '1.111' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.2222' - TIMESTAMP '2020-05-01 12:34:55.1111'")))).matches("INTERVAL '1.111' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.22222' - TIMESTAMP '2020-05-01 12:34:55.11111'")))).matches("INTERVAL '1.111' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.222222' - TIMESTAMP '2020-05-01 12:34:55.111111'")))).matches("INTERVAL '1.111' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.2222222' - TIMESTAMP '2020-05-01 12:34:55.1111111'")))).matches("INTERVAL '1.111' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.22222222' - TIMESTAMP '2020-05-01 12:34:55.11111111'")))).matches("INTERVAL '1.111' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.222222222' - TIMESTAMP '2020-05-01 12:34:55.111111111'")))).matches("INTERVAL '1.111' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.2222222222' - TIMESTAMP '2020-05-01 12:34:55.1111111111'")))).matches("INTERVAL '1.111' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.22222222222' - TIMESTAMP '2020-05-01 12:34:55.11111111111'")))).matches("INTERVAL '1.111' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.222222222222' - TIMESTAMP '2020-05-01 12:34:55.111111111111'")))).matches("INTERVAL '1.111' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.9' - TIMESTAMP '2020-05-01 12:34:55.1'")))).matches("INTERVAL '1.8' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.99' - TIMESTAMP '2020-05-01 12:34:55.11'")))).matches("INTERVAL '1.88' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.999' - TIMESTAMP '2020-05-01 12:34:55.111'")))).matches("INTERVAL '1.888' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.9999' - TIMESTAMP '2020-05-01 12:34:55.1111'")))).matches("INTERVAL '1.889' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.99999' - TIMESTAMP '2020-05-01 12:34:55.11111'")))).matches("INTERVAL '1.889' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.999999' - TIMESTAMP '2020-05-01 12:34:55.111111'")))).matches("INTERVAL '1.889' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.9999999' - TIMESTAMP '2020-05-01 12:34:55.1111111'")))).matches("INTERVAL '1.889' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.99999999' - TIMESTAMP '2020-05-01 12:34:55.11111111'")))).matches("INTERVAL '1.889' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.999999999' - TIMESTAMP '2020-05-01 12:34:55.111111111'")))).matches("INTERVAL '1.889' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.9999999999' - TIMESTAMP '2020-05-01 12:34:55.1111111111'")))).matches("INTERVAL '1.889' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.99999999999' - TIMESTAMP '2020-05-01 12:34:55.11111111111'")))).matches("INTERVAL '1.889' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:56.999999999999' - TIMESTAMP '2020-05-01 12:34:55.111111111111'")))).matches("INTERVAL '1.889' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:55' - TIMESTAMP '2020-05-01 12:34:56'")))).matches("INTERVAL '-1' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:55.1' - TIMESTAMP '2020-05-01 12:34:56.2'")))).matches("INTERVAL '-1.1' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:55.11' - TIMESTAMP '2020-05-01 12:34:56.22'")))).matches("INTERVAL '-1.11' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:55.111' - TIMESTAMP '2020-05-01 12:34:56.222'")))).matches("INTERVAL '-1.111' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:55.1111' - TIMESTAMP '2020-05-01 12:34:56.2222'")))).matches("INTERVAL '-1.111' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:55.11111' - TIMESTAMP '2020-05-01 12:34:56.22222'")))).matches("INTERVAL '-1.111' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:55.111111' - TIMESTAMP '2020-05-01 12:34:56.222222'")))).matches("INTERVAL '-1.111' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:55.1111111' - TIMESTAMP '2020-05-01 12:34:56.2222222'")))).matches("INTERVAL '-1.111' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:55.11111111' - TIMESTAMP '2020-05-01 12:34:56.22222222'")))).matches("INTERVAL '-1.111' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:55.111111111' - TIMESTAMP '2020-05-01 12:34:56.222222222'")))).matches("INTERVAL '-1.111' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:55.1111111111' - TIMESTAMP '2020-05-01 12:34:56.2222222222'")))).matches("INTERVAL '-1.111' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:55.11111111111' - TIMESTAMP '2020-05-01 12:34:56.22222222222'")))).matches("INTERVAL '-1.111' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:55.111111111111' - TIMESTAMP '2020-05-01 12:34:56.222222222222'")))).matches("INTERVAL '-1.111' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:55.1' - TIMESTAMP '2020-05-01 12:34:56.9'")))).matches("INTERVAL '-1.8' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:55.11' - TIMESTAMP '2020-05-01 12:34:56.99'")))).matches("INTERVAL '-1.88' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:55.111' - TIMESTAMP '2020-05-01 12:34:56.999'")))).matches("INTERVAL '-1.888' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:55.1111' - TIMESTAMP '2020-05-01 12:34:56.9999'")))).matches("INTERVAL '-1.889' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:55.11111' - TIMESTAMP '2020-05-01 12:34:56.99999'")))).matches("INTERVAL '-1.889' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:55.111111' - TIMESTAMP '2020-05-01 12:34:56.999999'")))).matches("INTERVAL '-1.889' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:55.1111111' - TIMESTAMP '2020-05-01 12:34:56.9999999'")))).matches("INTERVAL '-1.889' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:55.11111111' - TIMESTAMP '2020-05-01 12:34:56.99999999'")))).matches("INTERVAL '-1.889' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:55.111111111' - TIMESTAMP '2020-05-01 12:34:56.999999999'")))).matches("INTERVAL '-1.889' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:55.1111111111' - TIMESTAMP '2020-05-01 12:34:56.9999999999'")))).matches("INTERVAL '-1.889' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:55.11111111111' - TIMESTAMP '2020-05-01 12:34:56.99999999999'")))).matches("INTERVAL '-1.889' SECOND");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat(this.assertions.expression("TIMESTAMP '2020-05-01 12:34:55.111111111111' - TIMESTAMP '2020-05-01 12:34:56.999999999999'")))).matches("INTERVAL '-1.889' SECOND");
    }
}

