/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.spiller;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.MoreExecutors;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.metadata.MetadataManager;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.block.BlockEncodingSerde;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.spiller.FileSingleStreamSpillerFactory;
import io.trino.spiller.GenericSpillerFactory;
import io.trino.spiller.SingleStreamSpillerFactory;
import io.trino.spiller.Spiller;
import io.trino.spiller.SpillerFactory;
import io.trino.spiller.SpillerStats;
import io.trino.tpch.LineItem;
import io.trino.tpch.LineItemGenerator;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.SECONDS)
@Fork(value=3)
@Warmup(iterations=5, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
public class BenchmarkBinaryFileSpiller {
    private static final List<Type> TYPES = ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE, (Object)VarcharType.createUnboundedVarcharType(), (Object)DoubleType.DOUBLE);
    private static final BlockEncodingSerde BLOCK_ENCODING_SERDE = MetadataManager.createTestMetadataManager().getBlockEncodingSerde();
    private static final Path SPILL_PATH = Paths.get(System.getProperty("java.io.tmpdir"), "spills");

    @Benchmark
    public void write(BenchmarkData data) throws ExecutionException, InterruptedException {
        try (Spiller spiller = data.createSpiller();){
            spiller.spill(data.getPages().iterator()).get();
        }
    }

    @Benchmark
    public void read(BenchmarkData data) {
        List spills = data.getReadSpiller().getSpills();
        for (Iterator spill : spills) {
            while (spill.hasNext()) {
                Page next = (Page)spill.next();
                next.getPositionCount();
            }
        }
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        private final SpillerStats spillerStats = new SpillerStats();
        @Param(value={"10000"})
        private int rowsPerPage = 10000;
        @Param(value={"10"})
        private int pagesCount = 10;
        @Param(value={"false"})
        private boolean compressionEnabled;
        @Param(value={"true"})
        private boolean encryptionEnabled;
        private List<Page> pages;
        private Spiller readSpiller;
        private FileSingleStreamSpillerFactory singleStreamSpillerFactory;
        private SpillerFactory spillerFactory;

        @Setup
        public void setup() throws ExecutionException, InterruptedException {
            this.singleStreamSpillerFactory = new FileSingleStreamSpillerFactory(MoreExecutors.newDirectExecutorService(), BLOCK_ENCODING_SERDE, this.spillerStats, (List)ImmutableList.of((Object)SPILL_PATH), 1.0, this.compressionEnabled, this.encryptionEnabled);
            this.spillerFactory = new GenericSpillerFactory((SingleStreamSpillerFactory)this.singleStreamSpillerFactory);
            this.pages = this.createInputPages();
            this.readSpiller = this.spillerFactory.create(TYPES, bytes -> {}, AggregatedMemoryContext.newSimpleAggregatedMemoryContext());
            this.readSpiller.spill(this.pages.iterator()).get();
        }

        @TearDown
        public void tearDown() {
            this.readSpiller.close();
            this.singleStreamSpillerFactory.destroy();
        }

        private List<Page> createInputPages() {
            ImmutableList.Builder pages = ImmutableList.builder();
            PageBuilder pageBuilder = new PageBuilder(TYPES);
            LineItemGenerator lineItemGenerator = new LineItemGenerator(1.0, 1, 1);
            for (int j = 0; j < this.pagesCount; ++j) {
                Iterator iterator = lineItemGenerator.iterator();
                for (int i = 0; i < this.rowsPerPage; ++i) {
                    pageBuilder.declarePosition();
                    LineItem lineItem = (LineItem)iterator.next();
                    BigintType.BIGINT.writeLong(pageBuilder.getBlockBuilder(0), lineItem.getOrderKey());
                    BigintType.BIGINT.writeLong(pageBuilder.getBlockBuilder(1), lineItem.getDiscountPercent());
                    DoubleType.DOUBLE.writeDouble(pageBuilder.getBlockBuilder(2), lineItem.getDiscount());
                    VarcharType.VARCHAR.writeString(pageBuilder.getBlockBuilder(3), lineItem.getReturnFlag());
                    DoubleType.DOUBLE.writeDouble(pageBuilder.getBlockBuilder(4), lineItem.getExtendedPrice());
                }
                pages.add((Object)pageBuilder.build());
                pageBuilder.reset();
            }
            return pages.build();
        }

        public List<Page> getPages() {
            return this.pages;
        }

        public Spiller getReadSpiller() {
            return this.readSpiller;
        }

        public Spiller createSpiller() {
            return this.spillerFactory.create(TYPES, bytes -> {}, AggregatedMemoryContext.newSimpleAggregatedMemoryContext());
        }
    }
}

