/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.window.matcher;

import com.google.common.collect.ImmutableList;
import io.trino.operator.PagesIndex;
import io.trino.operator.window.PagesWindowIndex;
import io.trino.operator.window.matcher.ArrayView;
import io.trino.operator.window.matcher.IrRowPatternToProgramRewriter;
import io.trino.operator.window.matcher.MatchResult;
import io.trino.operator.window.matcher.Matcher;
import io.trino.operator.window.matcher.Program;
import io.trino.operator.window.pattern.LabelEvaluator;
import io.trino.spi.Page;
import io.trino.spi.function.WindowIndex;
import io.trino.sql.planner.rowpattern.ir.IrLabel;
import io.trino.sql.planner.rowpattern.ir.IrRowPattern;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractIntArrayAssert;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;

public class MatchAssert
extends AbstractAssert<MatchAssert, MatchResult> {
    private final Map<IrLabel, Integer> labelMapping;

    private MatchAssert(MatchResult actual, Map<IrLabel, Integer> labelMapping) {
        super((Object)actual, Object.class);
        this.labelMapping = labelMapping;
    }

    public static AssertProvider<MatchAssert> match(IrRowPattern pattern, String input, Map<IrLabel, Integer> labelMapping) {
        Program program = IrRowPatternToProgramRewriter.rewrite((IrRowPattern)pattern, labelMapping);
        Matcher matcher = new Matcher(program);
        int[] mappedInput = new int[input.length()];
        char[] chars = input.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            mappedInput[i] = labelMapping.get(new IrLabel(String.valueOf(chars[i])));
        }
        return () -> new MatchAssert(matcher.run(MatchAssert.identityEvaluator(mappedInput)), labelMapping);
    }

    public MatchAssert hasLabels(char[] expectedLabels) {
        int[] mappedExpected = new int[expectedLabels.length];
        for (int i = 0; i < expectedLabels.length; ++i) {
            mappedExpected[i] = this.labelMapping.get(new IrLabel(String.valueOf(expectedLabels[i])));
        }
        return (MatchAssert)((MatchAssert)this.satisfies(actual -> Assertions.assertThat((boolean)actual.isMatched()))).satisfies(actual -> ((AbstractIntArrayAssert)Assertions.assertThat((int[])actual.getLabels().toArray()).as("Matched labels", new Object[0])).isEqualTo((Object)mappedExpected));
    }

    public MatchAssert hasCaptures(int[] expectedCaptures) {
        return (MatchAssert)((MatchAssert)this.satisfies(actual -> Assertions.assertThat((boolean)actual.isMatched()))).satisfies(actual -> ((AbstractIntArrayAssert)Assertions.assertThat((int[])actual.getExclusions().toArray()).as("Captured exclusions", new Object[0])).isEqualTo((Object)expectedCaptures));
    }

    public MatchAssert isNoMatch() {
        return (MatchAssert)this.satisfies(actual -> Assertions.assertThat((!actual.isMatched() ? 1 : 0) != 0));
    }

    private static LabelEvaluator identityEvaluator(int[] input) {
        PagesIndex pagesIndex = new PagesIndex.TestingFactory(false).newPagesIndex((List)ImmutableList.of(), 1);
        pagesIndex.addPage(new Page(1));
        return new IdentityEvaluator(input, (WindowIndex)new PagesWindowIndex(pagesIndex, 0, 1));
    }

    private static class IdentityEvaluator
    extends LabelEvaluator {
        private final int[] input;

        public IdentityEvaluator(int[] input, WindowIndex dummy) {
            super(0L, 0, 0, 0, 1, (List)ImmutableList.of(), dummy);
            this.input = input;
        }

        public int getInputLength() {
            return this.input.length;
        }

        public boolean isMatchingAtPartitionStart() {
            return true;
        }

        public boolean evaluateLabel(int label, ArrayView matchedLabels) {
            return this.input[matchedLabels.length()] == label;
        }
    }
}

