/*
 * Decompiled with CFR 0.152.
 */
package io.trino.security;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.trino.security.AccessControlConfig;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import org.testng.annotations.Test;

public class TestAccessControlConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((AccessControlConfig)ConfigAssertions.recordDefaults(AccessControlConfig.class)).setAccessControlFiles(""));
    }

    @Test
    public void testExplicitPropertyMappings() throws IOException {
        Path config1 = Files.createTempFile(null, null, new FileAttribute[0]);
        Path config2 = Files.createTempFile(null, null, new FileAttribute[0]);
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"access-control.config-files", (Object)(config1.toString() + "," + config2.toString())).build();
        AccessControlConfig expected = new AccessControlConfig().setAccessControlFiles((List)ImmutableList.of((Object)config1.toFile(), (Object)config2.toFile()));
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

