/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.SessionTestUtils;
import io.trino.execution.QueryInfo;
import io.trino.execution.QueryState;
import io.trino.execution.QueryStats;
import io.trino.operator.BlockedReason;
import io.trino.server.BasicQueryInfo;
import io.trino.server.DynamicFilterService;
import io.trino.spi.QueryId;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.eventlistener.StageGcStatistics;
import io.trino.spi.memory.MemoryPoolId;
import io.trino.spi.resourcegroups.QueryType;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestBasicQueryInfo {
    @Test
    public void testConstructor() {
        BasicQueryInfo basicInfo = new BasicQueryInfo(new QueryInfo(new QueryId("0"), SessionTestUtils.TEST_SESSION.toSessionRepresentation(), QueryState.RUNNING, new MemoryPoolId("reserved"), false, URI.create("1"), (List)ImmutableList.of((Object)"2", (Object)"3"), "SELECT 4", Optional.empty(), new QueryStats(DateTime.parse((String)"1991-09-06T05:00-05:30"), DateTime.parse((String)"1991-09-06T05:01-05:30"), DateTime.parse((String)"1991-09-06T05:02-05:30"), DateTime.parse((String)"1991-09-06T06:00-05:30"), new Duration(8.0, TimeUnit.MINUTES), new Duration(7.0, TimeUnit.MINUTES), new Duration(35.0, TimeUnit.MINUTES), new Duration(35.0, TimeUnit.MINUTES), new Duration(44.0, TimeUnit.MINUTES), new Duration(9.0, TimeUnit.MINUTES), new Duration(99.0, TimeUnit.SECONDS), new Duration(12.0, TimeUnit.MINUTES), 13, 14, 15, 16, 17, 18, 34, 19, 20.0, 10.0, DataSize.valueOf((String)"21GB"), DataSize.valueOf((String)"22GB"), DataSize.valueOf((String)"23GB"), DataSize.valueOf((String)"24GB"), DataSize.valueOf((String)"25GB"), DataSize.valueOf((String)"30GB"), DataSize.valueOf((String)"26GB"), DataSize.valueOf((String)"27GB"), DataSize.valueOf((String)"28GB"), DataSize.valueOf((String)"29GB"), true, new Duration(23.0, TimeUnit.MINUTES), new Duration(24.0, TimeUnit.MINUTES), new Duration(26.0, TimeUnit.MINUTES), true, (Set)ImmutableSet.of((Object)BlockedReason.WAITING_FOR_MEMORY), DataSize.valueOf((String)"271GB"), 281L, new Duration(20.0, TimeUnit.MINUTES), DataSize.valueOf((String)"272GB"), 282L, DataSize.valueOf((String)"27GB"), 28L, DataSize.valueOf((String)"29GB"), 30L, DataSize.valueOf((String)"31GB"), 32L, DataSize.valueOf((String)"32GB"), (List)ImmutableList.of((Object)new StageGcStatistics(101, 102, 103, 104, 105, 106, 107)), DynamicFilterService.DynamicFiltersStats.EMPTY, (List)ImmutableList.of()), Optional.empty(), Optional.empty(), Optional.empty(), (Map)ImmutableMap.of(), (Set)ImmutableSet.of(), (Map)ImmutableMap.of(), (Map)ImmutableMap.of(), (Set)ImmutableSet.of(), Optional.empty(), false, "33", Optional.empty(), null, StandardErrorCode.ABANDONED_QUERY.toErrorCode(), (List)ImmutableList.of(), (Set)ImmutableSet.of(), Optional.empty(), (List)ImmutableList.of(), (List)ImmutableList.of(), false, Optional.empty(), Optional.of(QueryType.SELECT)));
        Assert.assertEquals((String)basicInfo.getQueryId().getId(), (String)"0");
        Assert.assertEquals((Object)basicInfo.getState(), (Object)QueryState.RUNNING);
        Assert.assertEquals((String)basicInfo.getMemoryPool().getId(), (String)"reserved");
        Assert.assertEquals((boolean)basicInfo.isScheduled(), (boolean)false);
        Assert.assertEquals((String)basicInfo.getQuery(), (String)"SELECT 4");
        Assert.assertEquals(basicInfo.getQueryType().get(), (Object)QueryType.SELECT);
        Assert.assertEquals((Object)basicInfo.getQueryStats().getCreateTime(), (Object)DateTime.parse((String)"1991-09-06T05:00-05:30"));
        Assert.assertEquals((Object)basicInfo.getQueryStats().getEndTime(), (Object)DateTime.parse((String)"1991-09-06T06:00-05:30"));
        Assert.assertEquals((Object)basicInfo.getQueryStats().getElapsedTime(), (Object)new Duration(8.0, TimeUnit.MINUTES));
        Assert.assertEquals((Object)basicInfo.getQueryStats().getExecutionTime(), (Object)new Duration(44.0, TimeUnit.MINUTES));
        Assert.assertEquals((int)basicInfo.getQueryStats().getTotalDrivers(), (int)16);
        Assert.assertEquals((int)basicInfo.getQueryStats().getQueuedDrivers(), (int)17);
        Assert.assertEquals((int)basicInfo.getQueryStats().getRunningDrivers(), (int)18);
        Assert.assertEquals((int)basicInfo.getQueryStats().getCompletedDrivers(), (int)19);
        Assert.assertEquals((Object)basicInfo.getQueryStats().getCumulativeUserMemory(), (Object)20.0);
        Assert.assertEquals((Object)basicInfo.getQueryStats().getCumulativeSystemMemory(), (Object)10.0);
        Assert.assertEquals((Object)basicInfo.getQueryStats().getUserMemoryReservation(), (Object)DataSize.valueOf((String)"21GB"));
        Assert.assertEquals((Object)basicInfo.getQueryStats().getTotalMemoryReservation(), (Object)DataSize.valueOf((String)"23GB"));
        Assert.assertEquals((Object)basicInfo.getQueryStats().getPeakUserMemoryReservation(), (Object)DataSize.valueOf((String)"24GB"));
        Assert.assertEquals((Object)basicInfo.getQueryStats().getTotalCpuTime(), (Object)new Duration(24.0, TimeUnit.MINUTES));
        Assert.assertEquals((boolean)basicInfo.getQueryStats().isFullyBlocked(), (boolean)true);
        Assert.assertEquals((Set)basicInfo.getQueryStats().getBlockedReasons(), (Set)ImmutableSet.of((Object)BlockedReason.WAITING_FOR_MEMORY));
        Assert.assertEquals((Object)basicInfo.getQueryStats().getProgressPercentage(), (Object)OptionalDouble.of(100.0));
        Assert.assertEquals((Object)basicInfo.getErrorCode(), (Object)StandardErrorCode.ABANDONED_QUERY.toErrorCode());
        Assert.assertEquals((Object)basicInfo.getErrorType(), (Object)StandardErrorCode.ABANDONED_QUERY.toErrorCode().getType());
    }
}

