/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import io.airlift.jaxrs.testing.GuavaMultivaluedMap;
import io.trino.Session;
import io.trino.client.ProtocolHeaders;
import io.trino.metadata.SessionPropertyManager;
import io.trino.security.AccessControl;
import io.trino.security.AllowAllAccessControl;
import io.trino.server.HttpRequestSessionContext;
import io.trino.server.QuerySessionSupplier;
import io.trino.server.SessionContext;
import io.trino.spi.QueryId;
import io.trino.spi.TrinoException;
import io.trino.spi.type.TimeZoneKey;
import io.trino.sql.SqlEnvironmentConfig;
import io.trino.sql.SqlPath;
import io.trino.sql.SqlPathElement;
import io.trino.sql.tree.Identifier;
import io.trino.transaction.InMemoryTransactionManager;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.ws.rs.core.MultivaluedMap;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestQuerySessionSupplier {
    private static final MultivaluedMap<String, String> TEST_HEADERS = new GuavaMultivaluedMap((Multimap)ImmutableListMultimap.builder().put((Object)ProtocolHeaders.TRINO_HEADERS.requestUser(), (Object)"testUser").put((Object)ProtocolHeaders.TRINO_HEADERS.requestSource(), (Object)"testSource").put((Object)ProtocolHeaders.TRINO_HEADERS.requestCatalog(), (Object)"testCatalog").put((Object)ProtocolHeaders.TRINO_HEADERS.requestSchema(), (Object)"testSchema").put((Object)ProtocolHeaders.TRINO_HEADERS.requestPath(), (Object)"testPath").put((Object)ProtocolHeaders.TRINO_HEADERS.requestLanguage(), (Object)"zh-TW").put((Object)ProtocolHeaders.TRINO_HEADERS.requestTimeZone(), (Object)"Asia/Taipei").put((Object)ProtocolHeaders.TRINO_HEADERS.requestClientInfo(), (Object)"client-info").put((Object)ProtocolHeaders.TRINO_HEADERS.requestClientTags(), (Object)"tag1,tag2 ,tag3, tag2").put((Object)ProtocolHeaders.TRINO_HEADERS.requestSession(), (Object)"query_max_memory=1GB").put((Object)ProtocolHeaders.TRINO_HEADERS.requestSession(), (Object)"join_distribution_type=partitioned,hash_partition_count = 43").put((Object)ProtocolHeaders.TRINO_HEADERS.requestPreparedStatement(), (Object)"query1=select * from foo,query2=select * from bar").build());

    @Test
    public void testCreateSession() {
        HttpRequestSessionContext context = new HttpRequestSessionContext(TEST_HEADERS, Optional.empty(), "testRemote", Optional.empty(), user -> ImmutableSet.of());
        QuerySessionSupplier sessionSupplier = TestQuerySessionSupplier.createSessionSupplier(new SqlEnvironmentConfig());
        Session session = sessionSupplier.createSession(new QueryId("test_query_id"), (SessionContext)context);
        Assert.assertEquals((Object)session.getQueryId(), (Object)new QueryId("test_query_id"));
        Assert.assertEquals((String)session.getUser(), (String)"testUser");
        Assert.assertEquals((String)((String)session.getSource().get()), (String)"testSource");
        Assert.assertEquals((String)((String)session.getCatalog().get()), (String)"testCatalog");
        Assert.assertEquals((String)((String)session.getSchema().get()), (String)"testSchema");
        Assert.assertEquals((String)((String)session.getPath().getRawPath().get()), (String)"testPath");
        Assert.assertEquals((Object)session.getLocale(), (Object)Locale.TAIWAN);
        Assert.assertEquals((Object)session.getTimeZoneKey(), (Object)TimeZoneKey.getTimeZoneKey((String)"Asia/Taipei"));
        Assert.assertEquals((String)((String)session.getRemoteUserAddress().get()), (String)"testRemote");
        Assert.assertEquals((String)((String)session.getClientInfo().get()), (String)"client-info");
        Assert.assertEquals((Set)session.getClientTags(), (Set)ImmutableSet.of((Object)"tag1", (Object)"tag2", (Object)"tag3"));
        Assert.assertEquals((Map)session.getSystemProperties(), (Map)ImmutableMap.builder().put((Object)"query_max_memory", (Object)"1GB").put((Object)"join_distribution_type", (Object)"partitioned").put((Object)"hash_partition_count", (Object)"43").build());
        Assert.assertEquals((Map)session.getPreparedStatements(), (Map)ImmutableMap.builder().put((Object)"query1", (Object)"select * from foo").put((Object)"query2", (Object)"select * from bar").build());
    }

    @Test
    public void testEmptyClientTags() {
        GuavaMultivaluedMap headers1 = new GuavaMultivaluedMap((Multimap)ImmutableListMultimap.builder().put((Object)ProtocolHeaders.TRINO_HEADERS.requestUser(), (Object)"testUser").build());
        HttpRequestSessionContext context1 = new HttpRequestSessionContext((MultivaluedMap)headers1, Optional.empty(), "remoteAddress", Optional.empty(), user -> ImmutableSet.of());
        Assert.assertEquals((Set)context1.getClientTags(), (Set)ImmutableSet.of());
        GuavaMultivaluedMap headers2 = new GuavaMultivaluedMap((Multimap)ImmutableListMultimap.builder().put((Object)ProtocolHeaders.TRINO_HEADERS.requestUser(), (Object)"testUser").put((Object)ProtocolHeaders.TRINO_HEADERS.requestClientTags(), (Object)"").build());
        HttpRequestSessionContext context2 = new HttpRequestSessionContext((MultivaluedMap)headers2, Optional.empty(), "remoteAddress", Optional.empty(), user -> ImmutableSet.of());
        Assert.assertEquals((Set)context2.getClientTags(), (Set)ImmutableSet.of());
    }

    @Test
    public void testClientCapabilities() {
        GuavaMultivaluedMap headers1 = new GuavaMultivaluedMap((Multimap)ImmutableListMultimap.builder().put((Object)ProtocolHeaders.TRINO_HEADERS.requestUser(), (Object)"testUser").put((Object)ProtocolHeaders.TRINO_HEADERS.requestClientCapabilities(), (Object)"foo, bar").build());
        HttpRequestSessionContext context1 = new HttpRequestSessionContext((MultivaluedMap)headers1, Optional.empty(), "remoteAddress", Optional.empty(), user -> ImmutableSet.of());
        Assert.assertEquals((Set)context1.getClientCapabilities(), (Set)ImmutableSet.of((Object)"foo", (Object)"bar"));
        GuavaMultivaluedMap headers2 = new GuavaMultivaluedMap((Multimap)ImmutableListMultimap.builder().put((Object)ProtocolHeaders.TRINO_HEADERS.requestUser(), (Object)"testUser").build());
        HttpRequestSessionContext context2 = new HttpRequestSessionContext((MultivaluedMap)headers2, Optional.empty(), "remoteAddress", Optional.empty(), user -> ImmutableSet.of());
        Assert.assertEquals((Set)context2.getClientCapabilities(), (Set)ImmutableSet.of());
    }

    @Test(expectedExceptions={TrinoException.class})
    public void testInvalidTimeZone() {
        GuavaMultivaluedMap headers = new GuavaMultivaluedMap((Multimap)ImmutableListMultimap.builder().put((Object)ProtocolHeaders.TRINO_HEADERS.requestUser(), (Object)"testUser").put((Object)ProtocolHeaders.TRINO_HEADERS.requestTimeZone(), (Object)"unknown_timezone").build());
        HttpRequestSessionContext context = new HttpRequestSessionContext((MultivaluedMap)headers, Optional.empty(), "remoteAddress", Optional.empty(), user -> ImmutableSet.of());
        QuerySessionSupplier sessionSupplier = TestQuerySessionSupplier.createSessionSupplier(new SqlEnvironmentConfig());
        sessionSupplier.createSession(new QueryId("test_query_id"), (SessionContext)context);
    }

    @Test
    public void testSqlPathCreation() {
        ImmutableList.Builder correctValues = ImmutableList.builder();
        correctValues.add((Object)new SqlPathElement(Optional.of(new Identifier("normal")), new Identifier("schema")));
        correctValues.add((Object)new SqlPathElement(Optional.of(new Identifier("who.uses.periods")), new Identifier("in.schema.names")));
        correctValues.add((Object)new SqlPathElement(Optional.of(new Identifier("same,deal")), new Identifier("with,commas")));
        correctValues.add((Object)new SqlPathElement(Optional.of(new Identifier("aterrible")), new Identifier("thing!@#$%^&*()")));
        ImmutableList expected = correctValues.build();
        SqlPath path = new SqlPath(Optional.of("normal.schema,\"who.uses.periods\".\"in.schema.names\",\"same,deal\".\"with,commas\",aterrible.\"thing!@#$%^&*()\""));
        Assert.assertEquals((Collection)path.getParsedPath(), (Collection)expected);
        Assert.assertEquals((String)path.toString(), (String)Joiner.on((String)", ").join((Iterable)expected));
    }

    @Test
    public void testDefaultCatalogAndSchema() {
        Session session = TestQuerySessionSupplier.createSession((ListMultimap<String, String>)ImmutableListMultimap.builder().put((Object)ProtocolHeaders.TRINO_HEADERS.requestUser(), (Object)"testUser").build(), new SqlEnvironmentConfig());
        Assert.assertFalse((boolean)session.getCatalog().isPresent());
        Assert.assertFalse((boolean)session.getSchema().isPresent());
        session = TestQuerySessionSupplier.createSession((ListMultimap<String, String>)ImmutableListMultimap.builder().put((Object)ProtocolHeaders.TRINO_HEADERS.requestUser(), (Object)"testUser").build(), new SqlEnvironmentConfig().setDefaultCatalog("catalog"));
        Assert.assertEquals((Object)session.getCatalog(), Optional.of("catalog"));
        Assert.assertFalse((boolean)session.getSchema().isPresent());
        session = TestQuerySessionSupplier.createSession((ListMultimap<String, String>)ImmutableListMultimap.builder().put((Object)ProtocolHeaders.TRINO_HEADERS.requestUser(), (Object)"testUser").build(), new SqlEnvironmentConfig().setDefaultCatalog("catalog").setDefaultSchema("schema"));
        Assert.assertEquals((Object)session.getCatalog(), Optional.of("catalog"));
        Assert.assertEquals((Object)session.getSchema(), Optional.of("schema"));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestQuerySessionSupplier.createSessionSupplier(new SqlEnvironmentConfig().setDefaultSchema("schema"))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Default schema cannot be set if catalog is not set");
    }

    @Test
    public void testCatalogAndSchemaOverrides() {
        Session session = TestQuerySessionSupplier.createSession((ListMultimap<String, String>)ImmutableListMultimap.builder().put((Object)ProtocolHeaders.TRINO_HEADERS.requestUser(), (Object)"testUser").put((Object)ProtocolHeaders.TRINO_HEADERS.requestCatalog(), (Object)"catalog").put((Object)ProtocolHeaders.TRINO_HEADERS.requestSchema(), (Object)"schema").build(), new SqlEnvironmentConfig().setDefaultCatalog("default-catalog").setDefaultSchema("default-schema"));
        Assert.assertEquals((Object)session.getCatalog(), Optional.of("catalog"));
        Assert.assertEquals((Object)session.getSchema(), Optional.of("schema"));
    }

    private static Session createSession(ListMultimap<String, String> headers, SqlEnvironmentConfig config) {
        GuavaMultivaluedMap headerMap = new GuavaMultivaluedMap(headers);
        HttpRequestSessionContext context = new HttpRequestSessionContext((MultivaluedMap)headerMap, Optional.empty(), "testRemote", Optional.empty(), user -> ImmutableSet.of());
        QuerySessionSupplier sessionSupplier = TestQuerySessionSupplier.createSessionSupplier(config);
        return sessionSupplier.createSession(new QueryId("test_query_id"), (SessionContext)context);
    }

    private static QuerySessionSupplier createSessionSupplier(SqlEnvironmentConfig config) {
        return new QuerySessionSupplier(InMemoryTransactionManager.createTestTransactionManager(), (AccessControl)new AllowAllAccessControl(), new SessionPropertyManager(), config);
    }
}

