/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.protocol;

import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import io.trino.RowPagesBuilder;
import io.trino.Session;
import io.trino.client.ClientTypeSignature;
import io.trino.client.Column;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataManager;
import io.trino.server.protocol.QueryResultRows;
import io.trino.spi.Page;
import io.trino.spi.TrinoException;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.testing.TestingSession;
import io.trino.tests.BogusType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.ListAssert;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.testng.collections.Lists;

public class TestQueryResultRows {
    private static final Function<String, Column> BOOLEAN_COLUMN = name -> new Column(name, "boolean", new ClientTypeSignature("boolean"));
    private static final Function<String, Column> BIGINT_COLUMN = name -> new Column(name, "bigint", new ClientTypeSignature("bigint"));
    private static final Function<String, Column> INT_COLUMN = name -> new Column(name, "integer", new ClientTypeSignature("integer"));
    private static final Metadata METADATA = MetadataManager.createTestMetadataManager();

    @Test
    public void shouldNotReturnValues() {
        QueryResultRows rows = QueryResultRows.empty((Session)TestQueryResultRows.getSession());
        ((IterableAssert)Assertions.assertThat((Iterable)rows).as("rows", new Object[0])).isEmpty();
        Assertions.assertThat(TestQueryResultRows.getAllValues(rows)).hasSize(0);
        Assertions.assertThat((Optional)rows.getColumns()).isEmpty();
        Assertions.assertThat((boolean)rows.iterator().hasNext()).isFalse();
    }

    @Test
    public void shouldReturnSingleValue() {
        Column column = BOOLEAN_COLUMN.apply("_col0");
        QueryResultRows rows = QueryResultRows.queryResultRowsBuilder((Session)TestQueryResultRows.getSession()).withSingleBooleanValue(column, true).build();
        ((IterableAssert)Assertions.assertThat((Iterable)rows).as("rows", new Object[0])).isNotEmpty();
        ((ListAssert)Assertions.assertThat(TestQueryResultRows.getAllValues(rows)).hasSize(1)).containsOnly((Object[])new List[]{ImmutableList.of((Object)true)});
        Assertions.assertThat((List)((List)rows.getColumns().orElseThrow())).containsOnly((Object[])new Column[]{column});
        Assertions.assertThat((boolean)rows.iterator().hasNext()).isFalse();
    }

    @Test
    public void shouldReturnUpdateCount() {
        Column column = BIGINT_COLUMN.apply("_col0");
        long value = 10123L;
        QueryResultRows rows = QueryResultRows.queryResultRowsBuilder((Session)TestQueryResultRows.getSession()).withColumnsAndTypes((List)ImmutableList.of((Object)column), (List)ImmutableList.of((Object)BigintType.BIGINT)).addPages(RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT}).row(value).build()).build();
        ((IterableAssert)Assertions.assertThat((Iterable)rows).as("rows", new Object[0])).isNotEmpty();
        Assertions.assertThat((Optional)rows.getUpdateCount()).isPresent();
        Assertions.assertThat((Long)((Long)rows.getUpdateCount().get())).isEqualTo(value);
        Assertions.assertThat(TestQueryResultRows.getAllValues(rows)).containsExactly((Object[])new List[]{ImmutableList.of((Object)value)});
        Assertions.assertThat((List)((List)rows.getColumns().orElseThrow())).containsOnly((Object[])new Column[]{column});
        Assertions.assertThat((Iterator)rows.iterator()).isExhausted();
    }

    @Test
    public void shouldNotHaveUpdateCount() {
        Column column = BOOLEAN_COLUMN.apply("_col0");
        QueryResultRows rows = QueryResultRows.queryResultRowsBuilder((Session)TestQueryResultRows.getSession()).withSingleBooleanValue(column, false).build();
        ((IterableAssert)Assertions.assertThat((Iterable)rows).as("rows", new Object[0])).isNotEmpty();
        Assertions.assertThat((Optional)rows.getUpdateCount()).isEmpty();
        Assertions.assertThat((Iterator)rows.iterator()).hasNext();
    }

    @Test
    public void shouldReadAllValuesFromMultiplePages() {
        ImmutableList columns = ImmutableList.of((Object)INT_COLUMN.apply("_col0"), (Object)BIGINT_COLUMN.apply("_col1"));
        ImmutableList types = ImmutableList.of((Object)IntegerType.INTEGER, (Object)BigintType.BIGINT);
        List<Page> pages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)types).row(0, 10L).row(1, 11L).row(2, 12L).row(3, 13L).row(4, 14L).pageBreak().row(100, 110L).row(101, 111L).row(102, 112L).row(103, 113L).row(104, 114L).build();
        TestExceptionConsumer exceptionConsumer = new TestExceptionConsumer();
        QueryResultRows rows = QueryResultRows.queryResultRowsBuilder((Session)TestQueryResultRows.getSession()).withColumnsAndTypes((List)columns, (List)types).addPages(pages).withExceptionConsumer((Consumer)exceptionConsumer).build();
        ((IterableAssert)Assertions.assertThat((Iterable)rows).as("rows", new Object[0])).isNotEmpty();
        Assertions.assertThat((long)rows.getTotalRowsCount()).isEqualTo(10L);
        Assertions.assertThat((Optional)rows.getColumns()).isEqualTo(Optional.of(columns));
        Assertions.assertThat((Optional)rows.getUpdateCount()).isEmpty();
        Assertions.assertThat(TestQueryResultRows.getAllValues(rows)).containsExactly((Object[])new List[]{ImmutableList.of((Object)0, (Object)10L), ImmutableList.of((Object)1, (Object)11L), ImmutableList.of((Object)2, (Object)12L), ImmutableList.of((Object)3, (Object)13L), ImmutableList.of((Object)4, (Object)14L), ImmutableList.of((Object)100, (Object)110L), ImmutableList.of((Object)101, (Object)111L), ImmutableList.of((Object)102, (Object)112L), ImmutableList.of((Object)103, (Object)113L), ImmutableList.of((Object)104, (Object)114L)});
        Assertions.assertThat(exceptionConsumer.getExceptions()).isEmpty();
    }

    @Test
    public void shouldOmitBadRows() {
        ImmutableList columns = ImmutableList.of((Object)BOOLEAN_COLUMN.apply("_col0"), (Object)BOOLEAN_COLUMN.apply("_col1"));
        ImmutableList types = ImmutableList.of((Object)((Object)BogusType.BOGUS), (Object)((Object)BogusType.BOGUS));
        List<Page> pages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)types).row(0, 1).row(0, 0).row(0, 1).row(1, 0).row(0, 1).build();
        TestExceptionConsumer exceptionConsumer = new TestExceptionConsumer();
        QueryResultRows rows = QueryResultRows.queryResultRowsBuilder((Session)TestQueryResultRows.getSession()).withColumnsAndTypes((List)columns, (List)types).withExceptionConsumer((Consumer)exceptionConsumer).addPages(pages).build();
        Assert.assertFalse((boolean)rows.isEmpty(), (String)"rows are empty");
        Assertions.assertThat((long)rows.getTotalRowsCount()).isEqualTo(5L);
        Assertions.assertThat((Optional)rows.getColumns()).isEqualTo(Optional.of(columns));
        Assert.assertTrue((boolean)rows.getUpdateCount().isEmpty());
        Assertions.assertThat(TestQueryResultRows.getAllValues(rows)).containsExactly((Object[])new List[]{ImmutableList.of((Object)0, (Object)0)});
        List<Throwable> exceptions = exceptionConsumer.getExceptions();
        Assertions.assertThat(exceptions).isNotEmpty();
        Assertions.assertThat(exceptions).hasSize(4);
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)exceptions.get(0)).isInstanceOf(TrinoException.class)).hasMessage("Could not serialize column '_col1' of type 'Bogus' at position 1:2").hasRootCauseMessage("This is bogus exception");
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)exceptions.get(1)).isInstanceOf(TrinoException.class)).hasMessage("Could not serialize column '_col1' of type 'Bogus' at position 3:2").hasRootCauseMessage("This is bogus exception");
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)exceptions.get(2)).isInstanceOf(TrinoException.class)).hasMessage("Could not serialize column '_col0' of type 'Bogus' at position 4:1").hasRootCauseMessage("This is bogus exception");
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)exceptions.get(3)).isInstanceOf(TrinoException.class)).hasMessage("Could not serialize column '_col1' of type 'Bogus' at position 5:2").hasRootCauseMessage("This is bogus exception");
    }

    @Test
    public void shouldHandleNullValues() {
        ImmutableList columns = ImmutableList.of((Object)new Column("_col0", "integer", new ClientTypeSignature("integer")), (Object)new Column("_col1", "boolean", new ClientTypeSignature("boolean")));
        ImmutableList types = ImmutableList.of((Object)IntegerType.INTEGER, (Object)BooleanType.BOOLEAN);
        List<Page> pages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)types).row(0, null).pageBreak().row(1, null).pageBreak().row(2, true).build();
        TestExceptionConsumer exceptionConsumer = new TestExceptionConsumer();
        QueryResultRows rows = QueryResultRows.queryResultRowsBuilder((Session)TestQueryResultRows.getSession()).withColumnsAndTypes((List)columns, (List)types).withExceptionConsumer((Consumer)exceptionConsumer).addPages(pages).build();
        Assert.assertFalse((boolean)rows.isEmpty(), (String)"rows are empty");
        Assertions.assertThat((long)rows.getTotalRowsCount()).isEqualTo(3L);
        ((ListAssert)Assertions.assertThat(TestQueryResultRows.getAllValues(rows)).hasSize(3)).containsExactly((Object[])new List[]{Lists.newArrayList((Object[])new Object[]{0, null}), Lists.newArrayList((Object[])new Object[]{1, null}), Lists.newArrayList((Object[])new Object[]{2, true})});
    }

    @Test
    public void shouldHandleNullTimestamps() {
        ImmutableList columns = ImmutableList.of((Object)new Column("_col0", "timestamp", new ClientTypeSignature("timestamp")), (Object)new Column("_col1", "timestamp with time zone", new ClientTypeSignature("timestamp with time zone")));
        ImmutableList types = ImmutableList.of((Object)TimestampType.TIMESTAMP_MILLIS, (Object)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE);
        List<Page> pages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)types).row(null, null).build();
        TestExceptionConsumer exceptionConsumer = new TestExceptionConsumer();
        QueryResultRows rows = QueryResultRows.queryResultRowsBuilder((Session)TestQueryResultRows.getSession()).withColumnsAndTypes((List)columns, (List)types).withExceptionConsumer((Consumer)exceptionConsumer).addPages(pages).build();
        Assertions.assertThat(exceptionConsumer.getExceptions()).isEmpty();
        Assert.assertFalse((boolean)rows.isEmpty(), (String)"rows are empty");
        Assertions.assertThat((long)rows.getTotalRowsCount()).isEqualTo(1L);
        ((ListAssert)Assertions.assertThat(TestQueryResultRows.getAllValues(rows)).hasSize(1)).containsExactly((Object[])new List[]{Lists.newArrayList((Object[])new Object[]{null, null})});
    }

    @Test
    public void shouldHandleNullValuesInArray() {
        ImmutableList columns = ImmutableList.of((Object)new Column("_col0", "array", new ClientTypeSignature("array")));
        ImmutableList types = ImmutableList.of((Object)new ArrayType((Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE));
        List<Page> pages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)types).row(Collections.singletonList(null)).build();
        TestExceptionConsumer exceptionConsumer = new TestExceptionConsumer();
        QueryResultRows rows = QueryResultRows.queryResultRowsBuilder((Session)TestQueryResultRows.getSession()).withColumnsAndTypes((List)columns, (List)types).withExceptionConsumer((Consumer)exceptionConsumer).addPages(pages).build();
        Assertions.assertThat(exceptionConsumer.getExceptions()).isEmpty();
        Assert.assertFalse((boolean)rows.isEmpty(), (String)"rows are empty");
        Assertions.assertThat((long)rows.getTotalRowsCount()).isEqualTo(1L);
        ((ListAssert)Assertions.assertThat(TestQueryResultRows.getAllValues(rows)).hasSize(1)).containsOnly((Object[])new List[]{Collections.singletonList(Collections.singletonList(null))});
        Assertions.assertThat(exceptionConsumer.getExceptions()).isEmpty();
    }

    @Test
    public void shouldHandleNullValuesInMap() {
        ImmutableList columns = ImmutableList.of((Object)new Column("_col0", "map", new ClientTypeSignature("map")));
        ImmutableList types = ImmutableList.of((Object)TestQueryResultRows.createMapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT));
        List<Page> pages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)types).row(Collections.singletonMap(10, null)).build();
        TestExceptionConsumer exceptionConsumer = new TestExceptionConsumer();
        QueryResultRows rows = QueryResultRows.queryResultRowsBuilder((Session)TestQueryResultRows.getSession()).withColumnsAndTypes((List)columns, (List)types).withExceptionConsumer((Consumer)exceptionConsumer).addPages(pages).build();
        Assertions.assertThat(exceptionConsumer.getExceptions()).isEmpty();
        Assert.assertFalse((boolean)rows.isEmpty(), (String)"rows are empty");
        Assertions.assertThat((long)rows.getTotalRowsCount()).isEqualTo(1L);
        ((ListAssert)Assertions.assertThat(TestQueryResultRows.getAllValues(rows)).hasSize(1)).containsOnly((Object[])new List[]{Collections.singletonList(Collections.singletonMap(10L, null))});
        Assertions.assertThat(exceptionConsumer.getExceptions()).isEmpty();
    }

    @Test
    public void shouldHandleNullValuesInRow() {
        ImmutableList columns = ImmutableList.of((Object)new Column("_col0", "row", new ClientTypeSignature("row")));
        ImmutableList types = ImmutableList.of((Object)RowType.from((List)ImmutableList.of((Object)RowType.field((String)"first", (Type)SmallintType.SMALLINT), (Object)RowType.field((String)"second", (Type)SmallintType.SMALLINT))));
        ArrayList<Short> values = new ArrayList<Short>();
        values.add(null);
        values.add((short)1);
        List<Page> pages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)types).row(values).build();
        TestExceptionConsumer exceptionConsumer = new TestExceptionConsumer();
        QueryResultRows rows = QueryResultRows.queryResultRowsBuilder((Session)TestQueryResultRows.getSession()).withColumnsAndTypes((List)columns, (List)types).withExceptionConsumer((Consumer)exceptionConsumer).addPages(pages).build();
        Assertions.assertThat(exceptionConsumer.getExceptions()).isEmpty();
        Assert.assertFalse((boolean)rows.isEmpty(), (String)"rows are empty");
        Assertions.assertThat((long)rows.getTotalRowsCount()).isEqualTo(1L);
        List<List<Object>> allValues = TestQueryResultRows.getAllValues(rows);
        ((ListAssert)Assertions.assertThat(allValues).hasSize(1)).containsOnly((Object[])new List[]{Collections.singletonList(Lists.newArrayList((Object[])new Short[]{null, (short)1}))});
        Assertions.assertThat(exceptionConsumer.getExceptions()).isEmpty();
    }

    @Test
    public void shouldNotThrowWhenDataAndColumnsAreMissing() {
        QueryResultRows.empty((Session)TestQueryResultRows.getSession());
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="columns and types size mismatch")
    public void shouldThrowWhenColumnsAndTypesSizeMismatch() {
        ImmutableList columns = ImmutableList.of((Object)INT_COLUMN.apply("_col0"));
        ImmutableList types = ImmutableList.of((Object)IntegerType.INTEGER, (Object)BooleanType.BOOLEAN);
        List<Page> pages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)types).row(0, null).build();
        QueryResultRows.queryResultRowsBuilder((Session)TestQueryResultRows.getSession()).addPages(pages).withColumnsAndTypes((List)columns, (List)types).build();
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="columns and types must be present at the same time")
    public void shouldThrowWhenColumnsAreNull() {
        ImmutableList types = ImmutableList.of((Object)IntegerType.INTEGER, (Object)BooleanType.BOOLEAN);
        List<Page> pages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)types).row(0, null).build();
        QueryResultRows.queryResultRowsBuilder((Session)TestQueryResultRows.getSession()).addPages(pages).withColumnsAndTypes(null, (List)types).build();
    }

    @Test
    public void shouldAcceptNullColumnsAndTypes() {
        QueryResultRows.queryResultRowsBuilder((Session)TestQueryResultRows.getSession()).withColumnsAndTypes(null, null).build();
    }

    @Test(expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="columns and types must be present at the same time")
    public void shouldThrowWhenTypesAreNull() {
        ImmutableList columns = ImmutableList.of((Object)INT_COLUMN.apply("_col0"));
        ImmutableList types = ImmutableList.of((Object)IntegerType.INTEGER, (Object)BooleanType.BOOLEAN);
        List<Page> pages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)types).row(0, null).build();
        QueryResultRows.queryResultRowsBuilder((Session)TestQueryResultRows.getSession()).addPages(pages).withColumnsAndTypes((List)columns, null).build();
    }

    @Test(expectedExceptions={VerifyException.class}, expectedExceptionsMessageRegExp="data present without columns and types")
    public void shouldThrowWhenDataIsPresentWithoutColumns() {
        List<Page> pages = RowPagesBuilder.rowPagesBuilder((Iterable<Type>)ImmutableList.of((Object)IntegerType.INTEGER, (Object)BooleanType.BOOLEAN)).row(0, null).build();
        QueryResultRows.queryResultRowsBuilder((Session)TestQueryResultRows.getSession()).addPages(pages).build();
    }

    private static List<List<Object>> getAllValues(QueryResultRows rows) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (List values : rows) {
            builder.add((Object)values);
        }
        return builder.build();
    }

    private static Session getSession() {
        return TestingSession.testSessionBuilder().build();
    }

    private static Type createMapType(Type keyType, Type valueType) {
        return METADATA.getType(TypeSignature.mapType((TypeSignature)keyType.getTypeSignature(), (TypeSignature)valueType.getTypeSignature()));
    }

    private static final class TestExceptionConsumer
    implements Consumer<Throwable> {
        private final List<Throwable> exceptions = new ArrayList<Throwable>();

        private TestExceptionConsumer() {
        }

        @Override
        public void accept(Throwable throwable) {
            this.exceptions.add(throwable);
        }

        public List<Throwable> getExceptions() {
            return this.exceptions;
        }
    }
}

