/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spiller;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Closer;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.metadata.MetadataManager;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.BlockEncodingSerde;
import io.trino.spi.type.BigintType;
import io.trino.spiller.FileSingleStreamSpillerFactory;
import io.trino.spiller.SingleStreamSpiller;
import io.trino.spiller.SpillerStats;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestFileSingleStreamSpillerFactory {
    private final BlockEncodingSerde blockEncodingSerde = MetadataManager.createTestMetadataManager().getBlockEncodingSerde();
    private Closer closer;
    private ListeningExecutorService executor;
    private File spillPath1;
    private File spillPath2;

    @BeforeMethod
    public void setUp() throws IOException {
        this.closer = Closer.create();
        this.executor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool());
        this.closer.register(() -> this.executor.shutdownNow());
        this.spillPath1 = Files.createTempDirectory("tmp_spill_path1", new FileAttribute[0]).toFile();
        this.closer.register(() -> MoreFiles.deleteRecursively((Path)this.spillPath1.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE}));
        this.spillPath2 = Files.createTempDirectory("tmp_spill_path2", new FileAttribute[0]).toFile();
        this.closer.register(() -> MoreFiles.deleteRecursively((Path)this.spillPath2.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE}));
    }

    @AfterMethod(alwaysRun=true)
    public void tearDown() throws Exception {
        this.closer.close();
    }

    @Test
    public void testDistributesSpillOverPaths() throws Exception {
        ImmutableList types = ImmutableList.of((Object)BigintType.BIGINT);
        ImmutableList spillPaths = ImmutableList.of((Object)this.spillPath1.toPath(), (Object)this.spillPath2.toPath());
        FileSingleStreamSpillerFactory spillerFactory = this.spillerFactoryFactory((List<Path>)spillPaths);
        Assert.assertEquals((int)MoreFiles.listFiles((Path)this.spillPath1.toPath()).size(), (int)0);
        Assert.assertEquals((int)MoreFiles.listFiles((Path)this.spillPath2.toPath()).size(), (int)0);
        Page page = this.buildPage();
        ArrayList<SingleStreamSpiller> spillers = new ArrayList<SingleStreamSpiller>();
        for (int i = 0; i < 10; ++i) {
            SingleStreamSpiller singleStreamSpiller = spillerFactory.create((List)types, bytes -> {}, AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext("test"));
            Futures.getUnchecked((Future)singleStreamSpiller.spill(page));
            spillers.add(singleStreamSpiller);
        }
        Assert.assertEquals((int)MoreFiles.listFiles((Path)this.spillPath1.toPath()).size(), (int)5);
        Assert.assertEquals((int)MoreFiles.listFiles((Path)this.spillPath2.toPath()).size(), (int)5);
        spillers.forEach(SingleStreamSpiller::close);
        Assert.assertEquals((int)MoreFiles.listFiles((Path)this.spillPath1.toPath()).size(), (int)0);
        Assert.assertEquals((int)MoreFiles.listFiles((Path)this.spillPath2.toPath()).size(), (int)0);
    }

    @Test
    public void testDistributesSpillOverPathsBadDisk() throws Exception {
        ImmutableList types = ImmutableList.of((Object)BigintType.BIGINT);
        ImmutableList spillPaths = ImmutableList.of((Object)this.spillPath1.toPath(), (Object)this.spillPath2.toPath());
        FileSingleStreamSpillerFactory spillerFactory = this.spillerFactoryFactory((List<Path>)spillPaths);
        Assert.assertEquals((int)MoreFiles.listFiles((Path)this.spillPath1.toPath()).size(), (int)0);
        Assert.assertEquals((int)MoreFiles.listFiles((Path)this.spillPath2.toPath()).size(), (int)0);
        Files.setPosixFilePermissions(this.spillPath1.toPath(), (Set<PosixFilePermission>)ImmutableSet.of((Object)((Object)PosixFilePermission.OWNER_READ)));
        Page page = this.buildPage();
        ArrayList<SingleStreamSpiller> spillers = new ArrayList<SingleStreamSpiller>();
        int numberOfSpills = 10;
        for (int i = 0; i < numberOfSpills; ++i) {
            SingleStreamSpiller singleStreamSpiller = spillerFactory.create((List)types, bytes -> {}, AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext("test"));
            Futures.getUnchecked((Future)singleStreamSpiller.spill(page));
            spillers.add(singleStreamSpiller);
        }
        Assert.assertEquals((int)MoreFiles.listFiles((Path)this.spillPath1.toPath()).size(), (int)0);
        Assert.assertEquals((int)MoreFiles.listFiles((Path)this.spillPath2.toPath()).size(), (int)numberOfSpills);
        spillers.forEach(SingleStreamSpiller::close);
        Assert.assertEquals((int)MoreFiles.listFiles((Path)this.spillPath1.toPath()).size(), (int)0);
        Assert.assertEquals((int)MoreFiles.listFiles((Path)this.spillPath2.toPath()).size(), (int)0);
    }

    private Page buildPage() {
        BlockBuilder col1 = BigintType.BIGINT.createBlockBuilder(null, 1);
        col1.writeLong(42L).closeEntry();
        return new Page(new Block[]{col1.build()});
    }

    @Test(expectedExceptions={RuntimeException.class}, expectedExceptionsMessageRegExp="No free or healthy space available for spill")
    public void throwsIfNoDiskSpace() {
        ImmutableList types = ImmutableList.of((Object)BigintType.BIGINT);
        ImmutableList spillPaths = ImmutableList.of((Object)this.spillPath1.toPath(), (Object)this.spillPath2.toPath());
        FileSingleStreamSpillerFactory spillerFactory = this.spillerFactoryFactory((List<Path>)spillPaths, 0.0);
        spillerFactory.create((List)types, bytes -> {}, AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext("test"));
    }

    @Test(expectedExceptions={RuntimeException.class}, expectedExceptionsMessageRegExp="No spill paths configured")
    public void throwIfNoSpillPaths() {
        List<Path> spillPaths = Collections.emptyList();
        ImmutableList types = ImmutableList.of((Object)BigintType.BIGINT);
        FileSingleStreamSpillerFactory spillerFactory = this.spillerFactoryFactory(spillPaths);
        spillerFactory.create((List)types, bytes -> {}, AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext("test"));
    }

    @Test
    public void testCleanupOldSpillFiles() throws Exception {
        ImmutableList spillPaths = ImmutableList.of((Object)this.spillPath1.toPath(), (Object)this.spillPath2.toPath());
        this.spillPath1.mkdirs();
        this.spillPath2.mkdirs();
        Files.createTempFile(this.spillPath1.toPath(), "spill", ".bin", new FileAttribute[0]);
        Files.createTempFile(this.spillPath1.toPath(), "spill", ".bin", new FileAttribute[0]);
        Files.createTempFile(this.spillPath1.toPath(), "spill", "blah", new FileAttribute[0]);
        Files.createTempFile(this.spillPath2.toPath(), "spill", ".bin", new FileAttribute[0]);
        Files.createTempFile(this.spillPath2.toPath(), "blah", ".bin", new FileAttribute[0]);
        Files.createTempFile(this.spillPath2.toPath(), "blah", "blah", new FileAttribute[0]);
        Assert.assertEquals((int)MoreFiles.listFiles((Path)this.spillPath1.toPath()).size(), (int)3);
        Assert.assertEquals((int)MoreFiles.listFiles((Path)this.spillPath2.toPath()).size(), (int)3);
        FileSingleStreamSpillerFactory spillerFactory = this.spillerFactoryFactory((List<Path>)spillPaths);
        spillerFactory.cleanupOldSpillFiles();
        Assert.assertEquals((int)MoreFiles.listFiles((Path)this.spillPath1.toPath()).size(), (int)1);
        Assert.assertEquals((int)MoreFiles.listFiles((Path)this.spillPath2.toPath()).size(), (int)2);
    }

    @Test
    public void testCacheInvalidatedOnBadDisk() throws Exception {
        ImmutableList types = ImmutableList.of((Object)BigintType.BIGINT);
        ImmutableList spillPaths = ImmutableList.of((Object)this.spillPath1.toPath(), (Object)this.spillPath2.toPath());
        FileSingleStreamSpillerFactory spillerFactory = this.spillerFactoryFactory((List<Path>)spillPaths);
        Assert.assertEquals((int)MoreFiles.listFiles((Path)this.spillPath1.toPath()).size(), (int)0);
        Assert.assertEquals((int)MoreFiles.listFiles((Path)this.spillPath2.toPath()).size(), (int)0);
        Page page = this.buildPage();
        ArrayList<SingleStreamSpiller> spillers = new ArrayList<SingleStreamSpiller>();
        SingleStreamSpiller singleStreamSpiller = spillerFactory.create((List)types, bytes -> {}, AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext("test"));
        Futures.getUnchecked((Future)singleStreamSpiller.spill(page));
        spillers.add(singleStreamSpiller);
        SingleStreamSpiller singleStreamSpiller2 = spillerFactory.create((List)types, bytes -> {}, AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext("test"));
        Files.setPosixFilePermissions(this.spillPath2.toPath(), (Set<PosixFilePermission>)ImmutableSet.of((Object)((Object)PosixFilePermission.OWNER_READ)));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Futures.getUnchecked((Future)singleStreamSpiller2.spill(page))).isInstanceOf(UncheckedExecutionException.class)).hasMessageContaining("Failed to spill pages");
        spillers.add(singleStreamSpiller2);
        Assert.assertEquals((long)spillerFactory.getSpillPathCacheSize(), (long)0L, (String)"cache still contains entries");
        Files.setPosixFilePermissions(this.spillPath2.toPath(), (Set<PosixFilePermission>)ImmutableSet.of((Object)((Object)PosixFilePermission.OWNER_READ), (Object)((Object)PosixFilePermission.OWNER_WRITE), (Object)((Object)PosixFilePermission.OWNER_EXECUTE)));
        spillers.forEach(SingleStreamSpiller::close);
        Assert.assertEquals((int)MoreFiles.listFiles((Path)this.spillPath1.toPath()).size(), (int)0);
        Assert.assertEquals((int)MoreFiles.listFiles((Path)this.spillPath2.toPath()).size(), (int)0);
    }

    @Test
    public void testCacheFull() throws Exception {
        ImmutableList types = ImmutableList.of((Object)BigintType.BIGINT);
        ImmutableList spillPaths = ImmutableList.of((Object)this.spillPath1.toPath(), (Object)this.spillPath2.toPath());
        FileSingleStreamSpillerFactory spillerFactory = this.spillerFactoryFactory((List<Path>)spillPaths);
        Assert.assertEquals((int)MoreFiles.listFiles((Path)this.spillPath1.toPath()).size(), (int)0);
        Assert.assertEquals((int)MoreFiles.listFiles((Path)this.spillPath2.toPath()).size(), (int)0);
        Page page = this.buildPage();
        ArrayList<SingleStreamSpiller> spillers = new ArrayList<SingleStreamSpiller>();
        SingleStreamSpiller singleStreamSpiller = spillerFactory.create((List)types, bytes -> {}, AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext("test"));
        Futures.getUnchecked((Future)singleStreamSpiller.spill(page));
        spillers.add(singleStreamSpiller);
        SingleStreamSpiller singleStreamSpiller2 = spillerFactory.create((List)types, bytes -> {}, AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext("test"));
        Futures.getUnchecked((Future)singleStreamSpiller2.spill(page));
        spillers.add(singleStreamSpiller2);
        Assert.assertEquals((long)spillerFactory.getSpillPathCacheSize(), (long)2L, (String)"cache contains no entries");
        spillers.forEach(SingleStreamSpiller::close);
        Assert.assertEquals((int)MoreFiles.listFiles((Path)this.spillPath1.toPath()).size(), (int)0);
        Assert.assertEquals((int)MoreFiles.listFiles((Path)this.spillPath2.toPath()).size(), (int)0);
    }

    private FileSingleStreamSpillerFactory spillerFactoryFactory(List<Path> paths) {
        return this.spillerFactoryFactory(paths, 1.0);
    }

    private FileSingleStreamSpillerFactory spillerFactoryFactory(List<Path> paths, Double maxUsedSpaceThreshold) {
        return new FileSingleStreamSpillerFactory(this.executor, this.blockEncodingSerde, new SpillerStats(), paths, maxUsedSpaceThreshold.doubleValue(), false, false);
    }
}

