/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.spi.connector.SortOrder;
import io.trino.sql.planner.RuleStatsRecorder;
import io.trino.sql.planner.assertions.BasePlanTest;
import io.trino.sql.planner.assertions.ExpectedValueProvider;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.IterativeOptimizer;
import io.trino.sql.planner.iterative.rule.RemoveRedundantIdentityProjections;
import io.trino.sql.planner.optimizations.PlanOptimizer;
import io.trino.sql.planner.optimizations.UnaliasSymbolReferences;
import io.trino.sql.planner.plan.WindowNode;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.GenericLiteral;
import io.trino.sql.tree.LongLiteral;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.testng.annotations.Test;

public class TestCanonicalize
extends BasePlanTest {
    @Test
    public void testJoin() {
        this.assertPlan("SELECT *\nFROM (\n    SELECT EXTRACT(DAY FROM DATE '2017-01-01')\n) t\nCROSS JOIN (VALUES 2)", PlanMatchPattern.anyTree(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"field", (Object)"expr"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new LongLiteral("2"), (Object)new GenericLiteral("BIGINT", "1"))))));
    }

    @Test
    public void testDuplicatesInWindowOrderBy() {
        ExpectedValueProvider<WindowNode.Specification> specification = PlanMatchPattern.specification((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"A"), (Map<String, SortOrder>)ImmutableMap.of((Object)"A", (Object)SortOrder.ASC_NULLS_LAST));
        this.assertPlan("WITH x as (SELECT a, a as b FROM (VALUES 1) t(a))SELECT *, row_number() OVER(ORDER BY a ASC, b DESC)FROM x", PlanMatchPattern.anyTree(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(specification).addFunction(PlanMatchPattern.functionCall("row_number", Optional.empty(), (List<String>)ImmutableList.of())), PlanMatchPattern.values("A"))), (List<PlanOptimizer>)ImmutableList.of((Object)new UnaliasSymbolReferences(this.getQueryRunner().getMetadata()), (Object)new IterativeOptimizer(this.getQueryRunner().getMetadata(), new RuleStatsRecorder(), this.getQueryRunner().getStatsCalculator(), this.getQueryRunner().getCostCalculator(), (Set)ImmutableSet.of((Object)new RemoveRedundantIdentityProjections()))));
    }
}

