/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.collect.ImmutableList;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataManager;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.planner.DeterminismEvaluator;
import io.trino.sql.planner.FunctionCallBuilder;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.NullLiteral;
import io.trino.sql.tree.QualifiedName;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDeterminismEvaluator {
    private final Metadata metadata = MetadataManager.createTestMetadataManager();

    @Test
    public void testSanity() {
        Assert.assertFalse((boolean)DeterminismEvaluator.isDeterministic((Expression)this.function("rand"), (Metadata)this.metadata));
        Assert.assertFalse((boolean)DeterminismEvaluator.isDeterministic((Expression)this.function("random"), (Metadata)this.metadata));
        Assert.assertFalse((boolean)DeterminismEvaluator.isDeterministic((Expression)this.function("shuffle", (List<Type>)ImmutableList.of((Object)new ArrayType((Type)VarcharType.VARCHAR)), (List<Expression>)ImmutableList.of((Object)new NullLiteral())), (Metadata)this.metadata));
        Assert.assertFalse((boolean)DeterminismEvaluator.isDeterministic((Expression)this.function("uuid"), (Metadata)this.metadata));
        Assert.assertTrue((boolean)DeterminismEvaluator.isDeterministic((Expression)this.function("abs", (List<Type>)ImmutableList.of((Object)DoubleType.DOUBLE), (List<Expression>)ImmutableList.of((Object)TestDeterminismEvaluator.input("symbol"))), (Metadata)this.metadata));
        Assert.assertFalse((boolean)DeterminismEvaluator.isDeterministic((Expression)this.function("abs", (List<Type>)ImmutableList.of((Object)DoubleType.DOUBLE), (List<Expression>)ImmutableList.of((Object)this.function("rand"))), (Metadata)this.metadata));
        Assert.assertTrue((boolean)DeterminismEvaluator.isDeterministic((Expression)this.function("abs", (List<Type>)ImmutableList.of((Object)DoubleType.DOUBLE), (List<Expression>)ImmutableList.of((Object)this.function("abs", (List<Type>)ImmutableList.of((Object)DoubleType.DOUBLE), (List<Expression>)ImmutableList.of((Object)TestDeterminismEvaluator.input("symbol"))))), (Metadata)this.metadata));
    }

    private FunctionCall function(String name) {
        return this.function(name, (List<Type>)ImmutableList.of(), (List<Expression>)ImmutableList.of());
    }

    private FunctionCall function(String name, List<Type> types, List<Expression> arguments) {
        return new FunctionCallBuilder(this.metadata).setName(QualifiedName.of((String)name)).setArguments(types, arguments).build();
    }

    private static Identifier input(String symbol) {
        return new Identifier(symbol);
    }
}

