/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import io.trino.Session;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataManager;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.parser.SqlParser;
import io.trino.sql.planner.ConnectorExpressionTranslator;
import io.trino.sql.planner.PartialTranslator;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.TypeAnalyzer;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.tree.ArithmeticBinaryExpression;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.LongLiteral;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.StringLiteral;
import io.trino.sql.tree.SubscriptExpression;
import io.trino.sql.tree.SymbolReference;
import io.trino.testing.TestingSession;
import io.trino.transaction.TransactionId;
import java.util.List;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestPartialTranslator {
    private static final Session TEST_SESSION = TestingSession.testSessionBuilder().setTransactionId(TransactionId.create()).build();
    private static final Metadata METADATA = MetadataManager.createTestMetadataManager();
    private static final TypeAnalyzer TYPE_ANALYZER = new TypeAnalyzer(new SqlParser(), METADATA);
    private static final TypeProvider TYPE_PROVIDER = TypeProvider.copyOf((Map)ImmutableMap.builder().put((Object)new Symbol("double_symbol_1"), (Object)DoubleType.DOUBLE).put((Object)new Symbol("double_symbol_2"), (Object)DoubleType.DOUBLE).put((Object)new Symbol("bigint_symbol_1"), (Object)BigintType.BIGINT).put((Object)new Symbol("row_symbol_1"), (Object)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"int_symbol_1", (Type)IntegerType.INTEGER), RowType.field((String)"varchar_symbol_1", (Type)VarcharType.createVarcharType((int)5))})).build());

    @Test
    public void testPartialTranslator() {
        SymbolReference rowSymbolReference = new SymbolReference("row_symbol_1");
        SubscriptExpression dereferenceExpression1 = new SubscriptExpression((Expression)rowSymbolReference, (Expression)new LongLiteral("1"));
        SubscriptExpression dereferenceExpression2 = new SubscriptExpression((Expression)rowSymbolReference, (Expression)new LongLiteral("2"));
        StringLiteral stringLiteral = new StringLiteral("abcd");
        SymbolReference symbolReference1 = new SymbolReference("double_symbol_1");
        this.assertFullTranslation((Expression)symbolReference1);
        this.assertFullTranslation((Expression)dereferenceExpression1);
        this.assertFullTranslation((Expression)stringLiteral);
        ArithmeticBinaryExpression binaryExpression = new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)symbolReference1, (Expression)dereferenceExpression1);
        this.assertPartialTranslation((Expression)binaryExpression, (List<Expression>)ImmutableList.of((Object)symbolReference1, (Object)dereferenceExpression1));
        ImmutableList functionArguments = ImmutableList.of((Object)stringLiteral, (Object)dereferenceExpression2);
        FunctionCall functionCallExpression = new FunctionCall(QualifiedName.of((String)"concat"), (List)functionArguments);
        this.assertPartialTranslation((Expression)functionCallExpression, (List<Expression>)functionArguments);
    }

    private void assertPartialTranslation(Expression expression, List<Expression> subexpressions) {
        Map translation = PartialTranslator.extractPartialTranslations((Expression)expression, (Session)TEST_SESSION, (TypeAnalyzer)TYPE_ANALYZER, (TypeProvider)TYPE_PROVIDER);
        Assert.assertEquals((int)subexpressions.size(), (int)translation.size());
        for (Expression subexpression : subexpressions) {
            Assert.assertEquals(translation.get(NodeRef.of((Node)subexpression)), ConnectorExpressionTranslator.translate((Session)TEST_SESSION, (Expression)subexpression, (TypeAnalyzer)TYPE_ANALYZER, (TypeProvider)TYPE_PROVIDER).get());
        }
    }

    private void assertFullTranslation(Expression expression) {
        Map translation = PartialTranslator.extractPartialTranslations((Expression)expression, (Session)TEST_SESSION, (TypeAnalyzer)TYPE_ANALYZER, (TypeProvider)TYPE_PROVIDER);
        Assert.assertEquals((Object)Iterables.getOnlyElement(translation.keySet()), (Object)NodeRef.of((Node)expression));
        Assert.assertEquals((Object)Iterables.getOnlyElement(translation.values()), ConnectorExpressionTranslator.translate((Session)TEST_SESSION, (Expression)expression, (TypeAnalyzer)TYPE_ANALYZER, (TypeProvider)TYPE_PROVIDER).get());
    }
}

