/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.metadata.AbstractMockMetadata;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.TestingColumnHandle;
import io.trino.sql.planner.PlanNodeIdAllocator;
import io.trino.sql.planner.SchedulingOrderVisitor;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.IndexJoinNode;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.TableScanNode;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestSchedulingOrderVisitor {
    @Test
    public void testJoinOrder() {
        PlanBuilder planBuilder = new PlanBuilder(new PlanNodeIdAllocator(), AbstractMockMetadata.dummyMetadata());
        TableScanNode a = planBuilder.tableScan(Collections.emptyList(), Collections.emptyMap());
        TableScanNode b = planBuilder.tableScan(Collections.emptyList(), Collections.emptyMap());
        List order = SchedulingOrderVisitor.scheduleOrder((PlanNode)planBuilder.join(JoinNode.Type.INNER, (PlanNode)a, (PlanNode)b, new JoinNode.EquiJoinClause[0]));
        Assert.assertEquals((Collection)order, (Collection)ImmutableList.of((Object)b.getId(), (Object)a.getId()));
    }

    @Test
    public void testIndexJoinOrder() {
        PlanBuilder planBuilder = new PlanBuilder(new PlanNodeIdAllocator(), AbstractMockMetadata.dummyMetadata());
        TableScanNode a = planBuilder.tableScan(Collections.emptyList(), Collections.emptyMap());
        TableScanNode b = planBuilder.tableScan(Collections.emptyList(), Collections.emptyMap());
        List order = SchedulingOrderVisitor.scheduleOrder((PlanNode)planBuilder.indexJoin(IndexJoinNode.Type.INNER, (PlanNode)a, (PlanNode)b));
        Assert.assertEquals((Collection)order, (Collection)ImmutableList.of((Object)b.getId(), (Object)a.getId()));
    }

    @Test
    public void testSemiJoinOrder() {
        PlanBuilder planBuilder = new PlanBuilder(new PlanNodeIdAllocator(), AbstractMockMetadata.dummyMetadata());
        Symbol sourceJoin = planBuilder.symbol("sourceJoin");
        TableScanNode a = planBuilder.tableScan((List<Symbol>)ImmutableList.of((Object)sourceJoin), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)sourceJoin, (Object)new TestingColumnHandle("sourceJoin")));
        Symbol filteringSource = planBuilder.symbol("filteringSource");
        TableScanNode b = planBuilder.tableScan((List<Symbol>)ImmutableList.of((Object)filteringSource), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)filteringSource, (Object)new TestingColumnHandle("filteringSource")));
        List order = SchedulingOrderVisitor.scheduleOrder((PlanNode)planBuilder.semiJoin(sourceJoin, filteringSource, planBuilder.symbol("semiJoinOutput"), Optional.empty(), Optional.empty(), (PlanNode)a, (PlanNode)b));
        Assert.assertEquals((Collection)order, (Collection)ImmutableList.of((Object)b.getId(), (Object)a.getId()));
    }
}

