/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.assertions;

import com.google.common.base.Preconditions;
import io.trino.Session;
import io.trino.metadata.Metadata;
import io.trino.metadata.ResolvedFunction;
import io.trino.sql.planner.OrderingScheme;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpectedValueProvider;
import io.trino.sql.planner.assertions.RvalueMatcher;
import io.trino.sql.planner.assertions.SymbolAliases;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.QualifiedName;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class AggregationFunctionMatcher
implements RvalueMatcher {
    private final ExpectedValueProvider<FunctionCall> callMaker;

    public AggregationFunctionMatcher(ExpectedValueProvider<FunctionCall> callMaker) {
        this.callMaker = Objects.requireNonNull(callMaker, "callMaker is null");
    }

    @Override
    public Optional<Symbol> getAssignedSymbol(PlanNode node, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Optional<Symbol> result = Optional.empty();
        if (!(node instanceof AggregationNode)) {
            return result;
        }
        AggregationNode aggregationNode = (AggregationNode)node;
        FunctionCall expectedCall = this.callMaker.getExpectedValue(symbolAliases);
        for (Map.Entry assignment : aggregationNode.getAggregations().entrySet()) {
            AggregationNode.Aggregation aggregation = (AggregationNode.Aggregation)assignment.getValue();
            if (!AggregationFunctionMatcher.aggregationMatches(aggregation, expectedCall)) continue;
            Preconditions.checkState((boolean)result.isEmpty(), (String)"Ambiguous function calls in %s", (Object)aggregationNode);
            result = Optional.of((Symbol)assignment.getKey());
        }
        return result;
    }

    private static boolean aggregationMatches(AggregationNode.Aggregation aggregation, FunctionCall expectedCall) {
        if (expectedCall.getWindow().isPresent()) {
            return false;
        }
        return Objects.equals(ResolvedFunction.extractFunctionName((QualifiedName)expectedCall.getName()), aggregation.getResolvedFunction().getSignature().getName()) && Objects.equals(expectedCall.getFilter(), aggregation.getFilter().map(Symbol::toSymbolReference)) && Objects.equals(expectedCall.getOrderBy().map(OrderingScheme::fromOrderBy), aggregation.getOrderingScheme()) && Objects.equals(expectedCall.isDistinct(), aggregation.isDistinct()) && Objects.equals(expectedCall.getArguments(), aggregation.getArguments());
    }

    public String toString() {
        return this.callMaker.toString();
    }
}

