/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.assertions;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.Session;
import io.trino.cost.StatsProvider;
import io.trino.metadata.Metadata;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.MatchResult;
import io.trino.sql.planner.assertions.Matcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.assertions.SymbolAliases;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.PlanNode;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class AggregationMatcher
implements Matcher {
    private final PlanMatchPattern.GroupingSetDescriptor groupingSets;
    private final List<String> masks;
    private final List<String> preGroupedSymbols;
    private final Optional<Symbol> groupId;
    private final AggregationNode.Step step;

    public AggregationMatcher(PlanMatchPattern.GroupingSetDescriptor groupingSets, List<String> preGroupedSymbols, List<String> masks, Optional<Symbol> groupId, AggregationNode.Step step) {
        this.groupingSets = groupingSets;
        this.masks = masks;
        this.preGroupedSymbols = preGroupedSymbols;
        this.groupId = groupId;
        this.step = step;
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        return node instanceof AggregationNode;
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Set expectedMasks;
        Preconditions.checkState((boolean)this.shapeMatches(node), (String)"Plan testing framework error: shapeMatches returned false in detailMatches in %s", (Object)this.getClass().getName());
        AggregationNode aggregationNode = (AggregationNode)node;
        if (this.groupId.isPresent() != aggregationNode.getGroupIdSymbol().isPresent()) {
            return MatchResult.NO_MATCH;
        }
        if (!AggregationMatcher.matches(this.groupingSets.getGroupingKeys(), aggregationNode.getGroupingKeys(), symbolAliases)) {
            return MatchResult.NO_MATCH;
        }
        if (this.groupingSets.getGroupingSetCount() != aggregationNode.getGroupingSetCount()) {
            return MatchResult.NO_MATCH;
        }
        if (!this.groupingSets.getGlobalGroupingSets().equals(aggregationNode.getGlobalGroupingSets())) {
            return MatchResult.NO_MATCH;
        }
        Set actualMasks = (Set)aggregationNode.getAggregations().values().stream().filter(aggregation -> aggregation.getMask().isPresent()).map(aggregation -> (Symbol)aggregation.getMask().get()).collect(ImmutableSet.toImmutableSet());
        if (!actualMasks.equals(expectedMasks = (Set)this.masks.stream().map(name -> new Symbol(symbolAliases.get((String)name).getName())).collect(ImmutableSet.toImmutableSet()))) {
            return MatchResult.NO_MATCH;
        }
        if (this.step != aggregationNode.getStep()) {
            return MatchResult.NO_MATCH;
        }
        if (!AggregationMatcher.matches(this.preGroupedSymbols, aggregationNode.getPreGroupedSymbols(), symbolAliases)) {
            return MatchResult.NO_MATCH;
        }
        if (!this.preGroupedSymbols.isEmpty() && !aggregationNode.isStreamable()) {
            return MatchResult.NO_MATCH;
        }
        return MatchResult.match();
    }

    static boolean matches(Collection<String> expectedAliases, Collection<Symbol> actualSymbols, SymbolAliases symbolAliases) {
        if (expectedAliases.size() != actualSymbols.size()) {
            return false;
        }
        List expectedSymbols = (List)expectedAliases.stream().map(alias -> new Symbol(symbolAliases.get((String)alias).getName())).collect(ImmutableList.toImmutableList());
        for (Symbol symbol : expectedSymbols) {
            if (actualSymbols.contains(symbol)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("groupingSets", (Object)this.groupingSets).add("preGroupedSymbols", this.preGroupedSymbols).add("masks", this.masks).add("groudId", this.groupId).add("step", (Object)this.step).toString();
    }
}

