/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.assertions;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.trino.Session;
import io.trino.cost.StatsProvider;
import io.trino.metadata.Metadata;
import io.trino.sql.planner.assertions.AggregationMatcher;
import io.trino.sql.planner.assertions.MatchResult;
import io.trino.sql.planner.assertions.Matcher;
import io.trino.sql.planner.assertions.SymbolAliases;
import io.trino.sql.planner.plan.GroupIdNode;
import io.trino.sql.planner.plan.PlanNode;
import java.util.Collection;
import java.util.List;

public class GroupIdMatcher
implements Matcher {
    private final List<List<String>> groupingSets;
    private final List<String> aggregationArguments;
    private final String groupIdSymbol;

    public GroupIdMatcher(List<List<String>> groupingSets, List<String> aggregationArguments, String groupIdSymbol) {
        this.groupingSets = groupingSets;
        this.aggregationArguments = aggregationArguments;
        this.groupIdSymbol = groupIdSymbol;
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        return node instanceof GroupIdNode;
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Preconditions.checkState((boolean)this.shapeMatches(node), (String)"Plan testing framework error: shapeMatches returned false in detailMatches in %s", (Object)this.getClass().getName());
        GroupIdNode groudIdNode = (GroupIdNode)node;
        List actualGroupingSets = groudIdNode.getGroupingSets();
        List actualAggregationArguments = groudIdNode.getAggregationArguments();
        if (actualGroupingSets.size() != this.groupingSets.size()) {
            return MatchResult.NO_MATCH;
        }
        for (int i = 0; i < actualGroupingSets.size(); ++i) {
            if (AggregationMatcher.matches((Collection<String>)this.groupingSets.get(i), (Collection)actualGroupingSets.get(i), symbolAliases)) continue;
            return MatchResult.NO_MATCH;
        }
        if (!AggregationMatcher.matches(this.aggregationArguments, actualAggregationArguments, symbolAliases)) {
            return MatchResult.NO_MATCH;
        }
        return MatchResult.match(this.groupIdSymbol, groudIdNode.getGroupIdSymbol().toSymbolReference());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("groupingSets", this.groupingSets).add("aggregationArguments", this.aggregationArguments).add("groupIdSymbol", (Object)this.groupIdSymbol).toString();
    }
}

