/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.assertions;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.connector.SortOrder;
import io.trino.sql.planner.OrderingScheme;
import io.trino.sql.planner.assertions.ExpectedValueProvider;
import io.trino.sql.planner.assertions.SymbolAlias;
import io.trino.sql.planner.assertions.SymbolAliases;
import io.trino.sql.planner.plan.WindowNode;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class SpecificationProvider
implements ExpectedValueProvider<WindowNode.Specification> {
    private final List<SymbolAlias> partitionBy;
    private final List<SymbolAlias> orderBy;
    private final Map<SymbolAlias, SortOrder> orderings;

    SpecificationProvider(List<SymbolAlias> partitionBy, List<SymbolAlias> orderBy, Map<SymbolAlias, SortOrder> orderings) {
        this.partitionBy = ImmutableList.copyOf((Collection)Objects.requireNonNull(partitionBy, "partitionBy is null"));
        this.orderBy = ImmutableList.copyOf((Collection)Objects.requireNonNull(orderBy, "orderBy is null"));
        this.orderings = ImmutableMap.copyOf(Objects.requireNonNull(orderings, "orderings is null"));
    }

    @Override
    public WindowNode.Specification getExpectedValue(SymbolAliases aliases) {
        Optional<Object> orderingScheme = Optional.empty();
        if (!this.orderBy.isEmpty()) {
            orderingScheme = Optional.of(new OrderingScheme((List)this.orderBy.stream().map(alias -> alias.toSymbol(aliases)).collect(ImmutableList.toImmutableList()), (Map)this.orderings.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> ((SymbolAlias)entry.getKey()).toSymbol(aliases), Map.Entry::getValue))));
        }
        return new WindowNode.Specification((List)this.partitionBy.stream().map(alias -> alias.toSymbol(aliases)).collect(ImmutableList.toImmutableList()), orderingScheme);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("partitionBy", this.partitionBy).add("orderBy", this.orderBy).add("orderings", this.orderings).toString();
    }
}

