/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.assertions;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.trino.Session;
import io.trino.cost.StatsProvider;
import io.trino.metadata.Metadata;
import io.trino.spi.connector.SortOrder;
import io.trino.sql.planner.assertions.ExpectedValueProvider;
import io.trino.sql.planner.assertions.MatchResult;
import io.trino.sql.planner.assertions.Matcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.assertions.SymbolAlias;
import io.trino.sql.planner.assertions.SymbolAliases;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.TopNRankingNode;
import io.trino.sql.planner.plan.WindowNode;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class TopNRankingMatcher
implements Matcher {
    private final Optional<ExpectedValueProvider<WindowNode.Specification>> specification;
    private final Optional<SymbolAlias> rankingSymbol;
    private final Optional<TopNRankingNode.RankingType> rankingType;
    private final Optional<Integer> maxRankingPerPartition;
    private final Optional<Boolean> partial;
    private final Optional<Optional<SymbolAlias>> hashSymbol;

    private TopNRankingMatcher(Optional<ExpectedValueProvider<WindowNode.Specification>> specification, Optional<SymbolAlias> rankingSymbol, Optional<TopNRankingNode.RankingType> rankingType, Optional<Integer> maxRankingPerPartition, Optional<Boolean> partial, Optional<Optional<SymbolAlias>> hashSymbol) {
        this.specification = Objects.requireNonNull(specification, "specification is null");
        this.rankingSymbol = Objects.requireNonNull(rankingSymbol, "rankingSymbol is null");
        this.rankingType = Objects.requireNonNull(rankingType, "rankingType is null");
        this.maxRankingPerPartition = Objects.requireNonNull(maxRankingPerPartition, "maxRankingPerPartition is null");
        this.partial = Objects.requireNonNull(partial, "partial is null");
        this.hashSymbol = Objects.requireNonNull(hashSymbol, "hashSymbol is null");
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        return node instanceof TopNRankingNode;
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Object expected;
        Preconditions.checkState((boolean)this.shapeMatches(node), (String)"Plan testing framework error: shapeMatches returned false in detailMatches in %s", (Object)this.getClass().getName());
        TopNRankingNode topNRankingNode = (TopNRankingNode)node;
        if (this.specification.isPresent() && !(expected = this.specification.get().getExpectedValue(symbolAliases)).equals((Object)topNRankingNode.getSpecification())) {
            return MatchResult.NO_MATCH;
        }
        if (this.rankingSymbol.isPresent() && !(expected = this.rankingSymbol.get().toSymbol(symbolAliases)).equals((Object)topNRankingNode.getRankingSymbol())) {
            return MatchResult.NO_MATCH;
        }
        if (this.rankingType.isPresent() && !this.rankingType.get().equals((Object)topNRankingNode.getRankingType())) {
            return MatchResult.NO_MATCH;
        }
        if (this.maxRankingPerPartition.isPresent() && !this.maxRankingPerPartition.get().equals(topNRankingNode.getMaxRankingPerPartition())) {
            return MatchResult.NO_MATCH;
        }
        if (this.partial.isPresent() && !this.partial.get().equals(topNRankingNode.isPartial())) {
            return MatchResult.NO_MATCH;
        }
        if (this.hashSymbol.isPresent() && !((Optional)(expected = this.hashSymbol.get().map(alias -> alias.toSymbol(symbolAliases)))).equals(topNRankingNode.getHashSymbol())) {
            return MatchResult.NO_MATCH;
        }
        return MatchResult.match();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("specification", this.specification).add("rankingSymbol", this.rankingSymbol).add("rankingType", this.rankingType).add("maxRankingPerPartition", this.maxRankingPerPartition).add("partial", this.partial).add("hashSymbol", this.hashSymbol).toString();
    }

    public static class Builder {
        private final PlanMatchPattern source;
        private Optional<ExpectedValueProvider<WindowNode.Specification>> specification = Optional.empty();
        private Optional<SymbolAlias> rankingSymbol = Optional.empty();
        private Optional<TopNRankingNode.RankingType> rankingType = Optional.empty();
        private Optional<Integer> maxRankingPerPartition = Optional.empty();
        private Optional<Boolean> partial = Optional.empty();
        private Optional<Optional<SymbolAlias>> hashSymbol = Optional.empty();

        Builder(PlanMatchPattern source) {
            this.source = Objects.requireNonNull(source, "source is null");
        }

        public Builder specification(List<String> partitionBy, List<String> orderBy, Map<String, SortOrder> orderings) {
            this.specification = Optional.of(PlanMatchPattern.specification(partitionBy, orderBy, orderings));
            return this;
        }

        public Builder rankingSymbol(SymbolAlias rankingSymbol) {
            this.rankingSymbol = Optional.of(Objects.requireNonNull(rankingSymbol, "rankingSymbol is null"));
            return this;
        }

        public Builder rankingType(TopNRankingNode.RankingType rankingType) {
            this.rankingType = Optional.of(Objects.requireNonNull(rankingType, "rankingType is null"));
            return this;
        }

        public Builder maxRankingPerPartition(int maxRankingPerPartition) {
            this.maxRankingPerPartition = Optional.of(maxRankingPerPartition);
            return this;
        }

        public Builder partial(boolean partial) {
            this.partial = Optional.of(partial);
            return this;
        }

        public Builder hashSymbol(Optional<SymbolAlias> hashSymbol) {
            this.hashSymbol = Optional.of(Objects.requireNonNull(hashSymbol, "hashSymbol is null"));
            return this;
        }

        PlanMatchPattern build() {
            return PlanMatchPattern.node(TopNRankingNode.class, this.source).with(new TopNRankingMatcher(this.specification, this.rankingSymbol, this.rankingType, this.maxRankingPerPartition, this.partial, this.hashSymbol));
        }
    }
}

