/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.testing.Closeables;
import io.trino.Session;
import io.trino.cost.PlanNodeStatsEstimate;
import io.trino.cost.SymbolStatsEstimate;
import io.trino.sql.planner.Partitioning;
import io.trino.sql.planner.PartitioningHandle;
import io.trino.sql.planner.PartitioningScheme;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SystemPartitioningHandle;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.DeterminePreferredWritePartitioning;
import io.trino.sql.planner.iterative.rule.test.RuleAssert;
import io.trino.sql.planner.iterative.rule.test.RuleTester;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.ValuesNode;
import io.trino.testing.TestingSession;
import java.io.Closeable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestDeterminePreferredWritePartitioning {
    private static final String MOCK_CATALOG = "mock_catalog";
    private static final String TEST_SCHEMA = "test_schema";
    private static final String NODE_ID = "mock";
    private static final double NO_STATS = -1.0;
    private static final Session SESSION_WITHOUT_PREFERRED_PARTITIONING = TestingSession.testSessionBuilder().setSystemProperty("use_preferred_write_partitioning", "false").setCatalog("mock_catalog").setSchema("test_schema").build();
    private static final Session SESSION_WITH_PREFERRED_PARTITIONING_THRESHOLD_0 = TestingSession.testSessionBuilder().setCatalog("mock_catalog").setSchema("test_schema").setSystemProperty("preferred_write_partitioning_min_number_of_partitions", "1").build();
    private static final Session SESSION_WITH_PREFERRED_PARTITIONING_DEFAULT_THRESHOLD = TestingSession.testSessionBuilder().setCatalog("mock_catalog").setSchema("test_schema").build();
    private static final PlanMatchPattern SUCCESSFUL_MATCH = PlanMatchPattern.tableWriter((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of(), PlanMatchPattern.values(0));
    private RuleTester tester;

    @BeforeClass
    public void setUp() {
        this.tester = RuleTester.defaultRuleTester();
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        Closeables.closeAllRuntimeException((Closeable[])new Closeable[]{this.tester});
        this.tester = null;
    }

    @Test(dataProvider="preferWritePartitioningDataProvider")
    public void testPreferWritePartitioning(Session session, double distinctValuesStat, boolean match) {
        RuleAssert ruleAssert = this.assertPreferredPartitioning(new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION, (List)ImmutableList.of((Object)new Symbol("col_one"))), (List)ImmutableList.of((Object)new Symbol("col_one")))).withSession(session);
        if (distinctValuesStat != -1.0) {
            ruleAssert = ruleAssert.overrideStats(NODE_ID, PlanNodeStatsEstimate.builder().addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("col_one"), (Object)new SymbolStatsEstimate(0.0, 0.0, 0.0, 0.0, distinctValuesStat))).build());
        }
        if (match) {
            ruleAssert.matches(SUCCESSFUL_MATCH);
        } else {
            ruleAssert.doesNotFire();
        }
    }

    @DataProvider(name="preferWritePartitioningDataProvider")
    public Object[][] preferWritePartitioningDataProvider() {
        return new Object[][]{{SESSION_WITHOUT_PREFERRED_PARTITIONING, -1.0, false}, {SESSION_WITHOUT_PREFERRED_PARTITIONING, Double.NaN, false}, {SESSION_WITHOUT_PREFERRED_PARTITIONING, 1, false}, {SESSION_WITHOUT_PREFERRED_PARTITIONING, 50, false}, {SESSION_WITH_PREFERRED_PARTITIONING_THRESHOLD_0, -1.0, true}, {SESSION_WITH_PREFERRED_PARTITIONING_THRESHOLD_0, Double.NaN, true}, {SESSION_WITH_PREFERRED_PARTITIONING_THRESHOLD_0, 1, true}, {SESSION_WITH_PREFERRED_PARTITIONING_THRESHOLD_0, 49, true}, {SESSION_WITH_PREFERRED_PARTITIONING_THRESHOLD_0, 50, true}, {SESSION_WITH_PREFERRED_PARTITIONING_DEFAULT_THRESHOLD, -1.0, false}, {SESSION_WITH_PREFERRED_PARTITIONING_DEFAULT_THRESHOLD, Double.NaN, false}, {SESSION_WITH_PREFERRED_PARTITIONING_DEFAULT_THRESHOLD, 1, false}, {SESSION_WITH_PREFERRED_PARTITIONING_DEFAULT_THRESHOLD, 49, false}, {SESSION_WITH_PREFERRED_PARTITIONING_DEFAULT_THRESHOLD, 50, true}};
    }

    @Test
    public void testThresholdWithNullFraction() {
        PlanNodeStatsEstimate stats = PlanNodeStatsEstimate.builder().addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("col_one"), (Object)new SymbolStatsEstimate(0.0, 0.0, 0.5, 0.0, 49.0))).build();
        this.assertPreferredPartitioning(new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION, (List)ImmutableList.of((Object)new Symbol("col_one"))), (List)ImmutableList.of((Object)new Symbol("col_one")))).withSession(SESSION_WITH_PREFERRED_PARTITIONING_DEFAULT_THRESHOLD).overrideStats(NODE_ID, stats).matches(SUCCESSFUL_MATCH);
    }

    @Test
    public void testThresholdWithMultiplePartitions() {
        PlanNodeStatsEstimate stats = PlanNodeStatsEstimate.builder().addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("col_one"), (Object)new SymbolStatsEstimate(0.0, 0.0, 0.0, 0.0, 5.0))).addSymbolStatistics((Map)ImmutableMap.of((Object)new Symbol("col_two"), (Object)new SymbolStatsEstimate(0.0, 0.0, 0.0, 0.0, 10.0))).build();
        this.assertPreferredPartitioning(new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION, (List)ImmutableList.of((Object)new Symbol("col_one"), (Object)new Symbol("col_two"))), (List)ImmutableList.of((Object)new Symbol("col_one"), (Object)new Symbol("col_two")))).withSession(SESSION_WITH_PREFERRED_PARTITIONING_DEFAULT_THRESHOLD).overrideStats(NODE_ID, stats).matches(SUCCESSFUL_MATCH);
    }

    private RuleAssert assertPreferredPartitioning(PartitioningScheme preferredPartitioningScheme) {
        return this.tester.assertThat((Rule<?>)new DeterminePreferredWritePartitioning()).on(builder -> builder.tableWriter((List<Symbol>)ImmutableList.of(), (List<String>)ImmutableList.of(), Optional.empty(), Optional.of(preferredPartitioningScheme), Optional.empty(), Optional.empty(), (PlanNode)new ValuesNode(new PlanNodeId(NODE_ID), 0)));
    }
}

