/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.metadata.Metadata;
import io.trino.spi.Plugin;
import io.trino.sql.parser.SqlParser;
import io.trino.sql.planner.PlanNodeIdAllocator;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.TypeAnalyzer;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.planner.assertions.ExpectedValueProvider;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.GroupReference;
import io.trino.sql.planner.iterative.Lookup;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.EliminateCrossJoins;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.optimizations.joins.JoinGraph;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.planner.plan.ValuesNode;
import io.trino.sql.tree.ArithmeticBinaryExpression;
import io.trino.sql.tree.ArithmeticUnaryExpression;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.SymbolReference;
import io.trino.testing.TestingSession;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestEliminateCrossJoins
extends BaseRuleTest {
    private final PlanNodeIdAllocator idAllocator = new PlanNodeIdAllocator();

    public TestEliminateCrossJoins() {
        super(new Plugin[0]);
    }

    @Test
    public void testEliminateCrossJoin() {
        this.tester().assertThat((Rule<?>)new EliminateCrossJoins(this.tester().getMetadata(), this.tester().getTypeAnalyzer())).setSystemProperty("join_reordering_strategy", "ELIMINATE_CROSS_JOINS").on(this.crossJoinAndJoin(JoinNode.Type.INNER)).matches(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(aliases -> new JoinNode.EquiJoinClause(new Symbol("cySymbol"), new Symbol("bySymbol"))), PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(aliases -> new JoinNode.EquiJoinClause(new Symbol("axSymbol"), new Symbol("cxSymbol"))), PlanMatchPattern.any(new PlanMatchPattern[0]), PlanMatchPattern.any(new PlanMatchPattern[0])), PlanMatchPattern.any(new PlanMatchPattern[0])));
    }

    @Test
    public void testRetainOutgoingGroupReferences() {
        this.tester().assertThat((Rule<?>)new EliminateCrossJoins(this.tester().getMetadata(), this.tester().getTypeAnalyzer())).setSystemProperty("join_reordering_strategy", "ELIMINATE_CROSS_JOINS").on(this.crossJoinAndJoin(JoinNode.Type.INNER)).matches(PlanMatchPattern.node(JoinNode.class, PlanMatchPattern.node(JoinNode.class, PlanMatchPattern.node(GroupReference.class, new PlanMatchPattern[0]), PlanMatchPattern.node(GroupReference.class, new PlanMatchPattern[0])), PlanMatchPattern.node(GroupReference.class, new PlanMatchPattern[0])));
    }

    @Test
    public void testDoNotReorderOuterJoin() {
        this.tester().assertThat((Rule<?>)new EliminateCrossJoins(this.tester().getMetadata(), this.tester().getTypeAnalyzer())).setSystemProperty("join_reordering_strategy", "ELIMINATE_CROSS_JOINS").on(this.crossJoinAndJoin(JoinNode.Type.LEFT)).doesNotFire();
    }

    @Test
    public void testIsOriginalOrder() {
        Assert.assertTrue((boolean)EliminateCrossJoins.isOriginalOrder((List)ImmutableList.of((Object)0, (Object)1, (Object)2, (Object)3, (Object)4)));
        Assert.assertFalse((boolean)EliminateCrossJoins.isOriginalOrder((List)ImmutableList.of((Object)0, (Object)2, (Object)1, (Object)3, (Object)4)));
    }

    @Test
    public void testJoinOrder() {
        Session session = TestingSession.testSessionBuilder().build();
        JoinNode plan = this.joinNode((PlanNode)this.joinNode((PlanNode)this.values("a"), (PlanNode)this.values("b"), new String[0]), (PlanNode)this.values("c"), "a", "c", "b", "c");
        JoinGraph joinGraph = JoinGraph.buildFrom((Metadata)this.tester().getMetadata(), (PlanNode)plan, (Lookup)Lookup.noLookup(), (PlanNodeIdAllocator)new PlanNodeIdAllocator(), (Session)session, (TypeAnalyzer)new TypeAnalyzer(new SqlParser(), this.tester().getMetadata()), (TypeProvider)TypeProvider.empty());
        Assert.assertEquals((Collection)EliminateCrossJoins.getJoinOrder((JoinGraph)joinGraph), (Collection)ImmutableList.of((Object)0, (Object)2, (Object)1));
    }

    @Test
    public void testJoinOrderWithRealCrossJoin() {
        Session session = TestingSession.testSessionBuilder().build();
        JoinNode leftPlan = this.joinNode((PlanNode)this.joinNode((PlanNode)this.values("a"), (PlanNode)this.values("b"), new String[0]), (PlanNode)this.values("c"), "a", "c", "b", "c");
        JoinNode rightPlan = this.joinNode((PlanNode)this.joinNode((PlanNode)this.values("x"), (PlanNode)this.values("y"), new String[0]), (PlanNode)this.values("z"), "x", "z", "y", "z");
        JoinNode plan = this.joinNode((PlanNode)leftPlan, (PlanNode)rightPlan, new String[0]);
        JoinGraph joinGraph = JoinGraph.buildFrom((Metadata)this.tester().getMetadata(), (PlanNode)plan, (Lookup)Lookup.noLookup(), (PlanNodeIdAllocator)new PlanNodeIdAllocator(), (Session)session, (TypeAnalyzer)new TypeAnalyzer(new SqlParser(), this.tester().getMetadata()), (TypeProvider)TypeProvider.empty());
        Assert.assertEquals((Collection)EliminateCrossJoins.getJoinOrder((JoinGraph)joinGraph), (Collection)ImmutableList.of((Object)0, (Object)2, (Object)1, (Object)3, (Object)5, (Object)4));
    }

    @Test
    public void testJoinOrderWithMultipleEdgesBetweenNodes() {
        Session session = TestingSession.testSessionBuilder().build();
        JoinNode plan = this.joinNode((PlanNode)this.joinNode((PlanNode)this.values("a"), (PlanNode)this.values("b1", "b2"), new String[0]), (PlanNode)this.values("c1", "c2"), "a", "c1", "b1", "c1", "b2", "c2");
        JoinGraph joinGraph = JoinGraph.buildFrom((Metadata)this.tester().getMetadata(), (PlanNode)plan, (Lookup)Lookup.noLookup(), (PlanNodeIdAllocator)new PlanNodeIdAllocator(), (Session)session, (TypeAnalyzer)new TypeAnalyzer(new SqlParser(), this.tester().getMetadata()), (TypeProvider)TypeProvider.empty());
        Assert.assertEquals((Collection)EliminateCrossJoins.getJoinOrder((JoinGraph)joinGraph), (Collection)ImmutableList.of((Object)0, (Object)2, (Object)1));
    }

    @Test
    public void testDoesNotChangeOrderWithoutCrossJoin() {
        Session session = TestingSession.testSessionBuilder().build();
        JoinNode plan = this.joinNode((PlanNode)this.joinNode((PlanNode)this.values("a"), (PlanNode)this.values("b"), "a", "b"), (PlanNode)this.values("c"), "b", "c");
        JoinGraph joinGraph = JoinGraph.buildFrom((Metadata)this.tester().getMetadata(), (PlanNode)plan, (Lookup)Lookup.noLookup(), (PlanNodeIdAllocator)new PlanNodeIdAllocator(), (Session)session, (TypeAnalyzer)new TypeAnalyzer(new SqlParser(), this.tester().getMetadata()), (TypeProvider)TypeProvider.empty());
        Assert.assertEquals((Collection)EliminateCrossJoins.getJoinOrder((JoinGraph)joinGraph), (Collection)ImmutableList.of((Object)0, (Object)1, (Object)2));
    }

    @Test
    public void testDoNotReorderCrossJoins() {
        Session session = TestingSession.testSessionBuilder().build();
        JoinNode plan = this.joinNode((PlanNode)this.joinNode((PlanNode)this.values("a"), (PlanNode)this.values("b"), new String[0]), (PlanNode)this.values("c"), "b", "c");
        JoinGraph joinGraph = JoinGraph.buildFrom((Metadata)this.tester().getMetadata(), (PlanNode)plan, (Lookup)Lookup.noLookup(), (PlanNodeIdAllocator)new PlanNodeIdAllocator(), (Session)session, (TypeAnalyzer)new TypeAnalyzer(new SqlParser(), this.tester().getMetadata()), (TypeProvider)TypeProvider.empty());
        Assert.assertEquals((Collection)EliminateCrossJoins.getJoinOrder((JoinGraph)joinGraph), (Collection)ImmutableList.of((Object)0, (Object)1, (Object)2));
    }

    @Test
    public void testEliminateCrossJoinWithNonIdentityProjections() {
        this.tester().assertThat((Rule<?>)new EliminateCrossJoins(this.tester().getMetadata(), this.tester().getTypeAnalyzer())).setSystemProperty("join_reordering_strategy", "ELIMINATE_CROSS_JOINS").on(p -> {
            Symbol a1 = p.symbol("a1");
            Symbol a2 = p.symbol("a2");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            Symbol d = p.symbol("d");
            Symbol e = p.symbol("e");
            Symbol f = p.symbol("f");
            return p.join(JoinNode.Type.INNER, (PlanNode)p.project(Assignments.of((Symbol)a2, (Expression)new ArithmeticUnaryExpression(ArithmeticUnaryExpression.Sign.MINUS, (Expression)new SymbolReference("a1")), (Symbol)f, (Expression)new SymbolReference("f")), (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.project(Assignments.of((Symbol)a1, (Expression)new SymbolReference("a1"), (Symbol)f, (Expression)new ArithmeticUnaryExpression(ArithmeticUnaryExpression.Sign.MINUS, (Expression)new SymbolReference("b"))), (PlanNode)p.join(JoinNode.Type.INNER, (PlanNode)p.values(a1), (PlanNode)p.values(b), new JoinNode.EquiJoinClause[0])), (PlanNode)p.values(e), new JoinNode.EquiJoinClause(a1, e))), (PlanNode)p.values(c, d), new JoinNode.EquiJoinClause(a2, c), new JoinNode.EquiJoinClause(f, d));
        }).matches(PlanMatchPattern.node(ProjectNode.class, PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(aliases -> new JoinNode.EquiJoinClause(new Symbol("d"), new Symbol("f"))), PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(aliases -> new JoinNode.EquiJoinClause(new Symbol("a2"), new Symbol("c"))), PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(aliases -> new JoinNode.EquiJoinClause(new Symbol("a1"), new Symbol("e"))), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a2", (Object)PlanMatchPattern.expression("-a1"), (Object)"a1", (Object)PlanMatchPattern.expression("a1")), PlanMatchPattern.values("a1")), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"e", (Object)PlanMatchPattern.expression("e")), PlanMatchPattern.values("e"))), PlanMatchPattern.any(new PlanMatchPattern[0])), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"f", (Object)PlanMatchPattern.expression("-b")), PlanMatchPattern.values("b")))));
    }

    @Test
    public void testGiveUpOnComplexProjections() {
        Session session = TestingSession.testSessionBuilder().build();
        JoinNode plan = this.joinNode(this.projectNode((PlanNode)this.joinNode((PlanNode)this.values("a1"), (PlanNode)this.values("b"), new String[0]), "a2", (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("a1"), (Expression)new SymbolReference("b")), "b", (Expression)new SymbolReference("b")), (PlanNode)this.values("c"), "a2", "c", "b", "c");
        Assert.assertEquals((int)JoinGraph.buildFrom((Metadata)this.tester().getMetadata(), (PlanNode)plan, (Lookup)Lookup.noLookup(), (PlanNodeIdAllocator)new PlanNodeIdAllocator(), (Session)session, (TypeAnalyzer)new TypeAnalyzer(new SqlParser(), this.tester().getMetadata()), (TypeProvider)TypeProvider.empty()).size(), (int)2);
    }

    private Function<PlanBuilder, PlanNode> crossJoinAndJoin(JoinNode.Type secondJoinType) {
        return p -> {
            Symbol axSymbol = p.symbol("axSymbol");
            Symbol bySymbol = p.symbol("bySymbol");
            Symbol cxSymbol = p.symbol("cxSymbol");
            Symbol cySymbol = p.symbol("cySymbol");
            return p.join(JoinNode.Type.INNER, (PlanNode)p.join(secondJoinType, (PlanNode)p.values(axSymbol), (PlanNode)p.values(bySymbol), new JoinNode.EquiJoinClause[0]), (PlanNode)p.values(cxSymbol, cySymbol), new JoinNode.EquiJoinClause(axSymbol, cxSymbol), new JoinNode.EquiJoinClause(bySymbol, cySymbol));
        };
    }

    private PlanNode projectNode(PlanNode source, String symbol1, Expression expression1, String symbol2, Expression expression2) {
        return new ProjectNode(this.idAllocator.getNextId(), source, Assignments.of((Symbol)new Symbol(symbol1), (Expression)expression1, (Symbol)new Symbol(symbol2), (Expression)expression2));
    }

    private JoinNode joinNode(PlanNode left, PlanNode right, String ... symbols) {
        Preconditions.checkArgument((symbols.length % 2 == 0 ? 1 : 0) != 0);
        ImmutableList.Builder criteria = ImmutableList.builder();
        for (int i = 0; i < symbols.length; i += 2) {
            criteria.add((Object)new JoinNode.EquiJoinClause(new Symbol(symbols[i]), new Symbol(symbols[i + 1])));
        }
        return new JoinNode(this.idAllocator.getNextId(), JoinNode.Type.INNER, left, right, (List)criteria.build(), left.getOutputSymbols(), right.getOutputSymbols(), false, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), (Map)ImmutableMap.of(), Optional.empty());
    }

    private ValuesNode values(String ... symbols) {
        return new ValuesNode(this.idAllocator.getNextId(), (List)Arrays.stream(symbols).map(Symbol::new).collect(ImmutableList.toImmutableList()), (List)ImmutableList.of());
    }
}

