/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.connector.CatalogName;
import io.trino.connector.MockConnectorFactory;
import io.trino.connector.MockConnectorTableHandle;
import io.trino.cost.PlanNodeStatsEstimate;
import io.trino.cost.ScalarStatsCalculator;
import io.trino.cost.SymbolStatsEstimate;
import io.trino.metadata.Metadata;
import io.trino.metadata.TableHandle;
import io.trino.plugin.tpch.TpchColumnHandle;
import io.trino.spi.connector.Assignment;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.connector.ConnectorPartitioningHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTablePartitioning;
import io.trino.spi.connector.ConnectorTableProperties;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.ProjectionApplicationResult;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.expression.Constant;
import io.trino.spi.expression.FieldDereference;
import io.trino.spi.expression.Variable;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.parser.SqlParser;
import io.trino.sql.planner.ConnectorExpressionTranslator;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.TypeAnalyzer;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PushProjectionIntoTableScan;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.iterative.rule.test.RuleTester;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.LongLiteral;
import io.trino.sql.tree.SubscriptExpression;
import io.trino.sql.tree.SymbolReference;
import io.trino.testing.TestingSession;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestPushProjectionIntoTableScan {
    private static final String MOCK_CATALOG = "mock_catalog";
    private static final String TEST_SCHEMA = "test_schema";
    private static final String TEST_TABLE = "test_table";
    private static final SchemaTableName TEST_SCHEMA_TABLE = new SchemaTableName("test_schema", "test_table");
    private static final Type ROW_TYPE = RowType.from(Arrays.asList(RowType.field((String)"a", (Type)BigintType.BIGINT), RowType.field((String)"b", (Type)BigintType.BIGINT)));
    private static final TableHandle TEST_TABLE_HANDLE = TestPushProjectionIntoTableScan.createTableHandle("test_schema", "test_table");
    private static final ConnectorPartitioningHandle PARTITIONING_HANDLE = new ConnectorPartitioningHandle(){};
    private static final Session MOCK_SESSION = TestingSession.testSessionBuilder().setCatalog("mock_catalog").setSchema("test_schema").build();

    @Test
    public void testDoesNotFire() {
        try (RuleTester ruleTester = RuleTester.defaultRuleTester();){
            String columnName = "input_column";
            Type columnType = ROW_TYPE;
            ColumnHandle inputColumnHandle = TestPushProjectionIntoTableScan.column(columnName, columnType);
            MockConnectorFactory factory = this.createMockFactory((Map<String, ColumnHandle>)ImmutableMap.of((Object)columnName, (Object)inputColumnHandle), Optional.empty());
            ruleTester.getQueryRunner().createCatalog(MOCK_CATALOG, (ConnectorFactory)factory, (Map)ImmutableMap.of());
            PushProjectionIntoTableScan optimizer = TestPushProjectionIntoTableScan.createRule(ruleTester);
            ruleTester.assertThat((Rule<?>)optimizer).on(p -> {
                Symbol symbol = p.symbol(columnName, columnType);
                return p.project(Assignments.of((Symbol)p.symbol("symbol_dereference", (Type)BigintType.BIGINT), (Expression)new SubscriptExpression((Expression)symbol.toSymbolReference(), (Expression)new LongLiteral("1"))), (PlanNode)p.tableScan(TEST_TABLE_HANDLE, (List<Symbol>)ImmutableList.of((Object)symbol), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)symbol, (Object)inputColumnHandle)));
            }).withSession(MOCK_SESSION).doesNotFire();
        }
    }

    @Test
    public void testPushProjection() {
        try (RuleTester ruleTester = RuleTester.defaultRuleTester();){
            String columnName = "col0";
            Type columnType = ROW_TYPE;
            Symbol baseColumn = new Symbol(columnName);
            TpchColumnHandle columnHandle = new TpchColumnHandle(columnName, columnType);
            MockConnectorFactory factory = this.createMockFactory((Map<String, ColumnHandle>)ImmutableMap.of((Object)columnName, (Object)columnHandle), Optional.of(this::mockApplyProjection));
            ruleTester.getQueryRunner().createCatalog(MOCK_CATALOG, (ConnectorFactory)factory, (Map)ImmutableMap.of());
            TypeAnalyzer typeAnalyzer = new TypeAnalyzer(new SqlParser(), ruleTester.getMetadata());
            Symbol identity = new Symbol("symbol_identity");
            Symbol dereference = new Symbol("symbol_dereference");
            Symbol constant = new Symbol("symbol_constant");
            ImmutableMap types = ImmutableMap.of((Object)baseColumn, (Object)ROW_TYPE, (Object)identity, (Object)ROW_TYPE, (Object)dereference, (Object)BigintType.BIGINT, (Object)constant, (Object)BigintType.BIGINT);
            ImmutableMap inputProjections = ImmutableMap.of((Object)identity, (Object)baseColumn.toSymbolReference(), (Object)dereference, (Object)new SubscriptExpression((Expression)baseColumn.toSymbolReference(), (Expression)new LongLiteral("1")), (Object)constant, (Object)new LongLiteral("5"));
            ImmutableMap connectorNames = (ImmutableMap)inputProjections.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, e -> ((ConnectorExpression)ConnectorExpressionTranslator.translate((Session)MOCK_SESSION, (Expression)((Expression)e.getValue()), (TypeAnalyzer)typeAnalyzer, (TypeProvider)TypeProvider.viewOf((Map)types)).get()).toString()));
            ImmutableMap newNames = ImmutableMap.of((Object)identity, (Object)("projected_variable_" + (String)connectorNames.get((Object)identity)), (Object)dereference, (Object)("projected_dereference_" + (String)connectorNames.get((Object)dereference)), (Object)constant, (Object)("projected_constant_" + (String)connectorNames.get((Object)constant)));
            Map expectedColumns = (Map)newNames.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getValue, e -> TestPushProjectionIntoTableScan.column((String)e.getValue(), (Type)types.get(e.getKey()))));
            ruleTester.assertThat((Rule<?>)TestPushProjectionIntoTableScan.createRule(ruleTester)).on(arg_0 -> TestPushProjectionIntoTableScan.lambda$testPushProjection$4(columnName, columnType, identity, types, dereference, constant, inputProjections, (ColumnHandle)columnHandle, arg_0)).withSession(MOCK_SESSION).matches(PlanMatchPattern.project((Map)newNames.entrySet().stream().collect(ImmutableMap.toImmutableMap(e -> ((Symbol)e.getKey()).getName(), e -> PlanMatchPattern.expression((Expression)TestPushProjectionIntoTableScan.symbolReference((String)e.getValue())))), PlanMatchPattern.tableScan(new MockConnectorTableHandle(new SchemaTableName(TEST_SCHEMA, "projected_test_table"), (TupleDomain<ColumnHandle>)TupleDomain.all(), Optional.of(ImmutableList.copyOf(expectedColumns.values())))::equals, (TupleDomain<Predicate<ColumnHandle>>)TupleDomain.all(), (Map)expectedColumns.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, e -> arg_0 -> ((ColumnHandle)((ColumnHandle)e.getValue())).equals(arg_0))), Optional.of(PlanNodeStatsEstimate.builder().setOutputRowCount(42.0).addSymbolStatistics(new Symbol((String)newNames.get((Object)constant)), SymbolStatsEstimate.builder().setDistinctValuesCount(1.0).setNullsFraction(0.0).setLowValue(5.0).setHighValue(5.0).build()).addSymbolStatistics(new Symbol((String)newNames.get((Object)identity)), SymbolStatsEstimate.builder().setDistinctValuesCount(33.0).setNullsFraction(0.0).build()).addSymbolStatistics(new Symbol((String)newNames.get((Object)dereference)), SymbolStatsEstimate.unknown()).build())::equals)));
        }
    }

    @Test
    public void testPartitioningChanged() {
        try (RuleTester ruleTester = RuleTester.defaultRuleTester();){
            String columnName = "col0";
            TpchColumnHandle columnHandle = new TpchColumnHandle(columnName, (Type)VarcharType.VARCHAR);
            MockConnectorFactory factory = this.createMockFactory((Map<String, ColumnHandle>)ImmutableMap.of((Object)columnName, (Object)columnHandle), Optional.of(this::mockApplyProjection));
            ruleTester.getQueryRunner().createCatalog(MOCK_CATALOG, (ConnectorFactory)factory, (Map)ImmutableMap.of());
            Assertions.assertThatThrownBy(() -> TestPushProjectionIntoTableScan.lambda$testPartitioningChanged$9(ruleTester, (ColumnHandle)columnHandle)).hasMessage("Partitioning must not change after projection is pushed down");
        }
    }

    private MockConnectorFactory createMockFactory(Map<String, ColumnHandle> assignments, Optional<MockConnectorFactory.ApplyProjection> applyProjection) {
        List metadata = (List)assignments.entrySet().stream().map(entry -> new ColumnMetadata((String)entry.getKey(), ((TpchColumnHandle)entry.getValue()).getType())).collect(ImmutableList.toImmutableList());
        MockConnectorFactory.Builder builder = MockConnectorFactory.builder().withListSchemaNames(connectorSession -> ImmutableList.of((Object)TEST_SCHEMA)).withListTables((connectorSession, schema) -> TEST_SCHEMA.equals(schema) ? ImmutableList.of((Object)TEST_SCHEMA_TABLE) : ImmutableList.of()).withGetColumns(schemaTableName -> metadata).withGetTableProperties((session, tableHandle) -> {
            MockConnectorTableHandle mockTableHandle = (MockConnectorTableHandle)tableHandle;
            if (mockTableHandle.getTableName().getTableName().equals(TEST_TABLE)) {
                return new ConnectorTableProperties(TupleDomain.all(), Optional.of(new ConnectorTablePartitioning(PARTITIONING_HANDLE, (List)ImmutableList.of((Object)TestPushProjectionIntoTableScan.column("col", (Type)VarcharType.VARCHAR)))), Optional.empty(), Optional.empty(), (List)ImmutableList.of());
            }
            return new ConnectorTableProperties();
        });
        if (applyProjection.isPresent()) {
            builder = builder.withApplyProjection(applyProjection.get());
        }
        return builder.build();
    }

    private Optional<ProjectionApplicationResult<ConnectorTableHandle>> mockApplyProjection(ConnectorSession session, ConnectorTableHandle tableHandle, List<ConnectorExpression> projections, Map<String, ColumnHandle> assignments) {
        SchemaTableName inputSchemaTableName = ((MockConnectorTableHandle)tableHandle).getTableName();
        SchemaTableName projectedTableName = new SchemaTableName(inputSchemaTableName.getSchemaName(), "projected_" + inputSchemaTableName.getTableName());
        ImmutableList.Builder outputExpressions = ImmutableList.builder();
        ImmutableList.Builder outputAssignments = ImmutableList.builder();
        ImmutableList.Builder projectedColumnsBuilder = ImmutableList.builder();
        for (ConnectorExpression projection : projections) {
            String variablePrefix;
            if (projection instanceof Variable) {
                variablePrefix = "projected_variable_";
            } else if (projection instanceof FieldDereference) {
                variablePrefix = "projected_dereference_";
            } else if (projection instanceof Constant) {
                variablePrefix = "projected_constant_";
            } else {
                throw new UnsupportedOperationException();
            }
            String newVariableName = variablePrefix + projection.toString();
            Variable newVariable = new Variable(newVariableName, projection.getType());
            TpchColumnHandle newColumnHandle = new TpchColumnHandle(newVariableName, projection.getType());
            outputExpressions.add((Object)newVariable);
            outputAssignments.add((Object)new Assignment(newVariableName, (ColumnHandle)newColumnHandle, projection.getType()));
            projectedColumnsBuilder.add((Object)newColumnHandle);
        }
        return Optional.of(new ProjectionApplicationResult((Object)new MockConnectorTableHandle(projectedTableName, (TupleDomain<ColumnHandle>)TupleDomain.all(), Optional.of(projectedColumnsBuilder.build())), (List)outputExpressions.build(), (List)outputAssignments.build(), false));
    }

    private static PushProjectionIntoTableScan createRule(RuleTester tester) {
        Metadata metadata = tester.getMetadata();
        TypeAnalyzer typeAnalyzer = tester.getTypeAnalyzer();
        return new PushProjectionIntoTableScan(metadata, typeAnalyzer, new ScalarStatsCalculator(metadata, typeAnalyzer));
    }

    private static TableHandle createTableHandle(String schemaName, String tableName) {
        return new TableHandle(new CatalogName(MOCK_CATALOG), (ConnectorTableHandle)new MockConnectorTableHandle(new SchemaTableName(schemaName, tableName)), new ConnectorTransactionHandle(){}, Optional.empty());
    }

    private static SymbolReference symbolReference(String name) {
        return new SymbolReference(name);
    }

    private static ColumnHandle column(String name, Type type) {
        return new TpchColumnHandle(name, type);
    }

    private static /* synthetic */ void lambda$testPartitioningChanged$9(RuleTester ruleTester, ColumnHandle columnHandle) throws Throwable {
        ruleTester.assertThat((Rule<?>)TestPushProjectionIntoTableScan.createRule(ruleTester)).on(p -> p.project(Assignments.of(), (PlanNode)p.tableScan(TEST_TABLE_HANDLE, (List<Symbol>)ImmutableList.of((Object)p.symbol("col", (Type)VarcharType.VARCHAR)), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol("col", (Type)VarcharType.VARCHAR), (Object)columnHandle), Optional.of(true)))).withSession(MOCK_SESSION).matches(PlanMatchPattern.anyTree(new PlanMatchPattern[0]));
    }

    private static /* synthetic */ PlanNode lambda$testPushProjection$4(String columnName, Type columnType, Symbol identity, ImmutableMap types, Symbol dereference, Symbol constant, ImmutableMap inputProjections, ColumnHandle columnHandle, PlanBuilder p) {
        Symbol columnSymbol = p.symbol(columnName, columnType);
        p.symbol(identity.getName(), (Type)types.get((Object)identity));
        p.symbol(dereference.getName(), (Type)types.get((Object)dereference));
        p.symbol(constant.getName(), (Type)types.get((Object)constant));
        return p.project(new Assignments((Map)inputProjections), (PlanNode)p.tableScan(tableScan -> tableScan.setTableHandle(TEST_TABLE_HANDLE).setSymbols((List<Symbol>)ImmutableList.of((Object)columnSymbol)).setAssignments((Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)columnSymbol, (Object)columnHandle)).setStatistics(Optional.of(PlanNodeStatsEstimate.builder().setOutputRowCount(42.0).addSymbolStatistics(columnSymbol, SymbolStatsEstimate.builder().setNullsFraction(0.0).setDistinctValuesCount(33.0).build()).build()))));
    }
}

