/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import io.trino.spi.Plugin;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.rule.UnwrapRowSubscript;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.PlanNode;
import java.util.Map;
import org.intellij.lang.annotations.Language;
import org.testng.annotations.Test;

public class TestUnwrapRowSubscript
extends BaseRuleTest {
    public TestUnwrapRowSubscript() {
        super(new Plugin[0]);
    }

    @Test
    public void testSimpleSubscript() {
        this.test("ROW(1)[1]", "1");
        this.test("ROW(1, 2)[1]", "1");
        this.test("ROW(ROW(1, 2), 3)[1][2]", "2");
    }

    @Test
    public void testWithCast() {
        this.test("CAST(ROW(1, 2) AS row(a bigint, b bigint))[1]", "CAST(1 AS bigint)");
        this.test("CAST(ROW(1, 2) AS row(bigint, bigint))[1]", "CAST(1 AS bigint)");
        this.test("CAST(CAST(ROW(ROW(1, 2), 3) AS row(row(smallint, smallint), bigint))[1] AS ROW(x bigint, y bigint))[2]", "CAST(CAST(2 AS smallint) AS bigint)");
    }

    @Test
    public void testWithTryCast() {
        this.test("TRY_CAST(ROW(1, 2) AS row(a bigint, b bigint))[1]", "TRY_CAST(1 AS bigint)");
        this.test("TRY_CAST(ROW(1, 2) AS row(bigint, bigint))[1]", "TRY_CAST(1 AS bigint)");
        this.test("TRY_CAST(TRY_CAST(ROW(ROW(1, 2), 3) AS row(row(smallint, smallint), bigint))[1] AS ROW(x bigint, y bigint))[2]", "TRY_CAST(TRY_CAST(2 AS smallint) AS bigint)");
    }

    private void test(@Language(value="SQL") String original, @Language(value="SQL") String unwrapped) {
        this.tester().assertThat(new UnwrapRowSubscript().projectExpressionRewrite()).on(p -> p.project(Assignments.builder().put(p.symbol("output"), PlanBuilder.expression(original)).build(), (PlanNode)p.values(new Symbol[0]))).matches(PlanMatchPattern.project(Map.of("output", PlanMatchPattern.expression(unwrapped)), PlanMatchPattern.values(new String[0])));
    }
}

