/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule.test;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.analyzer.ExpressionTreeUtils;
import io.trino.sql.parser.ParsingOptions;
import io.trino.sql.parser.SqlParser;
import io.trino.sql.planner.OrderingScheme;
import io.trino.sql.planner.PlanNodeIdAllocator;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolAllocator;
import io.trino.sql.planner.plan.PatternRecognitionNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.WindowNode;
import io.trino.sql.planner.rowpattern.LogicalIndexExtractor;
import io.trino.sql.planner.rowpattern.ir.IrLabel;
import io.trino.sql.planner.rowpattern.ir.IrRowPattern;
import io.trino.sql.tree.DereferenceExpression;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.ExpressionRewriter;
import io.trino.sql.tree.ExpressionTreeRewriter;
import io.trino.sql.tree.GenericDataType;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.LabelDereference;
import io.trino.sql.tree.LambdaExpression;
import io.trino.sql.tree.PatternRecognitionRelation;
import io.trino.sql.tree.RowDataType;
import io.trino.sql.tree.SkipTo;
import io.trino.sql.tree.SymbolReference;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class PatternRecognitionBuilder {
    private PlanNode source;
    private List<Symbol> partitionBy = ImmutableList.of();
    private Optional<OrderingScheme> orderBy = Optional.empty();
    private final Map<Symbol, WindowNode.Function> windowFunctions = new HashMap<Symbol, WindowNode.Function>();
    private final Map<Symbol, Map.Entry<String, Type>> measures = new HashMap<Symbol, Map.Entry<String, Type>>();
    private Optional<WindowNode.Frame> commonBaseFrame = Optional.empty();
    private PatternRecognitionRelation.RowsPerMatch rowsPerMatch = PatternRecognitionRelation.RowsPerMatch.ONE;
    private Optional<IrLabel> skipToLabel = Optional.empty();
    private SkipTo.Position skipToPosition = SkipTo.Position.PAST_LAST;
    private boolean initial = true;
    private IrRowPattern pattern;
    private final Map<IrLabel, Set<IrLabel>> subsets = new HashMap<IrLabel, Set<IrLabel>>();
    private final Map<IrLabel, String> variableDefinitions = new HashMap<IrLabel, String>();

    public PatternRecognitionBuilder source(PlanNode source) {
        this.source = source;
        return this;
    }

    public PatternRecognitionBuilder partitionBy(List<Symbol> partitionBy) {
        this.partitionBy = partitionBy;
        return this;
    }

    public PatternRecognitionBuilder orderBy(OrderingScheme orderingScheme) {
        this.orderBy = Optional.of(orderingScheme);
        return this;
    }

    public PatternRecognitionBuilder addWindowFunction(Symbol symbol, WindowNode.Function function) {
        this.windowFunctions.put(symbol, function);
        return this;
    }

    public PatternRecognitionBuilder addMeasure(Symbol symbol, String expression, Type type) {
        this.measures.put(symbol, new AbstractMap.SimpleEntry<String, Type>(expression, type));
        return this;
    }

    public PatternRecognitionBuilder frame(WindowNode.Frame frame) {
        this.commonBaseFrame = Optional.of(frame);
        return this;
    }

    public PatternRecognitionBuilder rowsPerMatch(PatternRecognitionRelation.RowsPerMatch rowsPerMatch) {
        this.rowsPerMatch = rowsPerMatch;
        return this;
    }

    public PatternRecognitionBuilder skipTo(SkipTo.Position position, IrLabel label) {
        this.skipToPosition = position;
        this.skipToLabel = Optional.of(label);
        return this;
    }

    public PatternRecognitionBuilder skipTo(SkipTo.Position position) {
        this.skipToPosition = position;
        return this;
    }

    public PatternRecognitionBuilder seek() {
        this.initial = false;
        return this;
    }

    public PatternRecognitionBuilder pattern(IrRowPattern pattern) {
        this.pattern = pattern;
        return this;
    }

    public PatternRecognitionBuilder addSubset(IrLabel name, Set<IrLabel> elements) {
        this.subsets.put(name, elements);
        return this;
    }

    public PatternRecognitionBuilder addVariableDefinition(IrLabel name, String expression) {
        this.variableDefinitions.put(name, expression);
        return this;
    }

    public PatternRecognitionNode build(PlanNodeIdAllocator idAllocator) {
        return new PatternRecognitionNode(idAllocator.getNextId(), this.source, new WindowNode.Specification(this.partitionBy, this.orderBy), Optional.empty(), (Set)ImmutableSet.of(), 0, this.windowFunctions, (Map)this.measures.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> this.measure((Map.Entry)entry.getValue()))), this.commonBaseFrame, this.rowsPerMatch, this.skipToLabel, this.skipToPosition, this.initial, this.pattern, this.subsets, (Map)this.variableDefinitions.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> this.rewrite((String)entry.getValue()))));
    }

    private PatternRecognitionNode.Measure measure(Map.Entry<String, Type> entry) {
        return new PatternRecognitionNode.Measure(this.rewrite(entry.getKey()), entry.getValue());
    }

    private LogicalIndexExtractor.ExpressionAndValuePointers rewrite(String sql) {
        Expression expression = PatternRecognitionBuilder.rewriteIdentifiers(new SqlParser().createExpression(sql, new ParsingOptions()));
        Map types = (Map)ExpressionTreeUtils.extractExpressions((Iterable)ImmutableList.of((Object)expression), SymbolReference.class).stream().collect(ImmutableMap.toImmutableMap(Symbol::from, reference -> BigintType.BIGINT));
        return LogicalIndexExtractor.rewrite((Expression)expression, this.subsets, (SymbolAllocator)new SymbolAllocator(types));
    }

    public static Expression rewriteIdentifiers(Expression expression) {
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ExpressionRewriter<Void>(){

            public Expression rewriteDereferenceExpression(DereferenceExpression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                Preconditions.checkArgument((boolean)(node.getBase() instanceof Identifier), (Object)"chained dereferences not supported");
                return new LabelDereference(((Identifier)node.getBase()).getCanonicalValue(), new SymbolReference(node.getField().getValue()));
            }

            public Expression rewriteIdentifier(Identifier node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                return new SymbolReference(node.getValue());
            }

            public Expression rewriteLambdaExpression(LambdaExpression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                return new LambdaExpression(node.getArguments(), treeRewriter.rewrite(node.getBody(), (Object)context));
            }

            public Expression rewriteGenericDataType(GenericDataType node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                return node;
            }

            public Expression rewriteRowDataType(RowDataType node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                return node;
            }
        }, (Expression)expression);
    }
}

