/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule.test;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import io.trino.connector.CatalogName;
import io.trino.cost.PlanNodeStatsEstimate;
import io.trino.metadata.IndexHandle;
import io.trino.metadata.Metadata;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TableHandle;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorIndexHandle;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.sql.ExpressionUtils;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.parser.ParsingOptions;
import io.trino.sql.parser.SqlParser;
import io.trino.sql.planner.OrderingScheme;
import io.trino.sql.planner.Partitioning;
import io.trino.sql.planner.PartitioningHandle;
import io.trino.sql.planner.PartitioningScheme;
import io.trino.sql.planner.PlanNodeIdAllocator;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SystemPartitioningHandle;
import io.trino.sql.planner.TestingConnectorIndexHandle;
import io.trino.sql.planner.TestingConnectorTransactionHandle;
import io.trino.sql.planner.TestingWriterTarget;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.planner.iterative.rule.test.PatternRecognitionBuilder;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.ApplyNode;
import io.trino.sql.planner.plan.AssignUniqueId;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.CorrelatedJoinNode;
import io.trino.sql.planner.plan.DeleteNode;
import io.trino.sql.planner.plan.DistinctLimitNode;
import io.trino.sql.planner.plan.DynamicFilterId;
import io.trino.sql.planner.plan.EnforceSingleRowNode;
import io.trino.sql.planner.plan.ExceptNode;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.ExplainAnalyzeNode;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.GroupIdNode;
import io.trino.sql.planner.plan.IndexJoinNode;
import io.trino.sql.planner.plan.IndexSourceNode;
import io.trino.sql.planner.plan.IntersectNode;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.LimitNode;
import io.trino.sql.planner.plan.MarkDistinctNode;
import io.trino.sql.planner.plan.OffsetNode;
import io.trino.sql.planner.plan.OutputNode;
import io.trino.sql.planner.plan.PatternRecognitionNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.planner.plan.RowNumberNode;
import io.trino.sql.planner.plan.SampleNode;
import io.trino.sql.planner.plan.SemiJoinNode;
import io.trino.sql.planner.plan.SortNode;
import io.trino.sql.planner.plan.SpatialJoinNode;
import io.trino.sql.planner.plan.StatisticAggregations;
import io.trino.sql.planner.plan.StatisticAggregationsDescriptor;
import io.trino.sql.planner.plan.TableFinishNode;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.sql.planner.plan.TableWriterNode;
import io.trino.sql.planner.plan.TopNNode;
import io.trino.sql.planner.plan.TopNRankingNode;
import io.trino.sql.planner.plan.UnionNode;
import io.trino.sql.planner.plan.UnnestNode;
import io.trino.sql.planner.plan.ValuesNode;
import io.trino.sql.planner.plan.WindowNode;
import io.trino.sql.tree.BooleanLiteral;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NullLiteral;
import io.trino.sql.tree.Row;
import io.trino.testing.TestingHandle;
import io.trino.testing.TestingMetadata;
import io.trino.testing.TestingTransactionHandle;
import io.trino.util.MoreLists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class PlanBuilder {
    private final PlanNodeIdAllocator idAllocator;
    private final Metadata metadata;
    private final Map<Symbol, Type> symbols = new HashMap<Symbol, Type>();

    public PlanBuilder(PlanNodeIdAllocator idAllocator, Metadata metadata) {
        this.idAllocator = idAllocator;
        this.metadata = metadata;
    }

    public OutputNode output(List<String> columnNames, List<Symbol> outputs, PlanNode source) {
        return new OutputNode(this.idAllocator.getNextId(), source, columnNames, outputs);
    }

    public ExplainAnalyzeNode explainAnalyzeNode(Symbol output, List<Symbol> actualOutputs, PlanNode source) {
        return new ExplainAnalyzeNode(this.idAllocator.getNextId(), source, output, actualOutputs, false);
    }

    public OutputNode output(Consumer<OutputBuilder> outputBuilderConsumer) {
        OutputBuilder outputBuilder = new OutputBuilder();
        outputBuilderConsumer.accept(outputBuilder);
        return outputBuilder.build();
    }

    public ValuesNode values(Symbol ... columns) {
        return this.values(this.idAllocator.getNextId(), columns);
    }

    public ValuesNode values(PlanNodeId id, Symbol ... columns) {
        return this.values(id, 0, columns);
    }

    public ValuesNode values(int rows, Symbol ... columns) {
        return this.values(this.idAllocator.getNextId(), rows, columns);
    }

    public ValuesNode values(PlanNodeId id, int rows, Symbol ... columns) {
        return this.values(id, (List<Symbol>)ImmutableList.copyOf((Object[])columns), MoreLists.nElements((int)rows, row -> MoreLists.nElements((int)columns.length, cell -> new NullLiteral())));
    }

    public ValuesNode values(List<Symbol> columns, List<List<Expression>> rows) {
        return this.values(this.idAllocator.getNextId(), columns, rows);
    }

    public ValuesNode values(PlanNodeId id, List<Symbol> columns, List<List<Expression>> rows) {
        return new ValuesNode(id, columns, (List)rows.stream().map(Row::new).collect(ImmutableList.toImmutableList()));
    }

    public ValuesNode valuesOfExpressions(List<Symbol> columns, List<Expression> rows) {
        return new ValuesNode(this.idAllocator.getNextId(), columns, rows);
    }

    public EnforceSingleRowNode enforceSingleRow(PlanNode source) {
        return new EnforceSingleRowNode(this.idAllocator.getNextId(), source);
    }

    public SortNode sort(List<Symbol> orderBy, PlanNode source) {
        return new SortNode(this.idAllocator.getNextId(), source, new OrderingScheme(orderBy, (Map)Maps.toMap(orderBy, (Function)Functions.constant((Object)SortOrder.ASC_NULLS_FIRST))), false);
    }

    public OffsetNode offset(long rowCount, PlanNode source) {
        return new OffsetNode(this.idAllocator.getNextId(), source, rowCount);
    }

    public LimitNode limit(long limit, PlanNode source) {
        return this.limit(limit, (List<Symbol>)ImmutableList.of(), source);
    }

    public LimitNode limit(long limit, List<Symbol> tiesResolvers, PlanNode source) {
        return this.limit(limit, tiesResolvers, false, (List<Symbol>)ImmutableList.of(), source);
    }

    public LimitNode limit(long limit, boolean partial, List<Symbol> preSortedInputs, PlanNode source) {
        return this.limit(limit, (List<Symbol>)ImmutableList.of(), partial, preSortedInputs, source);
    }

    public LimitNode limit(long limit, List<Symbol> tiesResolvers, boolean partial, List<Symbol> preSortedInputs, PlanNode source) {
        Optional<Object> tiesResolvingScheme = Optional.empty();
        if (!tiesResolvers.isEmpty()) {
            tiesResolvingScheme = Optional.of(new OrderingScheme(tiesResolvers, (Map)Maps.toMap(tiesResolvers, (Function)Functions.constant((Object)SortOrder.ASC_NULLS_FIRST))));
        }
        return new LimitNode(this.idAllocator.getNextId(), source, limit, tiesResolvingScheme, partial, preSortedInputs);
    }

    public TopNNode topN(long count, List<Symbol> orderBy, PlanNode source) {
        return this.topN(count, orderBy, TopNNode.Step.SINGLE, source);
    }

    public TopNNode topN(long count, List<Symbol> orderBy, TopNNode.Step step, PlanNode source) {
        return this.topN(count, orderBy, step, SortOrder.ASC_NULLS_FIRST, source);
    }

    public TopNNode topN(long count, List<Symbol> orderBy, TopNNode.Step step, SortOrder sortOrder, PlanNode source) {
        return new TopNNode(this.idAllocator.getNextId(), source, count, new OrderingScheme(orderBy, (Map)Maps.toMap(orderBy, (Function)Functions.constant((Object)sortOrder))), step);
    }

    public SampleNode sample(double sampleRatio, SampleNode.Type type, PlanNode source) {
        return new SampleNode(this.idAllocator.getNextId(), source, sampleRatio, type);
    }

    public ProjectNode project(Assignments assignments, PlanNode source) {
        return new ProjectNode(this.idAllocator.getNextId(), source, assignments);
    }

    public MarkDistinctNode markDistinct(Symbol markerSymbol, List<Symbol> distinctSymbols, PlanNode source) {
        return new MarkDistinctNode(this.idAllocator.getNextId(), source, markerSymbol, distinctSymbols, Optional.empty());
    }

    public MarkDistinctNode markDistinct(Symbol markerSymbol, List<Symbol> distinctSymbols, Symbol hashSymbol, PlanNode source) {
        return new MarkDistinctNode(this.idAllocator.getNextId(), source, markerSymbol, distinctSymbols, Optional.of(hashSymbol));
    }

    public FilterNode filter(Expression predicate, PlanNode source) {
        return this.filter(this.idAllocator.getNextId(), predicate, source);
    }

    public FilterNode filter(PlanNodeId planNodeId, Expression predicate, PlanNode source) {
        return new FilterNode(planNodeId, source, predicate);
    }

    public AggregationNode aggregation(Consumer<AggregationBuilder> aggregationBuilderConsumer) {
        AggregationBuilder aggregationBuilder = new AggregationBuilder();
        aggregationBuilderConsumer.accept(aggregationBuilder);
        return aggregationBuilder.build();
    }

    public GroupIdNode groupId(List<List<Symbol>> groupingSets, List<Symbol> aggregationArguments, Symbol groupIdSymbol, PlanNode source) {
        Map groupingColumns = (Map)groupingSets.stream().flatMap(Collection::stream).distinct().collect(ImmutableMap.toImmutableMap(java.util.function.Function.identity(), java.util.function.Function.identity()));
        return new GroupIdNode(this.idAllocator.getNextId(), source, groupingSets, groupingColumns, aggregationArguments, groupIdSymbol);
    }

    public DistinctLimitNode distinctLimit(long count, List<Symbol> distinctSymbols, PlanNode source) {
        return this.distinctLimit(count, distinctSymbols, Optional.empty(), source);
    }

    public DistinctLimitNode distinctLimit(long count, List<Symbol> distinctSymbols, Optional<Symbol> hashSymbol, PlanNode source) {
        return new DistinctLimitNode(this.idAllocator.getNextId(), source, count, false, distinctSymbols, hashSymbol);
    }

    public ApplyNode apply(Assignments subqueryAssignments, List<Symbol> correlation, PlanNode input, PlanNode subquery) {
        NullLiteral originSubquery = new NullLiteral();
        return new ApplyNode(this.idAllocator.getNextId(), input, subquery, subqueryAssignments, correlation, (Node)originSubquery);
    }

    public AssignUniqueId assignUniqueId(Symbol unique, PlanNode source) {
        return new AssignUniqueId(this.idAllocator.getNextId(), source, unique);
    }

    public CorrelatedJoinNode correlatedJoin(List<Symbol> correlation, PlanNode input, PlanNode subquery) {
        return this.correlatedJoin(correlation, input, CorrelatedJoinNode.Type.INNER, (Expression)BooleanLiteral.TRUE_LITERAL, subquery);
    }

    public CorrelatedJoinNode correlatedJoin(List<Symbol> correlation, PlanNode input, CorrelatedJoinNode.Type type, Expression filter, PlanNode subquery) {
        NullLiteral originSubquery = new NullLiteral();
        return new CorrelatedJoinNode(this.idAllocator.getNextId(), input, subquery, correlation, type, filter, (Node)originSubquery);
    }

    public TableScanNode tableScan(List<Symbol> symbols, boolean forDelete) {
        return this.tableScan(tableScan -> tableScan.setSymbols(symbols).setAssignmentsForSymbols(symbols).setUpdateTarget(forDelete));
    }

    public TableScanNode tableScan(List<Symbol> symbols, Map<Symbol, ColumnHandle> assignments) {
        return this.tableScan(tableScan -> tableScan.setSymbols(symbols).setAssignments(assignments));
    }

    public TableScanNode tableScan(TableHandle tableHandle, List<Symbol> symbols, Map<Symbol, ColumnHandle> assignments) {
        return this.tableScan(tableScan -> tableScan.setTableHandle(tableHandle).setSymbols(symbols).setAssignments(assignments));
    }

    public TableScanNode tableScan(TableHandle tableHandle, List<Symbol> symbols, Map<Symbol, ColumnHandle> assignments, boolean forDelete) {
        return this.tableScan(tableScan -> tableScan.setTableHandle(tableHandle).setSymbols(symbols).setAssignments(assignments).setUpdateTarget(forDelete));
    }

    public TableScanNode tableScan(TableHandle tableHandle, List<Symbol> symbols, Map<Symbol, ColumnHandle> assignments, Optional<Boolean> useConnectorNodePartitioning) {
        return this.tableScan(tableScan -> tableScan.setTableHandle(tableHandle).setSymbols(symbols).setAssignments(assignments).setUseConnectorNodePartitioning(useConnectorNodePartitioning));
    }

    public TableScanNode tableScan(TableHandle tableHandle, List<Symbol> symbols, Map<Symbol, ColumnHandle> assignments, TupleDomain<ColumnHandle> enforcedConstraint) {
        return this.tableScan(tableScan -> tableScan.setTableHandle(tableHandle).setSymbols(symbols).setAssignments(assignments).setEnforcedConstraint(enforcedConstraint));
    }

    public TableScanNode tableScan(Consumer<TableScanBuilder> consumer) {
        TableScanBuilder tableScan = new TableScanBuilder(this.idAllocator);
        consumer.accept(tableScan);
        return tableScan.build();
    }

    public TableFinishNode tableDelete(SchemaTableName schemaTableName, PlanNode deleteSource, Symbol deleteRowId) {
        TableWriterNode.DeleteTarget deleteTarget = this.deleteTarget(schemaTableName);
        return new TableFinishNode(this.idAllocator.getNextId(), (PlanNode)this.exchange(e -> e.addSource((PlanNode)new DeleteNode(this.idAllocator.getNextId(), deleteSource, deleteTarget, deleteRowId, (List)ImmutableList.of((Object)deleteRowId))).addInputsSet(deleteRowId).singleDistributionPartitioningScheme(deleteRowId)), (TableWriterNode.WriterTarget)deleteTarget, deleteRowId, Optional.empty(), Optional.empty());
    }

    public DeleteNode delete(SchemaTableName schemaTableName, PlanNode deleteSource, Symbol deleteRowId, List<Symbol> outputs) {
        return new DeleteNode(this.idAllocator.getNextId(), deleteSource, this.deleteTarget(schemaTableName), deleteRowId, (List)ImmutableList.copyOf(outputs));
    }

    private TableWriterNode.DeleteTarget deleteTarget(SchemaTableName schemaTableName) {
        return new TableWriterNode.DeleteTarget(Optional.of(new TableHandle(new CatalogName("testConnector"), (ConnectorTableHandle)new TestingMetadata.TestingTableHandle(), (ConnectorTransactionHandle)TestingTransactionHandle.create(), Optional.of(TestingHandle.INSTANCE))), schemaTableName);
    }

    public ExchangeNode gatheringExchange(ExchangeNode.Scope scope, PlanNode child) {
        return this.exchange(builder -> builder.type(ExchangeNode.Type.GATHER).scope(scope).singleDistributionPartitioningScheme(child.getOutputSymbols()).addSource(child).addInputsSet(child.getOutputSymbols()));
    }

    public SemiJoinNode semiJoin(Symbol sourceJoinSymbol, Symbol filteringSourceJoinSymbol, Symbol semiJoinOutput, Optional<Symbol> sourceHashSymbol, Optional<Symbol> filteringSourceHashSymbol, PlanNode source, PlanNode filteringSource) {
        return this.semiJoin(source, filteringSource, sourceJoinSymbol, filteringSourceJoinSymbol, semiJoinOutput, sourceHashSymbol, filteringSourceHashSymbol, Optional.empty(), Optional.empty());
    }

    public SemiJoinNode semiJoin(PlanNode source, PlanNode filteringSource, Symbol sourceJoinSymbol, Symbol filteringSourceJoinSymbol, Symbol semiJoinOutput, Optional<Symbol> sourceHashSymbol, Optional<Symbol> filteringSourceHashSymbol, Optional<SemiJoinNode.DistributionType> distributionType) {
        return this.semiJoin(source, filteringSource, sourceJoinSymbol, filteringSourceJoinSymbol, semiJoinOutput, sourceHashSymbol, filteringSourceHashSymbol, distributionType, Optional.empty());
    }

    public SemiJoinNode semiJoin(PlanNode source, PlanNode filteringSource, Symbol sourceJoinSymbol, Symbol filteringSourceJoinSymbol, Symbol semiJoinOutput, Optional<Symbol> sourceHashSymbol, Optional<Symbol> filteringSourceHashSymbol, Optional<SemiJoinNode.DistributionType> distributionType, Optional<DynamicFilterId> dynamicFilterId) {
        return new SemiJoinNode(this.idAllocator.getNextId(), source, filteringSource, sourceJoinSymbol, filteringSourceJoinSymbol, semiJoinOutput, sourceHashSymbol, filteringSourceHashSymbol, distributionType, dynamicFilterId);
    }

    public IndexSourceNode indexSource(TableHandle tableHandle, Set<Symbol> lookupSymbols, List<Symbol> outputSymbols, Map<Symbol, ColumnHandle> assignments) {
        return new IndexSourceNode(this.idAllocator.getNextId(), new IndexHandle(tableHandle.getCatalogName(), (ConnectorTransactionHandle)TestingConnectorTransactionHandle.INSTANCE, (ConnectorIndexHandle)TestingConnectorIndexHandle.INSTANCE), tableHandle, lookupSymbols, outputSymbols, assignments);
    }

    public ExchangeNode exchange(Consumer<ExchangeBuilder> exchangeBuilderConsumer) {
        ExchangeBuilder exchangeBuilder = new ExchangeBuilder();
        exchangeBuilderConsumer.accept(exchangeBuilder);
        return exchangeBuilder.build();
    }

    public JoinNode join(JoinNode.Type joinType, PlanNode left, PlanNode right, JoinNode.EquiJoinClause ... criteria) {
        return this.join(joinType, left, right, Optional.empty(), criteria);
    }

    public JoinNode join(JoinNode.Type joinType, PlanNode left, PlanNode right, Expression filter, JoinNode.EquiJoinClause ... criteria) {
        return this.join(joinType, left, right, Optional.of(filter), criteria);
    }

    private JoinNode join(JoinNode.Type joinType, PlanNode left, PlanNode right, Optional<Expression> filter, JoinNode.EquiJoinClause ... criteria) {
        return this.join(joinType, left, right, (List<JoinNode.EquiJoinClause>)ImmutableList.copyOf((Object[])criteria), left.getOutputSymbols(), right.getOutputSymbols(), filter, Optional.empty(), Optional.empty(), (Map<DynamicFilterId, Symbol>)ImmutableMap.of());
    }

    public JoinNode join(JoinNode.Type type, PlanNode left, PlanNode right, List<JoinNode.EquiJoinClause> criteria, List<Symbol> leftOutputSymbols, List<Symbol> rightOutputSymbols, Optional<Expression> filter) {
        return this.join(type, left, right, criteria, leftOutputSymbols, rightOutputSymbols, filter, Optional.empty(), Optional.empty());
    }

    public JoinNode join(JoinNode.Type type, PlanNode left, PlanNode right, List<JoinNode.EquiJoinClause> criteria, List<Symbol> leftOutputSymbols, List<Symbol> rightOutputSymbols, Optional<Expression> filter, Optional<Symbol> leftHashSymbol, Optional<Symbol> rightHashSymbol) {
        return this.join(type, left, right, criteria, leftOutputSymbols, rightOutputSymbols, filter, leftHashSymbol, rightHashSymbol, Optional.empty(), (Map<DynamicFilterId, Symbol>)ImmutableMap.of());
    }

    public JoinNode join(JoinNode.Type type, PlanNode left, PlanNode right, List<JoinNode.EquiJoinClause> criteria, List<Symbol> leftOutputSymbols, List<Symbol> rightOutputSymbols, Optional<Expression> filter, Optional<Symbol> leftHashSymbol, Optional<Symbol> rightHashSymbol, Map<DynamicFilterId, Symbol> dynamicFilters) {
        return this.join(type, left, right, criteria, leftOutputSymbols, rightOutputSymbols, filter, leftHashSymbol, rightHashSymbol, Optional.empty(), dynamicFilters);
    }

    public JoinNode join(JoinNode.Type type, PlanNode left, PlanNode right, List<JoinNode.EquiJoinClause> criteria, List<Symbol> leftOutputSymbols, List<Symbol> rightOutputSymbols, Optional<Expression> filter, Optional<Symbol> leftHashSymbol, Optional<Symbol> rightHashSymbol, Optional<JoinNode.DistributionType> distributionType, Map<DynamicFilterId, Symbol> dynamicFilters) {
        return new JoinNode(this.idAllocator.getNextId(), type, left, right, criteria, leftOutputSymbols, rightOutputSymbols, false, filter, leftHashSymbol, rightHashSymbol, distributionType, Optional.empty(), dynamicFilters, Optional.empty());
    }

    public PlanNode indexJoin(IndexJoinNode.Type type, PlanNode probe, PlanNode index) {
        return this.indexJoin(type, probe, index, Collections.emptyList(), Optional.empty(), Optional.empty());
    }

    public PlanNode indexJoin(IndexJoinNode.Type type, PlanNode probe, PlanNode index, List<IndexJoinNode.EquiJoinClause> criteria, Optional<Symbol> probeHashSymbol, Optional<Symbol> indexHashSymbol) {
        return new IndexJoinNode(this.idAllocator.getNextId(), type, probe, index, criteria, probeHashSymbol, indexHashSymbol);
    }

    public PlanNode spatialJoin(SpatialJoinNode.Type type, PlanNode left, PlanNode right, List<Symbol> outputSymbols, Expression filter) {
        return this.spatialJoin(type, left, right, outputSymbols, filter, Optional.empty(), Optional.empty(), Optional.empty());
    }

    public PlanNode spatialJoin(SpatialJoinNode.Type type, PlanNode left, PlanNode right, List<Symbol> outputSymbols, Expression filter, Optional<Symbol> leftPartitionSymbol, Optional<Symbol> rightPartitionSymbol, Optional<String> kdbTree) {
        return new SpatialJoinNode(this.idAllocator.getNextId(), type, left, right, outputSymbols, filter, leftPartitionSymbol, rightPartitionSymbol, kdbTree);
    }

    public UnionNode union(ListMultimap<Symbol, Symbol> outputsToInputs, List<PlanNode> sources) {
        ImmutableList outputs = ImmutableList.copyOf((Collection)outputsToInputs.keySet());
        return new UnionNode(this.idAllocator.getNextId(), sources, outputsToInputs, (List)outputs);
    }

    public IntersectNode intersect(ListMultimap<Symbol, Symbol> outputsToInputs, List<PlanNode> sources) {
        return this.intersect(outputsToInputs, sources, true);
    }

    public IntersectNode intersect(ListMultimap<Symbol, Symbol> outputsToInputs, List<PlanNode> sources, boolean distinct) {
        ImmutableList outputs = ImmutableList.copyOf((Collection)outputsToInputs.keySet());
        return new IntersectNode(this.idAllocator.getNextId(), sources, outputsToInputs, (List)outputs, distinct);
    }

    public ExceptNode except(ListMultimap<Symbol, Symbol> outputsToInputs, List<PlanNode> sources) {
        return this.except(outputsToInputs, sources, true);
    }

    public ExceptNode except(ListMultimap<Symbol, Symbol> outputsToInputs, List<PlanNode> sources, boolean distinct) {
        ImmutableList outputs = ImmutableList.copyOf((Collection)outputsToInputs.keySet());
        return new ExceptNode(this.idAllocator.getNextId(), sources, outputsToInputs, (List)outputs, distinct);
    }

    public TableWriterNode tableWriter(List<Symbol> columns, List<String> columnNames, PlanNode source) {
        return this.tableWriter(columns, columnNames, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), source);
    }

    public TableWriterNode tableWriter(List<Symbol> columns, List<String> columnNames, Optional<PartitioningScheme> partitioningScheme, Optional<PartitioningScheme> preferredPartitioningScheme, Optional<StatisticAggregations> statisticAggregations, Optional<StatisticAggregationsDescriptor<Symbol>> statisticAggregationsDescriptor, PlanNode source) {
        return new TableWriterNode(this.idAllocator.getNextId(), source, (TableWriterNode.WriterTarget)new TestingWriterTarget(), this.symbol("partialrows", (Type)BigintType.BIGINT), this.symbol("fragment", (Type)VarbinaryType.VARBINARY), columns, columnNames, (Set)ImmutableSet.of(), partitioningScheme, preferredPartitioningScheme, statisticAggregations, statisticAggregationsDescriptor);
    }

    public PartitioningScheme partitioningScheme(List<Symbol> outputSymbols, List<Symbol> partitioningSymbols, Symbol hashSymbol) {
        return new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION, (List)ImmutableList.copyOf(partitioningSymbols)), (List)ImmutableList.copyOf(outputSymbols), Optional.of(hashSymbol));
    }

    public StatisticAggregations statisticAggregations(Map<Symbol, AggregationNode.Aggregation> aggregations, List<Symbol> groupingSymbols) {
        return new StatisticAggregations(aggregations, groupingSymbols);
    }

    public AggregationNode.Aggregation aggregation(Expression expression, List<Type> inputTypes) {
        Preconditions.checkArgument((boolean)(expression instanceof FunctionCall));
        FunctionCall aggregation = (FunctionCall)expression;
        ResolvedFunction resolvedFunction = this.metadata.resolveFunction(aggregation.getName(), TypeSignatureProvider.fromTypes(inputTypes));
        return new AggregationNode.Aggregation(resolvedFunction, aggregation.getArguments(), aggregation.isDistinct(), aggregation.getFilter().map(Symbol::from), aggregation.getOrderBy().map(OrderingScheme::fromOrderBy), Optional.empty());
    }

    public Symbol symbol(String name) {
        return this.symbol(name, (Type)BigintType.BIGINT);
    }

    public Symbol symbol(String name, Type type) {
        Symbol symbol = new Symbol(name);
        Type old = this.symbols.put(symbol, type);
        if (old != null && !old.equals(type)) {
            throw new IllegalArgumentException(String.format("Symbol '%s' already registered with type '%s'", name, old));
        }
        if (old == null) {
            this.symbols.put(symbol, type);
        }
        return symbol;
    }

    public UnnestNode unnest(List<Symbol> replicateSymbols, List<UnnestNode.Mapping> mappings, PlanNode source) {
        return this.unnest(replicateSymbols, mappings, Optional.empty(), JoinNode.Type.INNER, Optional.empty(), source);
    }

    public UnnestNode unnest(List<Symbol> replicateSymbols, List<UnnestNode.Mapping> mappings, Optional<Symbol> ordinalitySymbol, JoinNode.Type type, Optional<Expression> filter, PlanNode source) {
        return new UnnestNode(this.idAllocator.getNextId(), source, replicateSymbols, mappings, ordinalitySymbol, type, filter);
    }

    public WindowNode window(WindowNode.Specification specification, Map<Symbol, WindowNode.Function> functions, PlanNode source) {
        return new WindowNode(this.idAllocator.getNextId(), source, specification, (Map)ImmutableMap.copyOf(functions), Optional.empty(), (Set)ImmutableSet.of(), 0);
    }

    public WindowNode window(WindowNode.Specification specification, Map<Symbol, WindowNode.Function> functions, Symbol hashSymbol, PlanNode source) {
        return new WindowNode(this.idAllocator.getNextId(), source, specification, (Map)ImmutableMap.copyOf(functions), Optional.of(hashSymbol), (Set)ImmutableSet.of(), 0);
    }

    public RowNumberNode rowNumber(List<Symbol> partitionBy, Optional<Integer> maxRowCountPerPartition, Symbol rowNumberSymbol, PlanNode source) {
        return this.rowNumber(partitionBy, maxRowCountPerPartition, rowNumberSymbol, Optional.empty(), source);
    }

    public RowNumberNode rowNumber(List<Symbol> partitionBy, Optional<Integer> maxRowCountPerPartition, Symbol rowNumberSymbol, Optional<Symbol> hashSymbol, PlanNode source) {
        return new RowNumberNode(this.idAllocator.getNextId(), source, partitionBy, false, rowNumberSymbol, maxRowCountPerPartition, hashSymbol);
    }

    public TopNRankingNode topNRanking(WindowNode.Specification specification, TopNRankingNode.RankingType rankingType, int maxRankingPerPartition, Symbol rankingSymbol, Optional<Symbol> hashSymbol, PlanNode source) {
        return new TopNRankingNode(this.idAllocator.getNextId(), source, specification, rankingType, rankingSymbol, maxRankingPerPartition, false, hashSymbol);
    }

    public PatternRecognitionNode patternRecognition(Consumer<PatternRecognitionBuilder> consumer) {
        PatternRecognitionBuilder patternRecognitionBuilder = new PatternRecognitionBuilder();
        consumer.accept(patternRecognitionBuilder);
        return patternRecognitionBuilder.build(this.idAllocator);
    }

    public static Expression expression(String sql) {
        return ExpressionUtils.rewriteIdentifiersToSymbolReferences((Expression)new SqlParser().createExpression(sql, new ParsingOptions()));
    }

    public static List<Expression> expressions(String ... expressions) {
        return (List)Stream.of(expressions).map(PlanBuilder::expression).collect(ImmutableList.toImmutableList());
    }

    public TypeProvider getTypes() {
        return TypeProvider.copyOf(this.symbols);
    }

    public class ExchangeBuilder {
        private ExchangeNode.Type type = ExchangeNode.Type.GATHER;
        private ExchangeNode.Scope scope = ExchangeNode.Scope.REMOTE;
        private PartitioningScheme partitioningScheme;
        private OrderingScheme orderingScheme;
        private List<PlanNode> sources = new ArrayList<PlanNode>();
        private List<List<Symbol>> inputs = new ArrayList<List<Symbol>>();

        public ExchangeBuilder type(ExchangeNode.Type type) {
            this.type = type;
            return this;
        }

        public ExchangeBuilder scope(ExchangeNode.Scope scope) {
            this.scope = scope;
            return this;
        }

        public ExchangeBuilder singleDistributionPartitioningScheme(Symbol ... outputSymbols) {
            return this.singleDistributionPartitioningScheme(Arrays.asList(outputSymbols));
        }

        public ExchangeBuilder singleDistributionPartitioningScheme(List<Symbol> outputSymbols) {
            return this.partitioningScheme(new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List)ImmutableList.of()), outputSymbols));
        }

        public ExchangeBuilder fixedHashDistributionParitioningScheme(List<Symbol> outputSymbols, List<Symbol> partitioningSymbols) {
            return this.partitioningScheme(new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION, (List)ImmutableList.copyOf(partitioningSymbols)), (List)ImmutableList.copyOf(outputSymbols)));
        }

        public ExchangeBuilder fixedHashDistributionParitioningScheme(List<Symbol> outputSymbols, List<Symbol> partitioningSymbols, Symbol hashSymbol) {
            return this.partitioningScheme(new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION, (List)ImmutableList.copyOf(partitioningSymbols)), (List)ImmutableList.copyOf(outputSymbols), Optional.of(hashSymbol)));
        }

        public ExchangeBuilder partitioningScheme(PartitioningScheme partitioningScheme) {
            this.partitioningScheme = partitioningScheme;
            return this;
        }

        public ExchangeBuilder addSource(PlanNode source) {
            this.sources.add(source);
            return this;
        }

        public ExchangeBuilder addInputsSet(Symbol ... inputs) {
            return this.addInputsSet(Arrays.asList(inputs));
        }

        public ExchangeBuilder addInputsSet(List<Symbol> inputs) {
            this.inputs.add(inputs);
            return this;
        }

        public ExchangeBuilder orderingScheme(OrderingScheme orderingScheme) {
            this.orderingScheme = orderingScheme;
            return this;
        }

        protected ExchangeNode build() {
            return new ExchangeNode(PlanBuilder.this.idAllocator.getNextId(), this.type, this.scope, this.partitioningScheme, this.sources, this.inputs, Optional.ofNullable(this.orderingScheme));
        }
    }

    public static class TableScanBuilder {
        private final PlanNodeIdAllocator idAllocator;
        private TableHandle tableHandle = new TableHandle(new CatalogName("testConnector"), (ConnectorTableHandle)new TestingMetadata.TestingTableHandle(), (ConnectorTransactionHandle)TestingTransactionHandle.create(), Optional.of(TestingHandle.INSTANCE));
        private List<Symbol> symbols;
        private Map<Symbol, ColumnHandle> assignments;
        private TupleDomain<ColumnHandle> enforcedConstraint = TupleDomain.all();
        private Optional<PlanNodeStatsEstimate> statistics = Optional.empty();
        private boolean updateTarget;
        private Optional<Boolean> useConnectorNodePartitioning = Optional.empty();

        private TableScanBuilder(PlanNodeIdAllocator idAllocator) {
            this.idAllocator = Objects.requireNonNull(idAllocator, "idAllocator is null");
        }

        public TableScanBuilder setTableHandle(TableHandle tableHandle) {
            this.tableHandle = tableHandle;
            return this;
        }

        public TableScanBuilder setSymbols(List<Symbol> symbols) {
            this.symbols = symbols;
            return this;
        }

        public TableScanBuilder setAssignmentsForSymbols(List<Symbol> symbols) {
            return this.setAssignments((Map)symbols.stream().collect(ImmutableMap.toImmutableMap(java.util.function.Function.identity(), symbol -> new TestingMetadata.TestingColumnHandle(symbol.getName()))));
        }

        public TableScanBuilder setAssignments(Map<Symbol, ColumnHandle> assignments) {
            this.assignments = assignments;
            return this;
        }

        public TableScanBuilder setEnforcedConstraint(TupleDomain<ColumnHandle> enforcedConstraint) {
            this.enforcedConstraint = enforcedConstraint;
            return this;
        }

        public TableScanBuilder setStatistics(Optional<PlanNodeStatsEstimate> statistics) {
            this.statistics = statistics;
            return this;
        }

        public TableScanBuilder setUpdateTarget(boolean updateTarget) {
            this.updateTarget = updateTarget;
            return this;
        }

        public TableScanBuilder setUseConnectorNodePartitioning(Optional<Boolean> useConnectorNodePartitioning) {
            this.useConnectorNodePartitioning = useConnectorNodePartitioning;
            return this;
        }

        public TableScanNode build() {
            return new TableScanNode(this.idAllocator.getNextId(), this.tableHandle, this.symbols, this.assignments, this.enforcedConstraint, this.statistics, this.updateTarget, this.useConnectorNodePartitioning);
        }
    }

    public class AggregationBuilder {
        private PlanNode source;
        private Map<Symbol, AggregationNode.Aggregation> assignments = new HashMap<Symbol, AggregationNode.Aggregation>();
        private AggregationNode.GroupingSetDescriptor groupingSets;
        private List<Symbol> preGroupedSymbols = new ArrayList<Symbol>();
        private AggregationNode.Step step = AggregationNode.Step.SINGLE;
        private Optional<Symbol> hashSymbol = Optional.empty();
        private Optional<Symbol> groupIdSymbol = Optional.empty();

        public AggregationBuilder source(PlanNode source) {
            this.source = source;
            return this;
        }

        public AggregationBuilder addAggregation(Symbol output, Expression expression, List<Type> inputTypes) {
            return this.addAggregation(output, expression, inputTypes, Optional.empty());
        }

        public AggregationBuilder addAggregation(Symbol output, Expression expression, List<Type> inputTypes, Symbol mask) {
            return this.addAggregation(output, expression, inputTypes, Optional.of(mask));
        }

        private AggregationBuilder addAggregation(Symbol output, Expression expression, List<Type> inputTypes, Optional<Symbol> mask) {
            Preconditions.checkArgument((boolean)(expression instanceof FunctionCall));
            FunctionCall aggregation = (FunctionCall)expression;
            ResolvedFunction resolvedFunction = PlanBuilder.this.metadata.resolveFunction(aggregation.getName(), TypeSignatureProvider.fromTypes(inputTypes));
            return this.addAggregation(output, new AggregationNode.Aggregation(resolvedFunction, aggregation.getArguments(), aggregation.isDistinct(), aggregation.getFilter().map(Symbol::from), aggregation.getOrderBy().map(OrderingScheme::fromOrderBy), mask));
        }

        public AggregationBuilder addAggregation(Symbol output, AggregationNode.Aggregation aggregation) {
            this.assignments.put(output, aggregation);
            return this;
        }

        public AggregationBuilder globalGrouping() {
            this.groupingSets(AggregationNode.singleGroupingSet((List)ImmutableList.of()));
            return this;
        }

        public AggregationBuilder singleGroupingSet(Symbol ... symbols) {
            this.groupingSets(AggregationNode.singleGroupingSet((List)ImmutableList.copyOf((Object[])symbols)));
            return this;
        }

        public AggregationBuilder groupingSets(AggregationNode.GroupingSetDescriptor groupingSets) {
            Preconditions.checkState((this.groupingSets == null ? 1 : 0) != 0, (Object)"groupingSets already defined");
            this.groupingSets = groupingSets;
            return this;
        }

        public AggregationBuilder preGroupedSymbols(Symbol ... symbols) {
            Preconditions.checkState((boolean)this.preGroupedSymbols.isEmpty(), (Object)"preGroupedSymbols already defined");
            this.preGroupedSymbols = ImmutableList.copyOf((Object[])symbols);
            return this;
        }

        public AggregationBuilder step(AggregationNode.Step step) {
            this.step = step;
            return this;
        }

        public AggregationBuilder hashSymbol(Symbol hashSymbol) {
            this.hashSymbol = Optional.of(hashSymbol);
            return this;
        }

        public AggregationBuilder groupIdSymbol(Symbol groupIdSymbol) {
            this.groupIdSymbol = Optional.of(groupIdSymbol);
            return this;
        }

        protected AggregationNode build() {
            Preconditions.checkState((this.groupingSets != null ? 1 : 0) != 0, (Object)"No grouping sets defined; use globalGrouping/groupingKeys method");
            return new AggregationNode(PlanBuilder.this.idAllocator.getNextId(), this.source, this.assignments, this.groupingSets, this.preGroupedSymbols, this.step, this.hashSymbol, this.groupIdSymbol);
        }
    }

    public class OutputBuilder {
        private PlanNode source;
        private final List<String> columnNames = new ArrayList<String>();
        private final List<Symbol> outputs = new ArrayList<Symbol>();

        public OutputBuilder source(PlanNode source) {
            this.source = source;
            return this;
        }

        public OutputBuilder column(Symbol symbol) {
            return this.column(symbol, symbol.getName());
        }

        public OutputBuilder column(Symbol symbol, String columnName) {
            this.outputs.add(symbol);
            this.columnNames.add(columnName);
            return this;
        }

        protected OutputNode build() {
            return new OutputNode(PlanBuilder.this.idAllocator.getNextId(), this.source, this.columnNames, this.outputs);
        }
    }
}

