/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.optimizations;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.Session;
import io.trino.plugin.tpch.TpchConnectorFactory;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.sql.analyzer.FeaturesConfig;
import io.trino.sql.planner.assertions.BasePlanTest;
import io.trino.sql.planner.assertions.ExpectedValueProvider;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.assertions.RowNumberSymbolMatcher;
import io.trino.sql.planner.assertions.RvalueMatcher;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.MarkDistinctNode;
import io.trino.sql.planner.plan.TopNNode;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.GenericLiteral;
import io.trino.sql.tree.LongLiteral;
import io.trino.sql.tree.SortItem;
import io.trino.testing.LocalQueryRunner;
import io.trino.testing.TestingSession;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.testng.annotations.Test;

public class TestAddExchangesPlans
extends BasePlanTest {
    @Override
    protected LocalQueryRunner createLocalQueryRunner() {
        Session session = TestingSession.testSessionBuilder().setCatalog("tpch").setSchema("tiny").build();
        FeaturesConfig featuresConfig = new FeaturesConfig().setSpillerSpillPaths("/tmp/test_spill_path");
        LocalQueryRunner queryRunner = LocalQueryRunner.builder((Session)session).withFeaturesConfig(featuresConfig).build();
        queryRunner.createCatalog("tpch", (ConnectorFactory)new TpchConnectorFactory(1), (Map)ImmutableMap.of());
        return queryRunner;
    }

    @Test
    public void testRepartitionForUnionWithAnyTableScans() {
        this.assertDistributedPlan("SELECT nationkey FROM nation UNION select regionkey from region", PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(), PlanMatchPattern.anyTree(PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("nation")))), PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("region"))))))));
        this.assertDistributedPlan("SELECT nationkey FROM nation UNION select 1", PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(), PlanMatchPattern.anyTree(PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("nation")))), PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"expr"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new GenericLiteral("BIGINT", "1")))))))))));
    }

    @Test
    public void testRepartitionForUnionAllBeforeHashJoin() {
        Session session = Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("join_distribution_type", JoinNode.DistributionType.PARTITIONED.name()).setSystemProperty("join_reordering_strategy", FeaturesConfig.JoinReorderingStrategy.ELIMINATE_CROSS_JOINS.name()).build();
        this.assertDistributedPlan("SELECT * FROM (SELECT nationkey FROM nation UNION ALL select nationkey from nation) n join region r on n.nationkey = r.regionkey", session, PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("nationkey", "regionkey")), PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"nationkey", (Object)"nationkey")))), PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("nation")))), PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("region", (Map<String, String>)ImmutableMap.of((Object)"regionkey", (Object)"regionkey"))))))));
        this.assertDistributedPlan("SELECT * FROM (SELECT nationkey FROM nation UNION ALL select 1) n join region r on n.nationkey = r.regionkey", session, PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("nationkey", "regionkey")), PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"nationkey", (Object)"nationkey")))), PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.project(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"expr"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new GenericLiteral("BIGINT", "1"))))))), PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("region", (Map<String, String>)ImmutableMap.of((Object)"regionkey", (Object)"regionkey"))))))));
    }

    @Test
    public void testNonSpillableBroadcastJoinAboveTableScan() {
        this.assertDistributedPlan("SELECT * FROM nation n join region r on n.nationkey = r.regionkey", this.noJoinReordering(), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("nationkey", "regionkey")), Optional.empty(), Optional.of(JoinNode.DistributionType.REPLICATED), Optional.of(false), PlanMatchPattern.anyNot(ExchangeNode.class, PlanMatchPattern.node(FilterNode.class, PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"nationkey", (Object)"nationkey")))), PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPLICATE, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("region", (Map<String, String>)ImmutableMap.of((Object)"regionkey", (Object)"regionkey"))))))));
        this.assertDistributedPlan("SELECT * FROM nation n join region r on n.nationkey = r.regionkey", this.spillEnabledWithJoinDistributionType(FeaturesConfig.JoinDistributionType.PARTITIONED), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, (List<ExpectedValueProvider<JoinNode.EquiJoinClause>>)ImmutableList.of(PlanMatchPattern.equiJoinClause("nationkey", "regionkey")), Optional.empty(), Optional.of(JoinNode.DistributionType.PARTITIONED), Optional.empty(), PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"nationkey", (Object)"nationkey")))), PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("region", (Map<String, String>)ImmutableMap.of((Object)"regionkey", (Object)"regionkey"))))))));
    }

    @Test
    public void testForcePartitioningMarkDistinctInput() {
        String query = "SELECT count(orderkey), count(distinct orderkey), custkey , count(1) FROM ( SELECT * FROM (VALUES (1, 2)) as t(custkey, orderkey) UNION ALL SELECT 3, 4) GROUP BY 3";
        this.assertDistributedPlan(query, Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("ignore_downstream_preferences", "true").build(), PlanMatchPattern.anyTree(PlanMatchPattern.node(MarkDistinctNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), (Set<String>)ImmutableSet.of((Object)"partition1", (Object)"partition2"), PlanMatchPattern.project(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"field", (Object)"partition2", (Object)"partition1"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new LongLiteral("1"), (Object)new LongLiteral("2"), (Object)new LongLiteral("1")))))), PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), (Set<String>)ImmutableSet.of((Object)"partition3", (Object)"partition3"), PlanMatchPattern.project(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"partition3", (Object)"partition4", (Object)"field_0"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new LongLiteral("3"), (Object)new LongLiteral("4"), (Object)new LongLiteral("1"))))))))));
        this.assertDistributedPlan(query, Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("ignore_downstream_preferences", "false").build(), PlanMatchPattern.anyTree(PlanMatchPattern.node(MarkDistinctNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), (Set<String>)ImmutableSet.of((Object)"partition1"), PlanMatchPattern.project(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"field", (Object)"partition2", (Object)"partition1"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new LongLiteral("1"), (Object)new LongLiteral("2"), (Object)new LongLiteral("1")))))), PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), (Set<String>)ImmutableSet.of((Object)"partition3"), PlanMatchPattern.project(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"partition3", (Object)"partition4", (Object)"field_0"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new LongLiteral("3"), (Object)new LongLiteral("4"), (Object)new LongLiteral("1"))))))))));
    }

    @Test
    public void testImplementOffsetWithOrderedSource() {
        this.assertPlan("SELECT name FROM nation ORDER BY regionkey, name OFFSET 5 LIMIT 2", PlanMatchPattern.output(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"name", (Object)PlanMatchPattern.expression("name")), PlanMatchPattern.filter("row_num > BIGINT '5'", PlanMatchPattern.rowNumber(pattern -> pattern.partitionBy((List<String>)ImmutableList.of()), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"name", (Object)PlanMatchPattern.expression("name")), PlanMatchPattern.topN(7L, (List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("regionkey", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.LAST), (Object)PlanMatchPattern.sort("name", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.LAST)), TopNNode.Step.FINAL, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"name", (Object)"name", (Object)"regionkey", (Object)"regionkey")))))).withAlias("row_num", (RvalueMatcher)new RowNumberSymbolMatcher())))));
    }

    @Test
    public void testImplementOffsetWithUnorderedSource() {
        this.assertPlan("SELECT name FROM nation OFFSET 5 LIMIT 2", PlanMatchPattern.any(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"name", (Object)PlanMatchPattern.expression("name")), PlanMatchPattern.filter("row_num > BIGINT '5'", PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, PlanMatchPattern.rowNumber(pattern -> pattern.partitionBy((List<String>)ImmutableList.of()), PlanMatchPattern.limit(7L, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"name", (Object)"name"))))).withAlias("row_num", (RvalueMatcher)new RowNumberSymbolMatcher()))))));
    }

    @Test
    public void testExchangesAroundTrivialProjection() {
        this.assertPlan("SELECT name, row_number() OVER () FROM (SELECT * FROM nation ORDER BY nationkey LIMIT 5)", PlanMatchPattern.any(PlanMatchPattern.rowNumber(pattern -> pattern.partitionBy((List<String>)ImmutableList.of()), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"name", (Object)PlanMatchPattern.expression("name")), PlanMatchPattern.topN(5L, (List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("nationkey", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.LAST)), TopNNode.Step.FINAL, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"name", (Object)"name", (Object)"nationkey", (Object)"nationkey"))))))));
        this.assertPlan("SELECT b, row_number() OVER () FROM (VALUES (1, 2)) t(a, b) WHERE a < 10", PlanMatchPattern.any(PlanMatchPattern.rowNumber(pattern -> pattern.partitionBy((List<String>)ImmutableList.of()), PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"b", (Object)PlanMatchPattern.expression("b")), PlanMatchPattern.filter("a < 10", PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, PlanMatchPattern.values("a", "b"))))))));
        this.assertPlan("SELECT row_number() OVER (PARTITION BY regionkey) FROM (SELECT * FROM nation ORDER BY nationkey LIMIT 5)", PlanMatchPattern.anyTree(PlanMatchPattern.rowNumber(pattern -> pattern.partitionBy((List<String>)ImmutableList.of((Object)"regionkey")).hashSymbol(Optional.of("hash")), PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), (Set<String>)ImmutableSet.of((Object)"regionkey"), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"regionkey", (Object)PlanMatchPattern.expression("regionkey"), (Object)"hash", (Object)PlanMatchPattern.expression("hash")), PlanMatchPattern.topN(5L, (List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("nationkey", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.LAST)), TopNNode.Step.FINAL, PlanMatchPattern.any(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"regionkey", (Object)PlanMatchPattern.expression("regionkey"), (Object)"nationkey", (Object)PlanMatchPattern.expression("nationkey"), (Object)"hash", (Object)PlanMatchPattern.expression("combine_hash(bigint '0', COALESCE(\"$operator$hash_code\"(regionkey), 0))")), PlanMatchPattern.any(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"regionkey", (Object)"regionkey", (Object)"nationkey", (Object)"nationkey")))))))))));
        this.assertPlan("SELECT row_number() OVER (PARTITION BY b) FROM (VALUES (1, 2)) t(a,b) WHERE a < 10", PlanMatchPattern.anyTree(PlanMatchPattern.rowNumber(pattern -> pattern.partitionBy((List<String>)ImmutableList.of((Object)"b")).hashSymbol(Optional.of("hash")), PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, (List<PlanMatchPattern.Ordering>)ImmutableList.of(), (Set<String>)ImmutableSet.of((Object)"b"), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"b", (Object)PlanMatchPattern.expression("b"), (Object)"hash", (Object)PlanMatchPattern.expression("hash")), PlanMatchPattern.filter("a < 10", PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression("a"), (Object)"b", (Object)PlanMatchPattern.expression("b"), (Object)"hash", (Object)PlanMatchPattern.expression("combine_hash(bigint '0', COALESCE(\"$operator$hash_code\"(b), 0))")), PlanMatchPattern.values("a", "b")))))))));
        this.assertPlan("SELECT count(name) FROM (SELECT * FROM nation ORDER BY nationkey LIMIT 5)", PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"count", PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of((Object)"name"))), AggregationNode.Step.PARTIAL, PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"name", (Object)PlanMatchPattern.expression("name")), PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, PlanMatchPattern.topN(5L, (List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort("nationkey", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.LAST)), TopNNode.Step.FINAL, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"name", (Object)"name", (Object)"nationkey", (Object)"nationkey")))))))));
        this.assertPlan("SELECT count(b) FROM (VALUES (1, 2)) t(a,b) WHERE a < 10", PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"count", PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of((Object)"b"))), AggregationNode.Step.PARTIAL, PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"b", (Object)PlanMatchPattern.expression("b")), PlanMatchPattern.filter("a < 10", PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, PlanMatchPattern.values("a", "b")))))));
        this.assertPlan("SELECT 10, a FROM (VALUES 1) t(a)", PlanMatchPattern.anyTree(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a", (Object)"expr"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new LongLiteral("1"), (Object)new LongLiteral("10"))))));
        this.assertPlan("SELECT 1 UNION ALL SELECT 1", PlanMatchPattern.anyTree(PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"expr"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new LongLiteral("1")))), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"expr_0"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new LongLiteral("1")))))));
    }

    private Session spillEnabledWithJoinDistributionType(FeaturesConfig.JoinDistributionType joinDistributionType) {
        return Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("join_distribution_type", joinDistributionType.toString()).setSystemProperty("spill_enabled", "true").setSystemProperty("task_concurrency", "16").build();
    }

    private Session noJoinReordering() {
        return Session.builder((Session)this.getQueryRunner().getDefaultSession()).setSystemProperty("join_reordering_strategy", FeaturesConfig.JoinReorderingStrategy.NONE.name()).setSystemProperty("join_distribution_type", FeaturesConfig.JoinDistributionType.BROADCAST.name()).setSystemProperty("spill_enabled", "true").setSystemProperty("task_concurrency", "16").build();
    }
}

