/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.optimizations;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Range;
import io.trino.metadata.AbstractMockMetadata;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.TestingColumnHandle;
import io.trino.sql.planner.PlanNodeIdAllocator;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.optimizations.QueryCardinalityUtil;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.tree.Expression;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestCardinalityExtractorPlanVisitor {
    @Test
    public void testLimitOnTopOfValues() {
        PlanBuilder planBuilder = new PlanBuilder(new PlanNodeIdAllocator(), AbstractMockMetadata.dummyMetadata());
        Assert.assertEquals((Object)QueryCardinalityUtil.extractCardinality((PlanNode)planBuilder.limit(3L, (PlanNode)planBuilder.values(Collections.emptyList(), (List<List<Expression>>)ImmutableList.of(Collections.emptyList())))), (Object)Range.singleton((Comparable)Long.valueOf(1L)));
        Assert.assertEquals((Object)QueryCardinalityUtil.extractCardinality((PlanNode)planBuilder.limit(3L, (PlanNode)planBuilder.values(Collections.emptyList(), (List<List<Expression>>)ImmutableList.of(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList())))), (Object)Range.singleton((Comparable)Long.valueOf(3L)));
    }

    @Test
    public void testAggregation() {
        PlanBuilder planBuilder = new PlanBuilder(new PlanNodeIdAllocator(), AbstractMockMetadata.dummyMetadata());
        Symbol symbol = planBuilder.symbol("symbol");
        TestingColumnHandle columnHandle = new TestingColumnHandle("column");
        Assert.assertEquals((Object)QueryCardinalityUtil.extractCardinality((PlanNode)planBuilder.aggregation(builder -> builder.singleGroupingSet(new Symbol[0]).source((PlanNode)planBuilder.values(10, new Symbol[0])))), (Object)Range.singleton((Comparable)Long.valueOf(1L)));
        Assert.assertEquals((Object)QueryCardinalityUtil.extractCardinality((PlanNode)planBuilder.aggregation(arg_0 -> TestCardinalityExtractorPlanVisitor.lambda$testAggregation$1(symbol, planBuilder, (ColumnHandle)columnHandle, arg_0))), (Object)Range.atLeast((Comparable)Long.valueOf(1L)));
        Assert.assertEquals((Object)QueryCardinalityUtil.extractCardinality((PlanNode)planBuilder.aggregation(builder -> builder.groupingSets(AggregationNode.groupingSets((List)ImmutableList.of((Object)symbol), (int)2, (Set)ImmutableSet.of((Object)0))).source((PlanNode)planBuilder.values(10, symbol)))), (Object)Range.closed((Comparable)Long.valueOf(1L), (Comparable)Long.valueOf(10L)));
        Assert.assertEquals((Object)QueryCardinalityUtil.extractCardinality((PlanNode)planBuilder.aggregation(builder -> builder.groupingSets(AggregationNode.groupingSets((List)ImmutableList.of((Object)symbol), (int)2, (Set)ImmutableSet.of((Object)0))).source((PlanNode)planBuilder.values(0, symbol)))), (Object)Range.singleton((Comparable)Long.valueOf(1L)));
        Assert.assertEquals((Object)QueryCardinalityUtil.extractCardinality((PlanNode)planBuilder.aggregation(arg_0 -> TestCardinalityExtractorPlanVisitor.lambda$testAggregation$4(symbol, planBuilder, (ColumnHandle)columnHandle, arg_0))), (Object)Range.atLeast((Comparable)Long.valueOf(0L)));
        Assert.assertEquals((Object)QueryCardinalityUtil.extractCardinality((PlanNode)planBuilder.aggregation(builder -> builder.singleGroupingSet(symbol).source((PlanNode)planBuilder.values(10, symbol)))), (Object)Range.closed((Comparable)Long.valueOf(1L), (Comparable)Long.valueOf(10L)));
        Assert.assertEquals((Object)QueryCardinalityUtil.extractCardinality((PlanNode)planBuilder.aggregation(builder -> builder.singleGroupingSet(symbol).source((PlanNode)planBuilder.values(0, symbol)))), (Object)Range.singleton((Comparable)Long.valueOf(0L)));
    }

    private static /* synthetic */ void lambda$testAggregation$4(Symbol symbol, PlanBuilder planBuilder, ColumnHandle columnHandle, PlanBuilder.AggregationBuilder builder) {
        builder.singleGroupingSet(symbol).source((PlanNode)planBuilder.tableScan((List<Symbol>)ImmutableList.of((Object)symbol), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)symbol, (Object)columnHandle)));
    }

    private static /* synthetic */ void lambda$testAggregation$1(Symbol symbol, PlanBuilder planBuilder, ColumnHandle columnHandle, PlanBuilder.AggregationBuilder builder) {
        builder.groupingSets(AggregationNode.groupingSets((List)ImmutableList.of((Object)symbol), (int)2, (Set)ImmutableSet.of((Object)0))).source((PlanNode)planBuilder.tableScan((List<Symbol>)ImmutableList.of((Object)symbol), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)symbol, (Object)columnHandle)));
    }
}

