/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.query;

import io.trino.Session;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.TestingSession;
import org.assertj.core.api.Assertions;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestPrecomputedHashes {
    private QueryAssertions assertions;

    @BeforeClass
    public void init() {
        Session session = TestingSession.testSessionBuilder().setSystemProperty("optimize_hash_generation", "true").build();
        this.assertions = new QueryAssertions(session);
    }

    @AfterClass(alwaysRun=true)
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testDistinctLimit() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT a FROM (    SELECT a, b    FROM (VALUES (1, 2)) t(a, b)    WHERE a = 1    GROUP BY a, b    LIMIT 1)GROUP BY a")))).matches("VALUES (1)");
    }

    @Test
    public void testUnionAllAndDistinctLimit() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("WITH t(a, b) AS (VALUES (1, 10))SELECT  count(DISTINCT if(type='A', a)),  count(DISTINCT if(type='A', b))FROM (    SELECT a, b, 'A' AS type    FROM t    GROUP BY a, b    UNION ALL    SELECT a, b, 'B' AS type    FROM t    GROUP BY a, b)")))).matches("VALUES (BIGINT '1', BIGINT '1')");
    }
}

