/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.query;

import io.trino.sql.query.QueryAssertions;
import io.trino.testing.MaterializedResult;
import io.trino.testing.MaterializedRow;
import java.util.ArrayList;
import java.util.Random;
import org.assertj.core.api.Assertions;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestTDigestFunctions {
    private QueryAssertions assertions;

    @BeforeClass
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterClass(alwaysRun=true)
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testValueAtQuantile() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT value_at_quantile(tdigest_agg(d), 0.75e0) FROM (VALUES 0.1e0, 0.2e0, 0.3e0, 0.4e0) T(d)")))).matches("VALUES 0.4e0");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT value_at_quantile(tdigest_agg(d), 0.75e0) FROM (VALUES -0.1e0, -0.2e0, -0.3e0, -0.4e0) T(d)")))).matches("VALUES -0.1e0");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT value_at_quantile(tdigest_agg(d), 0.9e0) FROM (VALUES 0.1e0, 0.1e0, 0.1e0, 0.1e0, 10e0) T(d)")))).matches("VALUES 10e0");
    }

    @Test
    public void testValuesAtQuantiles() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT values_at_quantiles(tdigest_agg(d), ARRAY[0.0001e0, 0.75e0, 0.85e0]) FROM (VALUES 0.1e0, 0.2e0, 0.3e0, 0.4e0) T(d)")))).matches("VALUES ARRAY[0.1e0, 0.4e0, 0.4e0]");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT values_at_quantiles(tdigest_agg(d), ARRAY[0.0001e0, 0.75e0, 0.85e0]) FROM (VALUES -0.1e0, -0.2e0, -0.3e0, -0.4e0) T(d)")))).matches("VALUES ARRAY[-0.4e0, -0.1e0, -0.10]");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT values_at_quantiles(tdigest_agg(d), ARRAY[0.0001e0, 0.75e0, 0.85e0]) FROM (VALUES 0.1e0, 0.1e0, 0.1e0, 0.1e0, 10e0) T(d)")))).matches("VALUES ARRAY[0.1e0, 0.1e0, 10.0e0]");
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT values_at_quantiles(tdigest_agg(d), ARRAY[1e0, 0e0]) FROM (VALUES 0.1e0) T(d)")).hasMessage("percentiles must be sorted in increasing order");
    }

    @Test
    public void testEmptyArrayOfQuantiles() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT values_at_quantiles(tdigest_agg(d), ARRAY[]) FROM (VALUES 0.1e0, 0.2e0, 0.3e0, 0.4e0) T(d)")))).matches("VALUES CAST(ARRAY[] AS array(double))");
    }

    @Test
    public void testEmptyTDigestInput() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT tdigest_agg(d) FROM (SELECT 1e0 WHERE false) T(d)")))).matches("VALUES CAST(null AS tdigest)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT values_at_quantiles(qdigest_agg(d), ARRAY[0.5e0]) FROM (SELECT 1e0 WHERE false) T(d)")))).matches("VALUES CAST(null AS array(double))");
    }

    @Test
    public void testAccuracyAtHighAndLowPercentiles() {
        int size = 2000;
        Random random = new Random(1L);
        long[] values = random.longs(size - 1, 0L, 1000L).toArray();
        long[] weights = random.longs(size - 1, 1L, 10L).toArray();
        StringBuilder builder = new StringBuilder("VALUES (BIGINT '1', BIGINT '1')");
        for (int i = 0; i < size - 1; ++i) {
            builder.append(", (");
            builder.append(values[i]);
            builder.append(", ");
            builder.append(weights[i]);
            builder.append(")");
        }
        String percentilesArray = "ARRAY[0.00001, 0.0001, 0.001, 0.01, 0.99, 0.999, 0.9999, 0.99999]";
        MaterializedResult tDigestResult = this.assertions.getQueryRunner().execute(this.assertions.getDefaultSession(), "SELECT values_at_quantiles(tdigest_agg(n, w), " + percentilesArray + ") FROM (" + builder.toString() + ") T(n, w)");
        MaterializedResult qDigestResult = this.assertions.getQueryRunner().execute(this.assertions.getDefaultSession(), "SELECT values_at_quantiles(qdigest_agg(n, w, 0.00001), " + percentilesArray + ") FROM (" + builder.toString() + ") T(n, w)");
        ArrayList tDigestValuesAtPercentiles = (ArrayList)((MaterializedRow)tDigestResult.getMaterializedRows().get(0)).getField(0);
        ArrayList qDigestValuesAtPercentiles = (ArrayList)((MaterializedRow)qDigestResult.getMaterializedRows().get(0)).getField(0);
        for (int i = 0; i < tDigestValuesAtPercentiles.size(); ++i) {
            Assertions.assertThat((boolean)((Long)qDigestValuesAtPercentiles.get(i)).equals(Math.round((Double)tDigestValuesAtPercentiles.get(i)))).isTrue();
        }
    }

    @Test
    public void testCastOperators() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT values_at_quantiles(CAST(CAST(tdigest_agg(d) AS varbinary) AS tdigest), ARRAY[0, 1]) FROM (VALUES 1, 2, 3) T(d)")))).matches("VALUES CAST(ARRAY[1, 3] AS array(double))");
    }
}

