/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.relational;

import com.google.common.collect.ImmutableList;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataManager;
import io.trino.metadata.ResolvedFunction;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.relational.CallExpression;
import io.trino.sql.relational.DeterminismEvaluator;
import io.trino.sql.relational.Expressions;
import io.trino.sql.relational.InputReferenceExpression;
import io.trino.sql.relational.RowExpression;
import io.trino.sql.tree.QualifiedName;
import java.util.Collections;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDeterminismEvaluator {
    @Test
    public void testDeterminismEvaluator() {
        MetadataManager metadata = MetadataManager.createTestMetadataManager();
        DeterminismEvaluator determinismEvaluator = new DeterminismEvaluator((Metadata)metadata);
        CallExpression random = new CallExpression(metadata.resolveFunction(QualifiedName.of((String)"random"), TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT})), Collections.singletonList(Expressions.constant((Object)10L, (Type)BigintType.BIGINT)));
        Assert.assertFalse((boolean)determinismEvaluator.isDeterministic((RowExpression)random));
        InputReferenceExpression col0 = Expressions.field((int)0, (Type)BigintType.BIGINT);
        ResolvedFunction lessThan = metadata.resolveOperator(OperatorType.LESS_THAN, (List)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT));
        CallExpression lessThanExpression = new CallExpression(lessThan, (List)ImmutableList.of((Object)col0, (Object)Expressions.constant((Object)10L, (Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)determinismEvaluator.isDeterministic((RowExpression)lessThanExpression));
        CallExpression lessThanRandomExpression = new CallExpression(lessThan, (List)ImmutableList.of((Object)col0, (Object)random));
        Assert.assertFalse((boolean)determinismEvaluator.isDeterministic((RowExpression)lessThanRandomExpression));
    }
}

