/*
 * Decompiled with CFR 0.152.
 */
package io.trino.transaction;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.Duration;
import io.trino.connector.CatalogName;
import io.trino.metadata.CatalogMetadata;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.transaction.IsolationLevel;
import io.trino.transaction.TransactionId;
import io.trino.transaction.TransactionInfo;
import io.trino.transaction.TransactionManager;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.joda.time.DateTime;

public class TestingTransactionManager
implements TransactionManager {
    private final Map<TransactionId, Object> transactions = new ConcurrentHashMap<TransactionId, Object>();

    public boolean transactionExists(TransactionId transactionId) {
        return this.transactions.containsKey(transactionId);
    }

    public TransactionInfo getTransactionInfo(TransactionId transactionId) {
        Preconditions.checkArgument((boolean)this.transactions.containsKey(transactionId), (Object)"Unknown transaction");
        return new TransactionInfo(transactionId, IsolationLevel.READ_UNCOMMITTED, false, false, DateTime.now(), Duration.succinctNanos((long)0L), (List)ImmutableList.of(), Optional.empty());
    }

    public List<TransactionInfo> getAllTransactionInfos() {
        return (List)this.transactions.keySet().stream().map(this::getTransactionInfo).collect(ImmutableList.toImmutableList());
    }

    public TransactionId beginTransaction(boolean autoCommitContext) {
        TransactionId transaction = TransactionId.create();
        this.transactions.put(transaction, new Object());
        return transaction;
    }

    public TransactionId beginTransaction(IsolationLevel isolationLevel, boolean readOnly, boolean autoCommitContext) {
        return this.beginTransaction(autoCommitContext);
    }

    public Map<String, CatalogName> getCatalogNames(TransactionId transactionId) {
        return ImmutableMap.of();
    }

    public Optional<CatalogMetadata> getOptionalCatalogMetadata(TransactionId transactionId, String catalogName) {
        return Optional.empty();
    }

    public CatalogMetadata getCatalogMetadata(TransactionId transactionId, CatalogName catalogName) {
        throw new UnsupportedOperationException();
    }

    public CatalogMetadata getCatalogMetadataForWrite(TransactionId transactionId, CatalogName catalogName) {
        throw new UnsupportedOperationException();
    }

    public CatalogMetadata getCatalogMetadataForWrite(TransactionId transactionId, String catalogName) {
        throw new UnsupportedOperationException();
    }

    public ConnectorTransactionHandle getConnectorTransaction(TransactionId transactionId, CatalogName catalogName) {
        throw new UnsupportedOperationException();
    }

    public void checkAndSetActive(TransactionId transactionId) {
        throw new UnsupportedOperationException();
    }

    public void trySetActive(TransactionId transactionId) {
        throw new UnsupportedOperationException();
    }

    public void trySetInactive(TransactionId transactionId) {
        throw new UnsupportedOperationException();
    }

    public ListenableFuture<Void> asyncCommit(TransactionId transactionId) {
        Preconditions.checkState((this.transactions.remove(transactionId) != null ? 1 : 0) != 0, (Object)"Transaction is already finished");
        return Futures.immediateVoidFuture();
    }

    public ListenableFuture<Void> asyncAbort(TransactionId transactionId) {
        Preconditions.checkState((this.transactions.remove(transactionId) != null ? 1 : 0) != 0, (Object)"Transaction is already finished");
        return Futures.immediateVoidFuture();
    }

    public void fail(TransactionId transactionId) {
        Preconditions.checkState((this.transactions.remove(transactionId) != null ? 1 : 0) != 0, (Object)"Transaction is already finished");
    }
}

