/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import io.trino.operator.scalar.AbstractTestFunctions;
import org.testng.annotations.Test;

public class TestDecimalToDecimalCasts
extends AbstractTestFunctions {
    @Test
    public void testShortDecimalToShortDecimalCasts() {
        this.assertDecimalFunction("CAST(DECIMAL '0' AS DECIMAL(1, 0))", TestDecimalToDecimalCasts.decimal("0"));
        this.assertDecimalFunction("CAST(DECIMAL '0' AS DECIMAL(2, 0))", TestDecimalToDecimalCasts.decimal("00"));
        this.assertDecimalFunction("CAST(DECIMAL '0' AS DECIMAL(3, 2))", TestDecimalToDecimalCasts.decimal("0.00"));
        this.assertDecimalFunction("CAST(DECIMAL '2' AS DECIMAL(1, 0))", TestDecimalToDecimalCasts.decimal("2"));
        this.assertDecimalFunction("CAST(DECIMAL '-2' AS DECIMAL(1, 0))", TestDecimalToDecimalCasts.decimal("-2"));
        this.assertDecimalFunction("CAST(DECIMAL '2.0' AS DECIMAL(2, 1))", TestDecimalToDecimalCasts.decimal("2.0"));
        this.assertDecimalFunction("CAST(DECIMAL '-2.0' AS DECIMAL(2, 1))", TestDecimalToDecimalCasts.decimal("-2.0"));
        this.assertDecimalFunction("CAST(DECIMAL '2.0' AS DECIMAL(2, 0))", TestDecimalToDecimalCasts.decimal("02"));
        this.assertDecimalFunction("CAST(DECIMAL '-2.0' AS DECIMAL(2, 0))", TestDecimalToDecimalCasts.decimal("-02"));
        this.assertDecimalFunction("CAST(DECIMAL '2.0' AS DECIMAL(3, 2))", TestDecimalToDecimalCasts.decimal("2.00"));
        this.assertDecimalFunction("CAST(DECIMAL '-2.0' AS DECIMAL(3, 2))", TestDecimalToDecimalCasts.decimal("-2.00"));
        this.assertDecimalFunction("CAST(DECIMAL '1.449' AS DECIMAL(2, 1))", TestDecimalToDecimalCasts.decimal("1.4"));
        this.assertDecimalFunction("CAST(DECIMAL '1.459' AS DECIMAL(2, 1))", TestDecimalToDecimalCasts.decimal("1.5"));
        this.assertDecimalFunction("CAST(DECIMAL '-1.449' AS DECIMAL(2, 1))", TestDecimalToDecimalCasts.decimal("-1.4"));
        this.assertDecimalFunction("CAST(DECIMAL '-1.459' AS DECIMAL(2, 1))", TestDecimalToDecimalCasts.decimal("-1.5"));
        this.assertInvalidCast("CAST(DECIMAL '12345.6' AS DECIMAL(4,0))", "Cannot cast DECIMAL(6, 1) '12345.6' to DECIMAL(4, 0)");
        this.assertInvalidCast("CAST(DECIMAL '-12345.6' AS DECIMAL(4,0))", "Cannot cast DECIMAL(6, 1) '-12345.6' to DECIMAL(4, 0)");
        this.assertInvalidCast("CAST(DECIMAL '12345.6' AS DECIMAL(4,2))", "Cannot cast DECIMAL(6, 1) '12345.6' to DECIMAL(4, 2)");
        this.assertInvalidCast("CAST(DECIMAL '-12345.6' AS DECIMAL(4,2))", "Cannot cast DECIMAL(6, 1) '-12345.6' to DECIMAL(4, 2)");
    }

    @Test
    public void testShortDecimalToLongDecimalCasts() {
        this.assertDecimalFunction("CAST(DECIMAL '1.2345' AS DECIMAL(21, 20))", TestDecimalToDecimalCasts.decimal("1.23450000000000000000"));
        this.assertDecimalFunction("CAST(DECIMAL '-1.2345' AS DECIMAL(21, 20))", TestDecimalToDecimalCasts.decimal("-1.23450000000000000000"));
    }

    @Test
    public void testLongDecimalToShortDecimalCasts() {
        this.assertDecimalFunction("CAST(DECIMAL '1.23450000000000000000' AS DECIMAL(5, 4))", TestDecimalToDecimalCasts.decimal("1.2345"));
        this.assertDecimalFunction("CAST(DECIMAL '-1.23450000000000000000' AS DECIMAL(5, 4))", TestDecimalToDecimalCasts.decimal("-1.2345"));
    }

    @Test
    public void testLongDecimalToLongDecimalCasts() {
        this.assertDecimalFunction("CAST(DECIMAL '0.00000000000000000000' AS DECIMAL(21, 20))", TestDecimalToDecimalCasts.decimal("0.00000000000000000000"));
        this.assertDecimalFunction("CAST(DECIMAL '0.00000000000000000000' AS DECIMAL(22, 20))", TestDecimalToDecimalCasts.decimal("00.00000000000000000000"));
        this.assertDecimalFunction("CAST(DECIMAL '0.00000000000000000000' AS DECIMAL(23, 20))", TestDecimalToDecimalCasts.decimal("000.00000000000000000000"));
        this.assertDecimalFunction("CAST(DECIMAL '2.00000000000000000000' AS DECIMAL(20, 19))", TestDecimalToDecimalCasts.decimal("2.0000000000000000000"));
        this.assertDecimalFunction("CAST(DECIMAL '-2.00000000000000000000' AS DECIMAL(20, 19))", TestDecimalToDecimalCasts.decimal("-2.0000000000000000000"));
        this.assertDecimalFunction("CAST(DECIMAL '2.00000000000000000000' AS DECIMAL(21, 20))", TestDecimalToDecimalCasts.decimal("2.00000000000000000000"));
        this.assertDecimalFunction("CAST(DECIMAL '-2.00000000000000000000' AS DECIMAL(21, 20))", TestDecimalToDecimalCasts.decimal("-2.00000000000000000000"));
        this.assertDecimalFunction("CAST(DECIMAL '2.00000000000000000000' AS DECIMAL(22, 20))", TestDecimalToDecimalCasts.decimal("02.00000000000000000000"));
        this.assertDecimalFunction("CAST(DECIMAL '-2.00000000000000000000' AS DECIMAL(22, 20))", TestDecimalToDecimalCasts.decimal("-02.00000000000000000000"));
        this.assertDecimalFunction("CAST(DECIMAL '2.00000000000000000000' AS DECIMAL(22, 21))", TestDecimalToDecimalCasts.decimal("2.000000000000000000000"));
        this.assertDecimalFunction("CAST(DECIMAL '-2.00000000000000000000' AS DECIMAL(22, 21))", TestDecimalToDecimalCasts.decimal("-2.000000000000000000000"));
        this.assertDecimalFunction("CAST(DECIMAL '1.000000000000000000004' AS DECIMAL(21, 20))", TestDecimalToDecimalCasts.decimal("1.00000000000000000000"));
        this.assertDecimalFunction("CAST(DECIMAL '1.000000000000000000005' AS DECIMAL(21, 20))", TestDecimalToDecimalCasts.decimal("1.00000000000000000001"));
        this.assertDecimalFunction("CAST(DECIMAL '-1.000000000000000000004' AS DECIMAL(21, 20))", TestDecimalToDecimalCasts.decimal("-1.00000000000000000000"));
        this.assertDecimalFunction("CAST(DECIMAL '-1.000000000000000000005' AS DECIMAL(21, 20))", TestDecimalToDecimalCasts.decimal("-1.00000000000000000001"));
        this.assertInvalidCast("CAST(DECIMAL '1234500000000000000000000.6' AS DECIMAL(20,0))", "Cannot cast DECIMAL(26, 1) '1234500000000000000000000.6' to DECIMAL(20, 0)");
        this.assertInvalidCast("CAST(DECIMAL '-1234500000000000000000000.6' AS DECIMAL(20,0))", "Cannot cast DECIMAL(26, 1) '-1234500000000000000000000.6' to DECIMAL(20, 0)");
        this.assertInvalidCast("CAST(DECIMAL '1234500000000000000000000.6' AS DECIMAL(22,2))", "Cannot cast DECIMAL(26, 1) '1234500000000000000000000.6' to DECIMAL(22, 2)");
        this.assertInvalidCast("CAST(DECIMAL '-1234500000000000000000000.6' AS DECIMAL(22,2))", "Cannot cast DECIMAL(26, 1) '-1234500000000000000000000.6' to DECIMAL(22, 2)");
    }
}

