/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataManager;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.type.AbstractTestType;
import io.trino.util.StructuralTestUtil;
import java.util.List;

public class TestIntegerArrayType
extends AbstractTestType {
    public TestIntegerArrayType() {
        this((Metadata)MetadataManager.createTestMetadataManager());
    }

    private TestIntegerArrayType(Metadata metadata) {
        super(metadata.getType(TypeSignature.arrayType((TypeSignature)IntegerType.INTEGER.getTypeSignature())), List.class, TestIntegerArrayType.createTestBlock(metadata.getType(TypeSignature.arrayType((TypeSignature)IntegerType.INTEGER.getTypeSignature()))));
    }

    public static Block createTestBlock(Type arrayType) {
        BlockBuilder blockBuilder = arrayType.createBlockBuilder(null, 4);
        arrayType.writeObject(blockBuilder, (Object)StructuralTestUtil.arrayBlockOf((Type)IntegerType.INTEGER, 1, 2));
        arrayType.writeObject(blockBuilder, (Object)StructuralTestUtil.arrayBlockOf((Type)IntegerType.INTEGER, 1, 2, 3));
        arrayType.writeObject(blockBuilder, (Object)StructuralTestUtil.arrayBlockOf((Type)IntegerType.INTEGER, 1, 2, 3));
        arrayType.writeObject(blockBuilder, (Object)StructuralTestUtil.arrayBlockOf((Type)IntegerType.INTEGER, 100, 200, 300));
        return blockBuilder.build();
    }

    @Override
    protected Object getGreaterValue(Object value) {
        Block block = (Block)value;
        BlockBuilder blockBuilder = IntegerType.INTEGER.createBlockBuilder(null, block.getPositionCount() + 1);
        for (int i = 0; i < block.getPositionCount(); ++i) {
            IntegerType.INTEGER.appendTo(block, i, blockBuilder);
        }
        IntegerType.INTEGER.writeLong(blockBuilder, 1L);
        return blockBuilder.build();
    }
}

