/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.Type;
import io.trino.spi.type.UuidType;
import io.trino.type.AbstractTestType;
import io.trino.type.UuidOperators;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestUuidType
extends AbstractTestType {
    public TestUuidType() {
        super((Type)UuidType.UUID, String.class, TestUuidType.createTestBlock());
    }

    public static Block createTestBlock() {
        BlockBuilder blockBuilder = UuidType.UUID.createBlockBuilder(null, 1);
        for (int i = 0; i < 10; ++i) {
            String uuid = "6b5f5b65-67e4-43b0-8ee3-586cd49f58a" + i;
            UuidType.UUID.writeSlice(blockBuilder, UuidOperators.castFromVarcharToUuid((Slice)Slices.utf8Slice((String)uuid)));
        }
        return blockBuilder.build();
    }

    @Override
    protected Object getGreaterValue(Object value) {
        Slice slice = (Slice)value;
        return Slices.wrappedLongArray((long[])new long[]{slice.getLong(0), slice.getLong(8) + 1L});
    }

    @Override
    protected Object getNonNullValue() {
        return Slices.wrappedLongArray((long[])new long[]{0L, 0L});
    }

    @Test
    public void testDisplayName() {
        Assert.assertEquals((String)UuidType.UUID.getDisplayName(), (String)"uuid");
    }
}

