/*
 * Decompiled with CFR 0.152.
 */
package io.trino.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import io.trino.SequencePageBuilder;
import io.trino.jmh.Benchmarks;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.operator.DriverYieldSignal;
import io.trino.operator.PageWithPositionComparator;
import io.trino.operator.PagesIndex;
import io.trino.operator.WorkProcessor;
import io.trino.spi.Page;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.sql.gen.OrderingCompiler;
import io.trino.util.MergeSortedPages;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.RunnerException;
import org.testng.Assert;
import org.testng.annotations.Test;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
@Fork(value=1)
@Warmup(iterations=5, time=400, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=400, timeUnit=TimeUnit.MILLISECONDS)
public class BenchmarkPagesSort {
    private static final OrderingCompiler ORDERING_COMPILER = new OrderingCompiler(new TypeOperators());

    @Benchmark
    public List<Page> runPagesIndexSortBenchmark(PagesIndexSortBenchmarkData data) {
        PagesIndex.TestingFactory pagesIndexFactory = new PagesIndex.TestingFactory(false);
        PagesIndex pageIndex = pagesIndexFactory.newPagesIndex(data.getTypes(), data.getTotalPositions());
        for (Page page : data.getPages()) {
            pageIndex.addPage(page);
        }
        pageIndex.sort(data.getSortChannels(), data.getSortOrders());
        return (List)Streams.stream((Iterator)pageIndex.getSortedPages()).collect(ImmutableList.toImmutableList());
    }

    @Test
    public void verifyPagesIndexSortBenchmark() {
        PagesIndexSortBenchmarkData state = new PagesIndexSortBenchmarkData();
        state.setup();
        List<Page> pages = this.runPagesIndexSortBenchmark(state);
        int positionCount = pages.stream().mapToInt(Page::getPositionCount).sum();
        Assert.assertEquals((int)positionCount, (int)state.getTotalPositions());
    }

    @Benchmark
    public List<Page> runPagesMergeSortBenchmark(MergeSortedBenchmarkData data) {
        WorkProcessor sortedPagesWork = MergeSortedPages.mergeSortedPages((List)((List)data.getSplitPages().stream().map(WorkProcessor::fromIterable).collect(ImmutableList.toImmutableList())), (PageWithPositionComparator)ORDERING_COMPILER.compilePageWithPositionComparator(data.getSortTypes(), data.getSortChannels(), data.getSortOrders()), data.getOutputChannels(), data.getTypes(), (pageBuilder, pageWithPosition) -> pageBuilder.isFull(), (boolean)false, (AggregatedMemoryContext)AggregatedMemoryContext.newSimpleAggregatedMemoryContext(), (DriverYieldSignal)new DriverYieldSignal());
        ImmutableList.Builder sortedPages = ImmutableList.builder();
        while (true) {
            sortedPagesWork.process();
            if (sortedPagesWork.isFinished()) {
                return sortedPages.build();
            }
            sortedPages.add((Object)((Page)sortedPagesWork.getResult()));
        }
    }

    @Test
    public void verifyPagesMergeSortBenchmark() {
        MergeSortedBenchmarkData state = new MergeSortedBenchmarkData();
        state.setup();
        List<Page> pages = this.runPagesMergeSortBenchmark(state);
        int positionCount = pages.stream().mapToInt(Page::getPositionCount).sum();
        Assert.assertEquals((int)positionCount, (int)state.getTotalPositions());
    }

    public static void main(String[] args) throws RunnerException {
        Benchmarks.benchmark(BenchmarkPagesSort.class).run();
    }

    public static class BaseBenchmarkData {
        private List<Page> pages;
        private int totalPositions;
        private List<List<Page>> splitPages;
        private List<Type> types;
        private List<Integer> sortChannels;
        private List<Type> sortTypes;
        private List<SortOrder> sortOrders;
        private List<Integer> outputChannels;

        protected void setup(int numSortChannels, int totalChannels, int numMergeSources, int pagesCount) {
            int i;
            this.types = Collections.nCopies(totalChannels, BigintType.BIGINT);
            this.sortChannels = new ArrayList<Integer>();
            for (i = 0; i < numSortChannels; ++i) {
                this.sortChannels.add(i);
            }
            this.sortTypes = Collections.nCopies(numSortChannels, BigintType.BIGINT);
            this.sortOrders = Collections.nCopies(numSortChannels, SortOrder.ASC_NULLS_FIRST);
            this.outputChannels = new ArrayList<Integer>();
            for (i = 0; i < totalChannels; ++i) {
                this.outputChannels.add(i);
            }
            this.createPages(totalChannels, pagesCount);
            this.createPageProducers(numMergeSources);
        }

        private void createPages(int totalChannels, int pagesCount) {
            int positionCount = 0x100000 / (totalChannels * 8);
            this.pages = new ArrayList<Page>(pagesCount);
            for (int numPage = 0; numPage < pagesCount; ++numPage) {
                this.pages.add(SequencePageBuilder.createSequencePage(this.types, positionCount));
            }
            this.totalPositions = positionCount * pagesCount;
        }

        private void createPageProducers(int numMergeSources) {
            AtomicInteger counter = new AtomicInteger(0);
            this.splitPages = (List)this.pages.stream().collect(Collectors.groupingBy(it -> counter.getAndIncrement() % numMergeSources)).values().stream().collect(ImmutableList.toImmutableList());
        }

        List<Page> getPages() {
            return this.pages;
        }

        int getTotalPositions() {
            return this.totalPositions;
        }

        List<List<Page>> getSplitPages() {
            return this.splitPages;
        }

        List<Type> getTypes() {
            return this.types;
        }

        List<Integer> getSortChannels() {
            return this.sortChannels;
        }

        List<Type> getSortTypes() {
            return this.sortTypes;
        }

        List<SortOrder> getSortOrders() {
            return this.sortOrders;
        }

        List<Integer> getOutputChannels() {
            return this.outputChannels;
        }
    }

    @State(value=Scope.Thread)
    public static class MergeSortedBenchmarkData
    extends BaseBenchmarkData {
        @Param(value={"1"})
        private int numSortChannels = 1;
        @Param(value={"1", "8"})
        private int totalChannels = 1;
        @Param(value={"2", "16"})
        private int numMergeSources = 2;
        @Param(value={"200", "400"})
        private int pagesCount = 200;

        @Setup
        public void setup() {
            super.setup(this.numSortChannels, this.totalChannels, this.numMergeSources, this.pagesCount);
        }
    }

    @State(value=Scope.Thread)
    public static class PagesIndexSortBenchmarkData
    extends BaseBenchmarkData {
        @Param(value={"1"})
        private int numSortChannels = 1;
        @Param(value={"1", "8"})
        private int totalChannels = 1;
        @Param(value={"200", "400"})
        private int pagesCount = 200;

        @Setup
        public void setup() {
            super.setup(this.numSortChannels, this.totalChannels, 1, this.pagesCount);
        }
    }
}

